/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public final class WorldGenTreeProvider {
    private static final Map<String, WorldGenTreeProvider> GROWERS = new Object2ObjectArrayMap();
    public static final Codec<WorldGenTreeProvider> CODEC = Codec.stringResolver(var0 -> var0.name, GROWERS::get);
    public static final WorldGenTreeProvider OAK = new WorldGenTreeProvider("oak", 0.1f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.OAK), Optional.of(TreeFeatures.FANCY_OAK), Optional.of(TreeFeatures.OAK_BEES_005), Optional.of(TreeFeatures.FANCY_OAK_BEES_005));
    public static final WorldGenTreeProvider SPRUCE = new WorldGenTreeProvider("spruce", 0.5f, Optional.of(TreeFeatures.MEGA_SPRUCE), Optional.of(TreeFeatures.MEGA_PINE), Optional.of(TreeFeatures.SPRUCE), Optional.empty(), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider MANGROVE = new WorldGenTreeProvider("mangrove", 0.85f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.MANGROVE), Optional.of(TreeFeatures.TALL_MANGROVE), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider AZALEA = new WorldGenTreeProvider("azalea", Optional.empty(), Optional.of(TreeFeatures.AZALEA_TREE), Optional.empty());
    public static final WorldGenTreeProvider BIRCH = new WorldGenTreeProvider("birch", Optional.empty(), Optional.of(TreeFeatures.BIRCH), Optional.of(TreeFeatures.BIRCH_BEES_005));
    public static final WorldGenTreeProvider JUNGLE = new WorldGenTreeProvider("jungle", Optional.of(TreeFeatures.MEGA_JUNGLE_TREE), Optional.of(TreeFeatures.JUNGLE_TREE_NO_VINE), Optional.empty());
    public static final WorldGenTreeProvider ACACIA = new WorldGenTreeProvider("acacia", Optional.empty(), Optional.of(TreeFeatures.ACACIA), Optional.empty());
    public static final WorldGenTreeProvider CHERRY = new WorldGenTreeProvider("cherry", Optional.empty(), Optional.of(TreeFeatures.CHERRY), Optional.of(TreeFeatures.CHERRY_BEES_005));
    public static final WorldGenTreeProvider DARK_OAK = new WorldGenTreeProvider("dark_oak", Optional.of(TreeFeatures.DARK_OAK), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider PALE_OAK = new WorldGenTreeProvider("pale_oak", Optional.of(TreeFeatures.PALE_OAK_BONEMEAL), Optional.empty(), Optional.empty());
    private final String name;
    private final float secondaryChance;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> megaTree;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryMegaTree;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> tree;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryTree;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> flowers;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryFlowers;

    public WorldGenTreeProvider(String var0, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var1, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var2, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var3) {
        this(var0, 0.0f, var1, Optional.empty(), var2, Optional.empty(), var3, Optional.empty());
    }

    public WorldGenTreeProvider(String var0, float var1, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var2, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var3, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var4, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var5, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var6, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> var7) {
        this.name = var0;
        this.secondaryChance = var1;
        this.megaTree = var2;
        this.secondaryMegaTree = var3;
        this.tree = var4;
        this.secondaryTree = var5;
        this.flowers = var6;
        this.secondaryFlowers = var7;
        GROWERS.put(var0, this);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(RandomSource var0, boolean var1) {
        if (var0.nextFloat() < this.secondaryChance) {
            if (var1 && this.secondaryFlowers.isPresent()) {
                return this.secondaryFlowers.get();
            }
            if (this.secondaryTree.isPresent()) {
                return this.secondaryTree.get();
            }
        }
        if (var1 && this.flowers.isPresent()) {
            return this.flowers.get();
        }
        return this.tree.orElse(null);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> getConfiguredMegaFeature(RandomSource var0) {
        if (this.secondaryMegaTree.isPresent() && var0.nextFloat() < this.secondaryChance) {
            return this.secondaryMegaTree.get();
        }
        return this.megaTree.orElse(null);
    }

    public boolean growTree(WorldServer var0, ChunkGenerator var1, BlockPosition var2, IBlockData var3, RandomSource var4) {
        Object var6;
        ResourceKey<WorldGenFeatureConfigured<?, ?>> var5 = this.getConfiguredMegaFeature(var4);
        if (var5 != null && (var6 = (Holder)var0.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(var5).orElse(null)) != null) {
            for (int var7 = 0; var7 >= -1; --var7) {
                for (int var8 = 0; var8 >= -1; --var8) {
                    if (!WorldGenTreeProvider.isTwoByTwoSapling(var3, var0, var2, var7, var8)) continue;
                    WorldGenFeatureConfigured var9 = (WorldGenFeatureConfigured)var6.value();
                    IBlockData var10 = Blocks.AIR.defaultBlockState();
                    var0.setBlock(var2.offset(var7, 0, var8), var10, 4);
                    var0.setBlock(var2.offset(var7 + 1, 0, var8), var10, 4);
                    var0.setBlock(var2.offset(var7, 0, var8 + 1), var10, 4);
                    var0.setBlock(var2.offset(var7 + 1, 0, var8 + 1), var10, 4);
                    if (var9.place(var0, var1, var4, var2.offset(var7, 0, var8))) {
                        return true;
                    }
                    var0.setBlock(var2.offset(var7, 0, var8), var3, 4);
                    var0.setBlock(var2.offset(var7 + 1, 0, var8), var3, 4);
                    var0.setBlock(var2.offset(var7, 0, var8 + 1), var3, 4);
                    var0.setBlock(var2.offset(var7 + 1, 0, var8 + 1), var3, 4);
                    return false;
                }
            }
        }
        if ((var6 = this.getConfiguredFeature(var4, this.hasFlowers(var0, var2))) == null) {
            return false;
        }
        Holder var7 = var0.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get((ResourceKey)var6).orElse(null);
        if (var7 == null) {
            return false;
        }
        WorldGenFeatureConfigured var8 = (WorldGenFeatureConfigured)var7.value();
        IBlockData var9 = var0.getFluidState(var2).createLegacyBlock();
        var0.setBlock(var2, var9, 4);
        if (var8.place(var0, var1, var4, var2)) {
            if (var0.getBlockState(var2) == var9) {
                var0.sendBlockUpdated(var2, var3, var9, 2);
            }
            return true;
        }
        var0.setBlock(var2, var3, 4);
        return false;
    }

    private static boolean isTwoByTwoSapling(IBlockData var0, IBlockAccess var1, BlockPosition var2, int var3, int var4) {
        Block var5 = var0.getBlock();
        return var1.getBlockState(var2.offset(var3, 0, var4)).is(var5) && var1.getBlockState(var2.offset(var3 + 1, 0, var4)).is(var5) && var1.getBlockState(var2.offset(var3, 0, var4 + 1)).is(var5) && var1.getBlockState(var2.offset(var3 + 1, 0, var4 + 1)).is(var5);
    }

    private boolean hasFlowers(GeneratorAccess var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.MutableBlockPosition.betweenClosed(var1.below().north(2).west(2), var1.above().south(2).east(2))) {
            if (!var0.getBlockState(var3).is(TagsBlock.FLOWERS)) continue;
            return true;
        }
        return false;
    }
}

