/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.JukeboxSongPlayer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;

public class TileEntityJukeBox
extends TileEntity
implements ContainerSingleItem.a {
    public static final String SONG_ITEM_TAG_ID = "RecordItem";
    public static final String TICKS_SINCE_SONG_STARTED_TAG_ID = "ticks_since_song_started";
    private ItemStack item = ItemStack.EMPTY;
    private final JukeboxSongPlayer jukeboxSongPlayer = new JukeboxSongPlayer(this::onSongChanged, this.getBlockPos());

    public TileEntityJukeBox(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JUKEBOX, var0, var1);
    }

    public JukeboxSongPlayer getSongPlayer() {
        return this.jukeboxSongPlayer;
    }

    public void onSongChanged() {
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.setChanged();
    }

    private void notifyItemChangedInJukebox(boolean var0) {
        if (this.level == null || this.level.getBlockState(this.getBlockPos()) != this.getBlockState()) {
            return;
        }
        this.level.setBlock(this.getBlockPos(), (IBlockData)this.getBlockState().setValue(BlockJukeBox.HAS_RECORD, var0), 2);
        this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.a.of(this.getBlockState()));
    }

    public void popOutTheItem() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockPosition var0 = this.getBlockPos();
        ItemStack var1 = this.getTheItem();
        if (var1.isEmpty()) {
            return;
        }
        this.removeTheItem();
        Vec3D var2 = Vec3D.atLowerCornerWithOffset(var0, 0.5, 1.01, 0.5).offsetRandom(this.level.random, 0.7f);
        ItemStack var3 = var1.copy();
        EntityItem var4 = new EntityItem(this.level, var2.x(), var2.y(), var2.z(), var3);
        var4.setDefaultPickUpDelay();
        this.level.addFreshEntity(var4);
    }

    public static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntityJukeBox var3) {
        var3.jukeboxSongPlayer.tick(var0, var2);
    }

    public int getComparatorOutput() {
        return JukeboxSong.fromStack(this.level.registryAccess(), this.item).map(Holder::value).map(JukeboxSong::comparatorOutput).orElse(0);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var12) {
        super.loadAdditional(var0, var12);
        if (var0.contains(SONG_ITEM_TAG_ID, 10)) {
            this.item = ItemStack.parse(var12, var0.getCompound(SONG_ITEM_TAG_ID)).orElse(ItemStack.EMPTY);
        } else {
            if (!this.item.isEmpty()) {
                this.jukeboxSongPlayer.stop(this.level, this.getBlockState());
            }
            this.item = ItemStack.EMPTY;
        }
        if (var0.contains(TICKS_SINCE_SONG_STARTED_TAG_ID, 4)) {
            JukeboxSong.fromStack(var12, this.item).ifPresent(var1 -> this.jukeboxSongPlayer.setSongWithoutPlaying((Holder<JukeboxSong>)var1, var0.getLong(TICKS_SINCE_SONG_STARTED_TAG_ID)));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (!this.getTheItem().isEmpty()) {
            var0.put(SONG_ITEM_TAG_ID, this.getTheItem().save(var1));
        }
        if (this.jukeboxSongPlayer.getSong() != null) {
            var0.putLong(TICKS_SINCE_SONG_STARTED_TAG_ID, this.jukeboxSongPlayer.getTicksSinceSongStarted());
        }
    }

    @Override
    public ItemStack getTheItem() {
        return this.item;
    }

    @Override
    public ItemStack splitTheItem(int var0) {
        ItemStack var1 = this.item;
        this.setTheItem(ItemStack.EMPTY);
        return var1;
    }

    @Override
    public void setTheItem(ItemStack var0) {
        this.item = var0;
        boolean var1 = !this.item.isEmpty();
        Optional<Holder<JukeboxSong>> var2 = JukeboxSong.fromStack(this.level.registryAccess(), this.item);
        this.notifyItemChangedInJukebox(var1);
        if (var1 && var2.isPresent()) {
            this.jukeboxSongPlayer.play(this.level, var2.get());
        } else {
            this.jukeboxSongPlayer.stop(this.level, this.getBlockState());
        }
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public TileEntity getContainerBlockEntity() {
        return this;
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        return var1.has(DataComponents.JUKEBOX_PLAYABLE) && this.getItem(var0).isEmpty();
    }

    @Override
    public boolean canTakeItem(IInventory var0, int var1, ItemStack var2) {
        return var0.hasAnyMatching(ItemStack::isEmpty);
    }

    @VisibleForTesting
    public void setSongItemWithoutPlaying(ItemStack var02) {
        this.item = var02;
        JukeboxSong.fromStack(this.level.registryAccess(), var02).ifPresent(var0 -> this.jukeboxSongPlayer.setSongWithoutPlaying((Holder<JukeboxSong>)var0, 0L));
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.setChanged();
    }

    @VisibleForTesting
    public void tryForcePlaySong() {
        JukeboxSong.fromStack(this.level.registryAccess(), this.getTheItem()).ifPresent(var0 -> this.jukeboxSongPlayer.play(this.level, (Holder<JukeboxSong>)var0));
    }
}

