/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ARGB;
import net.minecraft.world.ChestLock;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;

public class TileEntityBeacon
extends TileEntity
implements ITileInventory,
INamableTileEntity {
    private static final int MAX_LEVELS = 4;
    public static final List<List<Holder<MobEffectList>>> BEACON_EFFECTS = List.of(List.of(MobEffects.MOVEMENT_SPEED, MobEffects.DIG_SPEED), List.of(MobEffects.DAMAGE_RESISTANCE, MobEffects.JUMP), List.of(MobEffects.DAMAGE_BOOST), List.of(MobEffects.REGENERATION));
    private static final Set<Holder<MobEffectList>> VALID_EFFECTS = BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_SECONDARY = 2;
    public static final int NUM_DATA_VALUES = 3;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.translatable("container.beacon");
    private static final String TAG_PRIMARY = "primary_effect";
    private static final String TAG_SECONDARY = "secondary_effect";
    List<BeaconColorTracker> beamSections = Lists.newArrayList();
    private List<BeaconColorTracker> checkingBeamSections = Lists.newArrayList();
    public int levels;
    private int lastCheckY;
    @Nullable
    public Holder<MobEffectList> primaryPower;
    @Nullable
    public Holder<MobEffectList> secondaryPower;
    @Nullable
    public IChatBaseComponent name;
    public ChestLock lockKey = ChestLock.NO_LOCK;
    private final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            return switch (var0) {
                case 0 -> TileEntityBeacon.this.levels;
                case 1 -> ContainerBeacon.encodeEffect(TileEntityBeacon.this.primaryPower);
                case 2 -> ContainerBeacon.encodeEffect(TileEntityBeacon.this.secondaryPower);
                default -> 0;
            };
        }

        @Override
        public void set(int var0, int var1) {
            switch (var0) {
                case 0: {
                    TileEntityBeacon.this.levels = var1;
                    break;
                }
                case 1: {
                    if (!TileEntityBeacon.this.level.isClientSide && !TileEntityBeacon.this.beamSections.isEmpty()) {
                        TileEntityBeacon.playSound(TileEntityBeacon.this.level, TileEntityBeacon.this.worldPosition, SoundEffects.BEACON_POWER_SELECT);
                    }
                    TileEntityBeacon.this.primaryPower = TileEntityBeacon.filterEffect(ContainerBeacon.decodeEffect(var1));
                    break;
                }
                case 2: {
                    TileEntityBeacon.this.secondaryPower = TileEntityBeacon.filterEffect(ContainerBeacon.decodeEffect(var1));
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };

    @Nullable
    static Holder<MobEffectList> filterEffect(@Nullable Holder<MobEffectList> var0) {
        return VALID_EFFECTS.contains(var0) ? var0 : null;
    }

    public TileEntityBeacon(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BEACON, var0, var1);
    }

    public static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntityBeacon var3) {
        int var10;
        BlockPosition var7;
        int var4 = var1.getX();
        int var5 = var1.getY();
        int var6 = var1.getZ();
        if (var3.lastCheckY < var5) {
            var7 = var1;
            var3.checkingBeamSections = Lists.newArrayList();
            var3.lastCheckY = var7.getY() - 1;
        } else {
            var7 = new BlockPosition(var4, var3.lastCheckY + 1, var6);
        }
        BeaconColorTracker var8 = var3.checkingBeamSections.isEmpty() ? null : var3.checkingBeamSections.get(var3.checkingBeamSections.size() - 1);
        int var9 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var4, var6);
        for (var10 = 0; var10 < 10 && var7.getY() <= var9; ++var10) {
            block18: {
                IBlockData var11;
                block16: {
                    int var14;
                    block17: {
                        var11 = var0.getBlockState(var7);
                        Block var12 = var11.getBlock();
                        if (!(var12 instanceof IBeaconBeam)) break block16;
                        IBeaconBeam var13 = (IBeaconBeam)((Object)var12);
                        var14 = var13.getColor().getTextureDiffuseColor();
                        if (var3.checkingBeamSections.size() > 1) break block17;
                        var8 = new BeaconColorTracker(var14);
                        var3.checkingBeamSections.add(var8);
                        break block18;
                    }
                    if (var8 == null) break block18;
                    if (var14 == var8.color) {
                        var8.increaseHeight();
                    } else {
                        var8 = new BeaconColorTracker(ARGB.average(var8.color, var14));
                        var3.checkingBeamSections.add(var8);
                    }
                    break block18;
                }
                if (var8 != null && (var11.getLightBlock() < 15 || var11.is(Blocks.BEDROCK))) {
                    var8.increaseHeight();
                } else {
                    var3.checkingBeamSections.clear();
                    var3.lastCheckY = var9;
                    break;
                }
            }
            var7 = var7.above();
            ++var3.lastCheckY;
        }
        var10 = var3.levels;
        if (var0.getGameTime() % 80L == 0L) {
            if (!var3.beamSections.isEmpty()) {
                var3.levels = TileEntityBeacon.updateBase(var0, var4, var5, var6);
            }
            if (var3.levels > 0 && !var3.beamSections.isEmpty()) {
                TileEntityBeacon.applyEffects(var0, var1, var3.levels, var3.primaryPower, var3.secondaryPower);
                TileEntityBeacon.playSound(var0, var1, SoundEffects.BEACON_AMBIENT);
            }
        }
        if (var3.lastCheckY >= var9) {
            var3.lastCheckY = var0.getMinY() - 1;
            boolean var11 = var10 > 0;
            var3.beamSections = var3.checkingBeamSections;
            if (!var0.isClientSide) {
                boolean var12;
                boolean bl = var12 = var3.levels > 0;
                if (!var11 && var12) {
                    TileEntityBeacon.playSound(var0, var1, SoundEffects.BEACON_ACTIVATE);
                    for (EntityPlayer var14 : var0.getEntitiesOfClass(EntityPlayer.class, new AxisAlignedBB(var4, var5, var6, var4, var5 - 4, var6).inflate(10.0, 5.0, 10.0))) {
                        CriterionTriggers.CONSTRUCT_BEACON.trigger(var14, var3.levels);
                    }
                } else if (var11 && !var12) {
                    TileEntityBeacon.playSound(var0, var1, SoundEffects.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(World var0, int var1, int var2, int var3) {
        int var6;
        int var4 = 0;
        int var5 = 1;
        while (var5 <= 4 && (var6 = var2 - var5) >= var0.getMinY()) {
            boolean var7 = true;
            block1: for (int var8 = var1 - var5; var8 <= var1 + var5 && var7; ++var8) {
                for (int var9 = var3 - var5; var9 <= var3 + var5; ++var9) {
                    if (var0.getBlockState(new BlockPosition(var8, var6, var9)).is(TagsBlock.BEACON_BASE_BLOCKS)) continue;
                    var7 = false;
                    continue block1;
                }
            }
            if (!var7) break;
            var4 = var5++;
        }
        return var4;
    }

    @Override
    public void setRemoved() {
        TileEntityBeacon.playSound(this.level, this.worldPosition, SoundEffects.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    private static void applyEffects(World var0, BlockPosition var1, int var2, @Nullable Holder<MobEffectList> var3, @Nullable Holder<MobEffectList> var4) {
        if (var0.isClientSide || var3 == null) {
            return;
        }
        double var5 = var2 * 10 + 10;
        int var7 = 0;
        if (var2 >= 4 && Objects.equals(var3, var4)) {
            var7 = 1;
        }
        int var8 = (9 + var2 * 2) * 20;
        AxisAlignedBB var9 = new AxisAlignedBB(var1).inflate(var5).expandTowards(0.0, var0.getHeight(), 0.0);
        List<EntityHuman> var10 = var0.getEntitiesOfClass(EntityHuman.class, var9);
        for (EntityHuman var12 : var10) {
            var12.addEffect(new MobEffect(var3, var8, var7, true, true));
        }
        if (var2 >= 4 && !Objects.equals(var3, var4) && var4 != null) {
            for (EntityHuman var12 : var10) {
                var12.addEffect(new MobEffect(var4, var8, 0, true, true));
            }
        }
    }

    public static void playSound(World var0, BlockPosition var1, SoundEffect var2) {
        var0.playSound(null, var1, var2, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public List<BeaconColorTracker> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    private static void storeEffect(NBTTagCompound var0, String var1, @Nullable Holder<MobEffectList> var22) {
        if (var22 != null) {
            var22.unwrapKey().ifPresent(var2 -> var0.putString(var1, var2.location().toString()));
        }
    }

    @Nullable
    private static Holder<MobEffectList> loadEffect(NBTTagCompound var0, String var1) {
        if (var0.contains(var1, 8)) {
            MinecraftKey var2 = MinecraftKey.tryParse(var0.getString(var1));
            if (var2 == null) {
                return null;
            }
            return BuiltInRegistries.MOB_EFFECT.get(var2).map(TileEntityBeacon::filterEffect).orElse(null);
        }
        return null;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.primaryPower = TileEntityBeacon.loadEffect(var0, TAG_PRIMARY);
        this.secondaryPower = TileEntityBeacon.loadEffect(var0, TAG_SECONDARY);
        if (var0.contains("CustomName", 8)) {
            this.name = TileEntityBeacon.parseCustomNameSafe(var0.getString("CustomName"), var1);
        }
        this.lockKey = ChestLock.fromTag(var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        TileEntityBeacon.storeEffect(var0, TAG_PRIMARY, this.primaryPower);
        TileEntityBeacon.storeEffect(var0, TAG_SECONDARY, this.secondaryPower);
        var0.putInt("Levels", this.levels);
        if (this.name != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name, var1));
        }
        this.lockKey.addToTag(var0, var1);
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.name = var0;
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (TileEntityContainer.canUnlock(var2, this.lockKey, this.getDisplayName())) {
            return new ContainerBeacon(var0, var1, this.dataAccess, ContainerAccess.create(this.level, this.getBlockPos()));
        }
        return null;
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return this.getName();
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return DEFAULT_NAME;
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b var0) {
        super.applyImplicitComponents(var0);
        this.name = var0.get(DataComponents.CUSTOM_NAME);
        this.lockKey = var0.getOrDefault(DataComponents.LOCK, ChestLock.NO_LOCK);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(ChestLock.NO_LOCK)) {
            var0.set(DataComponents.LOCK, this.lockKey);
        }
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        var0.remove("CustomName");
        var0.remove("lock");
    }

    @Override
    public void setLevel(World var0) {
        super.setLevel(var0);
        this.lastCheckY = var0.getMinY() - 1;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static class BeaconColorTracker {
        final int color;
        private int height;

        public BeaconColorTracker(int var0) {
            this.color = var0;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        public int getColor() {
            return this.color;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

