/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityBarrel
extends TileEntityLootable {
    private NonNullList<ItemStack> items = NonNullList.withSize(27, ItemStack.EMPTY);
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(World var0, BlockPosition var1, IBlockData var2) {
            TileEntityBarrel.this.playSound(var2, SoundEffects.BARREL_OPEN);
            TileEntityBarrel.this.updateBlockState(var2, true);
        }

        @Override
        protected void onClose(World var0, BlockPosition var1, IBlockData var2) {
            TileEntityBarrel.this.playSound(var2, SoundEffects.BARREL_CLOSE);
            TileEntityBarrel.this.updateBlockState(var2, false);
        }

        @Override
        protected void openerCountChanged(World var0, BlockPosition var1, IBlockData var2, int var3, int var4) {
        }

        @Override
        protected boolean isOwnContainer(EntityHuman var0) {
            if (var0.containerMenu instanceof ContainerChest) {
                IInventory var1 = ((ContainerChest)var0.containerMenu).getContainer();
                return var1 == TileEntityBarrel.this;
            }
            return false;
        }
    };

    public TileEntityBarrel(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BARREL, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items, var1);
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items, var1);
        }
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.barrel");
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return ContainerChest.threeRows(var0, var1, this);
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.incrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.decrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateBlockState(IBlockData var0, boolean var1) {
        this.level.setBlock(this.getBlockPos(), (IBlockData)var0.setValue(BlockBarrel.OPEN, var1), 3);
    }

    public void playSound(IBlockData var0, SoundEffect var1) {
        BaseBlockPosition var2 = var0.getValue(BlockBarrel.FACING).getUnitVec3i();
        double var3 = (double)this.worldPosition.getX() + 0.5 + (double)var2.getX() / 2.0;
        double var5 = (double)this.worldPosition.getY() + 0.5 + (double)var2.getY() / 2.0;
        double var7 = (double)this.worldPosition.getZ() + 0.5 + (double)var2.getZ() / 2.0;
        this.level.playSound(null, var3, var5, var7, var1, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

