/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public abstract class TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TileEntityTypes<?> type;
    @Nullable
    protected World level;
    protected final BlockPosition worldPosition;
    protected boolean remove;
    private IBlockData blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public TileEntity(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        this.type = var0;
        this.worldPosition = var1.immutable();
        this.validateBlockState(var2);
        this.blockState = var2;
    }

    private void validateBlockState(IBlockData var0) {
        if (!this.isValidBlockState(var0)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(var0));
        }
    }

    public boolean isValidBlockState(IBlockData var0) {
        return this.type.isValid(var0);
    }

    public static BlockPosition getPosFromTag(NBTTagCompound var0) {
        return new BlockPosition(var0.getInt("x"), var0.getInt("y"), var0.getInt("z"));
    }

    @Nullable
    public World getLevel() {
        return this.level;
    }

    public void setLevel(World var0) {
        this.level = var0;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
    }

    public final void loadWithComponents(NBTTagCompound var02, HolderLookup.a var1) {
        this.loadAdditional(var02, var1);
        a.COMPONENTS_CODEC.parse(var1.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var02).resultOrPartial(var0 -> LOGGER.warn("Failed to load components: {}", var0)).ifPresent(var0 -> {
            this.components = var0;
        });
    }

    public final void loadCustomOnly(NBTTagCompound var0, HolderLookup.a var1) {
        this.loadAdditional(var0, var1);
    }

    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
    }

    public final NBTTagCompound saveWithFullMetadata(HolderLookup.a var0) {
        NBTTagCompound var1 = this.saveWithoutMetadata(var0);
        this.saveMetadata(var1);
        return var1;
    }

    public final NBTTagCompound saveWithId(HolderLookup.a var0) {
        NBTTagCompound var1 = this.saveWithoutMetadata(var0);
        this.saveId(var1);
        return var1;
    }

    public final NBTTagCompound saveWithoutMetadata(HolderLookup.a var02) {
        NBTTagCompound var12 = new NBTTagCompound();
        this.saveAdditional(var12, var02);
        a.COMPONENTS_CODEC.encodeStart(var02.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this.components).resultOrPartial(var0 -> LOGGER.warn("Failed to save components: {}", var0)).ifPresent(var1 -> var12.merge((NBTTagCompound)var1));
        return var12;
    }

    public final NBTTagCompound saveCustomOnly(HolderLookup.a var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        this.saveAdditional(var1, var0);
        return var1;
    }

    public final NBTTagCompound saveCustomAndMetadata(HolderLookup.a var0) {
        NBTTagCompound var1 = this.saveCustomOnly(var0);
        this.saveMetadata(var1);
        return var1;
    }

    private void saveId(NBTTagCompound var0) {
        MinecraftKey var1 = TileEntityTypes.getKey(this.getType());
        if (var1 == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        var0.putString("id", var1.toString());
    }

    public static void addEntityType(NBTTagCompound var0, TileEntityTypes<?> var1) {
        var0.putString("id", TileEntityTypes.getKey(var1).toString());
    }

    private void saveMetadata(NBTTagCompound var0) {
        this.saveId(var0);
        var0.putInt("x", this.worldPosition.getX());
        var0.putInt("y", this.worldPosition.getY());
        var0.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static TileEntity loadStatic(BlockPosition var0, IBlockData var1, NBTTagCompound var2, HolderLookup.a var32) {
        String var4 = var2.getString("id");
        MinecraftKey var5 = MinecraftKey.tryParse(var4);
        if (var5 == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)var4);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(var5).map(var3 -> {
            try {
                return var3.create(var0, var1);
            }
            catch (Throwable var4) {
                LOGGER.error("Failed to create block entity {}", (Object)var4, (Object)var4);
                return null;
            }
        }).map(var3 -> {
            try {
                var3.loadWithComponents(var2, var32);
                return var3;
            }
            catch (Throwable var4) {
                LOGGER.error("Failed to load data for block entity {}", (Object)var4, (Object)var4);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)var4);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            TileEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(World var0, BlockPosition var1, IBlockData var2) {
        var0.blockEntityChanged(var1);
        if (!var2.isAir()) {
            var0.updateNeighbourForOutputSignal(var1, var2.getBlock());
        }
    }

    public BlockPosition getBlockPos() {
        return this.worldPosition;
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket() {
        return null;
    }

    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return new NBTTagCompound();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int var0, int var1) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Name", this::getNameForReporting);
        if (this.level == null) {
            return;
        }
        CrashReportSystemDetails.populateBlockDetails(var0, this.level, this.worldPosition, this.getBlockState());
        CrashReportSystemDetails.populateBlockDetails(var0, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(IBlockData var0) {
        this.validateBlockState(var0);
        this.blockState = var0;
    }

    protected void applyImplicitComponents(b var0) {
    }

    public final void applyComponentsFromItemStack(ItemStack var0) {
        this.applyComponents(var0.getPrototype(), var0.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap var0, DataComponentPatch var1) {
        final HashSet<DataComponentType<Object>> var2 = new HashSet<DataComponentType<Object>>();
        var2.add(DataComponents.BLOCK_ENTITY_DATA);
        var2.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap var3 = PatchedDataComponentMap.fromPatch(var0, var1);
        this.applyImplicitComponents(new b(this){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> var0) {
                var2.add(var0);
                return var3.get(var0);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> var0, T var1) {
                var2.add(var0);
                return var3.getOrDefault(var0, var1);
            }
        });
        DataComponentPatch var4 = var1.forget(var2::contains);
        this.components = var4.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.a var0) {
    }

    @Deprecated
    public void removeComponentsFromTag(NBTTagCompound var0) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.a var0 = DataComponentMap.builder();
        var0.addAll(this.components);
        this.collectImplicitComponents(var0);
        return var0.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap var0) {
        this.components = var0;
    }

    @Nullable
    public static IChatBaseComponent parseCustomNameSafe(String var0, HolderLookup.a var1) {
        try {
            return IChatBaseComponent.ChatSerializer.fromJson(var0, var1);
        }
        catch (Exception var2) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)var0, (Object)var2);
            return null;
        }
    }

    static class a {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

