/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.ticks.ContainerSingleItem;

public class DecoratedPotBlockEntity
extends TileEntity
implements RandomizableContainer,
ContainerSingleItem.a {
    public static final String TAG_SHERDS = "sherds";
    public static final String TAG_ITEM = "item";
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    @Nullable
    public a lastWobbleStyle;
    public PotDecorations decorations;
    private ItemStack item = ItemStack.EMPTY;
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;

    public DecoratedPotBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.DECORATED_POT, var0, var1);
        this.decorations = PotDecorations.EMPTY;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        this.decorations.save(var0);
        if (!this.trySaveLootTable(var0) && !this.item.isEmpty()) {
            var0.put(TAG_ITEM, this.item.save(var1));
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.decorations = PotDecorations.load(var0);
        if (!this.tryLoadLootTable(var0)) {
            this.item = var0.contains(TAG_ITEM, 10) ? ItemStack.parse(var1, var0.getCompound(TAG_ITEM)).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public EnumDirection getDirection() {
        return this.getBlockState().getValue(BlockProperties.HORIZONTAL_FACING);
    }

    public PotDecorations getDecorations() {
        return this.decorations;
    }

    public static ItemStack createDecoratedPotItem(PotDecorations var0) {
        ItemStack var1 = Items.DECORATED_POT.getDefaultInstance();
        var1.set(DataComponents.POT_DECORATIONS, var0);
        return var1;
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable ResourceKey<LootTable> var0) {
        this.lootTable = var0;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.POT_DECORATIONS, this.decorations);
        var0.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(List.of(this.item)));
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b var0) {
        super.applyImplicitComponents(var0);
        this.decorations = var0.getOrDefault(DataComponents.POT_DECORATIONS, PotDecorations.EMPTY);
        this.item = var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyOne();
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        super.removeComponentsFromTag(var0);
        var0.remove(TAG_SHERDS);
        var0.remove(TAG_ITEM);
    }

    @Override
    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.item;
    }

    @Override
    public ItemStack splitTheItem(int var0) {
        this.unpackLootTable(null);
        ItemStack var1 = this.item.split(var0);
        if (this.item.isEmpty()) {
            this.item = ItemStack.EMPTY;
        }
        return var1;
    }

    @Override
    public void setTheItem(ItemStack var0) {
        this.unpackLootTable(null);
        this.item = var0;
    }

    @Override
    public TileEntity getContainerBlockEntity() {
        return this;
    }

    public void wobble(a var0) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, var0.ordinal());
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (this.level != null && var0 == 1 && var1 >= 0 && var1 < a.values().length) {
            this.wobbleStartedAtTick = this.level.getGameTime();
            this.lastWobbleStyle = a.values()[var1];
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a POSITIVE = new a(7);
        public static final /* enum */ a NEGATIVE = new a(10);
        public final int duration;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(int var2) {
            this.duration = var2;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{POSITIVE, NEGATIVE};
        }

        static {
            d = a.a();
        }
    }
}

