/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreakingHeartBlockEntity
extends TileEntity {
    private static final int PLAYER_DETECTION_RANGE = 32;
    public static final int CREAKING_ROAMING_RADIUS = 32;
    private static final int DISTANCE_CREAKING_TOO_FAR = 34;
    private static final int SPAWN_RANGE_XZ = 16;
    private static final int SPAWN_RANGE_Y = 8;
    private static final int ATTEMPTS_PER_SPAWN = 5;
    private static final int UPDATE_TICKS = 20;
    private static final int UPDATE_TICKS_VARIANCE = 5;
    private static final int HURT_CALL_TOTAL_TICKS = 100;
    private static final int NUMBER_OF_HURT_CALLS = 10;
    private static final int HURT_CALL_INTERVAL = 10;
    private static final int HURT_CALL_PARTICLE_TICKS = 50;
    private static final int MAX_DEPTH = 2;
    private static final int MAX_COUNT = 64;
    private static final int TICKS_GRACE_PERIOD = 30;
    private static final Optional<Creaking> NO_CREAKING = Optional.empty();
    @Nullable
    private Either<Creaking, UUID> creakingInfo;
    private long ticksExisted;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3D emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CREAKING_HEART, var0, var1);
    }

    public static void serverTick(World var0, BlockPosition var12, IBlockData var2, CreakingHeartBlockEntity var3) {
        Creaking var7;
        Object var6;
        ++var3.ticksExisted;
        if (!(var0 instanceof WorldServer)) {
            return;
        }
        WorldServer var4 = (WorldServer)var0;
        int var5 = var3.computeAnalogOutputSignal();
        if (var3.outputSignal != var5) {
            var3.outputSignal = var5;
            var0.updateNeighbourForOutputSignal(var12, Blocks.CREAKING_HEART);
        }
        if (var3.emitter > 0) {
            if (var3.emitter > 50) {
                var3.emitParticles(var4, 1, true);
                var3.emitParticles(var4, 1, false);
            }
            if (var3.emitter % 10 == 0 && var3.emitterTarget != null) {
                var3.getCreakingProtector().ifPresent(var1 -> {
                    var0.emitterTarget = var1.getBoundingBox().getCenter();
                });
                var6 = Vec3D.atCenterOf(var12);
                float var72 = 0.2f + 0.8f * (float)(100 - var3.emitter) / 100.0f;
                Vec3D var8 = ((Vec3D)var6).subtract(var3.emitterTarget).scale(var72).add(var3.emitterTarget);
                BlockPosition var9 = BlockPosition.containing(var8);
                float var10 = (float)var3.emitter / 2.0f / 100.0f + 0.5f;
                var4.playSound(null, var9, SoundEffects.CREAKING_HEART_HURT, SoundCategory.BLOCKS, var10, 1.0f);
            }
            --var3.emitter;
        }
        if (var3.ticker-- >= 0) {
            return;
        }
        int n2 = var3.ticker = var3.level == null ? 20 : var3.level.random.nextInt(5) + 20;
        if (var3.creakingInfo != null) {
            var6 = var3.getCreakingProtector();
            if (((Optional)var6).isPresent()) {
                Creaking var73 = (Creaking)((Optional)var6).get();
                if (!CreakingHeartBlock.isNaturalNight(var0) || var3.distanceToCreaking() > 34.0 || var73.playerIsStuckInYou()) {
                    var3.removeProtector(null);
                    return;
                }
                if (!CreakingHeartBlock.hasRequiredLogs(var2, var0, var12) && var3.creakingInfo == null) {
                    var0.setBlock(var12, (IBlockData)var2.setValue(CreakingHeartBlock.ACTIVE, false), 3);
                }
            }
            return;
        }
        if (!CreakingHeartBlock.hasRequiredLogs(var2, var0, var12)) {
            var0.setBlock(var12, (IBlockData)var2.setValue(CreakingHeartBlock.ACTIVE, false), 3);
            return;
        }
        if (!var2.getValue(CreakingHeartBlock.ACTIVE).booleanValue()) {
            return;
        }
        if (!CreakingHeartBlock.isNaturalNight(var0)) {
            return;
        }
        if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (!var4.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        var6 = var0.getNearestPlayer((double)var12.getX(), (double)var12.getY(), (double)var12.getZ(), 32.0, false);
        if (var6 != null && (var7 = CreakingHeartBlockEntity.spawnProtector(var4, var3)) != null) {
            var3.setCreakingInfo(var7);
            var7.makeSound(SoundEffects.CREAKING_SPAWN);
            var0.playSound(null, var3.getBlockPos(), SoundEffects.CREAKING_HEART_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private double distanceToCreaking() {
        return this.getCreakingProtector().map(var0 -> Math.sqrt(var0.distanceToSqr(Vec3D.atBottomCenterOf(this.getBlockPos())))).orElse(0.0);
    }

    private void clearCreakingInfo() {
        this.creakingInfo = null;
        this.setChanged();
    }

    public void setCreakingInfo(Creaking var0) {
        this.creakingInfo = Either.left((Object)var0);
        this.setChanged();
    }

    public void setCreakingInfo(UUID var0) {
        this.creakingInfo = Either.right((Object)var0);
        this.ticksExisted = 0L;
        this.setChanged();
    }

    private Optional<Creaking> getCreakingProtector() {
        World world;
        Object var0;
        if (this.creakingInfo == null) {
            return NO_CREAKING;
        }
        if (this.creakingInfo.left().isPresent()) {
            var0 = (Creaking)this.creakingInfo.left().get();
            if (!((Entity)var0).isRemoved()) {
                return Optional.of(var0);
            }
            this.setCreakingInfo(((Entity)var0).getUUID());
        }
        if ((world = this.level) instanceof WorldServer) {
            var0 = (WorldServer)world;
            if (this.creakingInfo.right().isPresent()) {
                UUID var1 = (UUID)this.creakingInfo.right().get();
                Entity var2 = ((WorldServer)var0).getEntity(var1);
                if (var2 instanceof Creaking) {
                    Creaking var3 = (Creaking)var2;
                    this.setCreakingInfo(var3);
                    return Optional.of(var3);
                }
                if (this.ticksExisted >= 30L) {
                    this.clearCreakingInfo();
                }
                return NO_CREAKING;
            }
        }
        return NO_CREAKING;
    }

    @Nullable
    private static Creaking spawnProtector(WorldServer var0, CreakingHeartBlockEntity var1) {
        BlockPosition var2 = var1.getBlockPos();
        Optional<Creaking> var3 = SpawnUtil.trySpawnMob(EntityTypes.CREAKING, EntitySpawnReason.SPAWNER, var0, var2, 5, 16, 8, SpawnUtil.a.ON_TOP_OF_COLLIDER_NO_LEAVES, true);
        if (var3.isEmpty()) {
            return null;
        }
        Creaking var4 = var3.get();
        var0.gameEvent((Entity)var4, GameEvent.ENTITY_PLACE, var4.position());
        var0.broadcastEntityEvent(var4, (byte)60);
        var4.setTransient(var2);
        return var4;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public void creakingHurt() {
        Object var2_1 = this.getCreakingProtector().orElse(null);
        if (!(var2_1 instanceof Creaking)) {
            return;
        }
        Creaking var02 = var2_1;
        World world = this.level;
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        if (this.emitter > 0) {
            return;
        }
        this.emitParticles(var1, 20, false);
        int var2 = this.level.getRandom().nextIntBetweenInclusive(2, 3);
        for (int var3 = 0; var3 < var2; ++var3) {
            this.spreadResin().ifPresent(var0 -> {
                this.level.playSound(null, (BlockPosition)var0, SoundEffects.RESIN_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent((Holder<GameEvent>)GameEvent.BLOCK_PLACE, (BlockPosition)var0, GameEvent.a.of(this.level.getBlockState((BlockPosition)var0)));
            });
        }
        this.emitter = 100;
        this.emitterTarget = var02.getBoundingBox().getCenter();
    }

    private Optional<BlockPosition> spreadResin() {
        MutableObject var02 = new MutableObject(null);
        BlockPosition.breadthFirstTraversal(this.worldPosition, 2, 64, (var0, var1) -> {
            for (EnumDirection var3 : SystemUtils.shuffledCopy(EnumDirection.values(), this.level.random)) {
                BlockPosition var4 = var0.relative(var3);
                if (!this.level.getBlockState(var4).is(TagsBlock.PALE_OAK_LOGS)) continue;
                var1.accept(var4);
            }
        }, arg_0 -> this.a((Mutable)var02, arg_0));
        return Optional.ofNullable((BlockPosition)var02.getValue());
    }

    private void emitParticles(WorldServer var0, int var1, boolean var2) {
        Object var5_4 = this.getCreakingProtector().orElse(null);
        if (!(var5_4 instanceof Creaking)) {
            return;
        }
        Creaking var3 = var5_4;
        int var4 = var2 ? 16545810 : 0x5F5F5F;
        RandomSource var5 = var0.random;
        for (double var6 = 0.0; var6 < (double)var1; var6 += 1.0) {
            Object var11;
            AxisAlignedBB var8 = var3.getBoundingBox();
            Vec3D var9 = var8.getMinPosition().add(var5.nextDouble() * var8.getXsize(), var5.nextDouble() * var8.getYsize(), var5.nextDouble() * var8.getZsize());
            Vec3D var10 = Vec3D.atLowerCornerOf(this.getBlockPos()).add(var5.nextDouble(), var5.nextDouble(), var5.nextDouble());
            if (var2) {
                var11 = var9;
                var9 = var10;
                var10 = var11;
            }
            var11 = new TrailParticleOption(var10, var4, var5.nextInt(40) + 10);
            var0.sendParticles(var11, true, true, var9.x, var9.y, var9.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeProtector(@Nullable DamageSource var0) {
        Object var3_2 = this.getCreakingProtector().orElse(null);
        if (var3_2 instanceof Creaking) {
            Creaking var1 = var3_2;
            if (var0 == null) {
                var1.tearDown();
            } else {
                var1.creakingDeathEffects(var0);
                var1.setTearingDown();
                var1.setHealth(0.0f);
            }
            this.clearCreakingInfo();
        }
    }

    public boolean isProtector(Creaking var0) {
        return this.getCreakingProtector().map(var1 -> var1 == var0).orElse(false);
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creakingInfo == null || this.getCreakingProtector().isEmpty()) {
            return 0;
        }
        double var0 = this.distanceToCreaking();
        double var2 = Math.clamp(var0, 0.0, 32.0) / 32.0;
        return 15 - (int)Math.floor(var2 * 15.0);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        if (var0.contains("creaking")) {
            this.setCreakingInfo(var0.getUUID("creaking"));
        } else {
            this.clearCreakingInfo();
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.saveAdditional(var02, var1);
        if (this.creakingInfo != null) {
            var02.putUUID("creaking", (UUID)this.creakingInfo.map(Entity::getUUID, var0 -> var0));
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    private /* synthetic */ BlockPosition.b a(Mutable var0, BlockPosition var1) {
        if (!this.level.getBlockState(var1).is(TagsBlock.PALE_OAK_LOGS)) {
            return BlockPosition.b.ACCEPT;
        }
        for (EnumDirection var3 : SystemUtils.shuffledCopy(EnumDirection.values(), this.level.random)) {
            BlockPosition var4 = var1.relative(var3);
            IBlockData var5 = this.level.getBlockState(var4);
            EnumDirection var6 = var3.getOpposite();
            if (var5.isAir()) {
                var5 = Blocks.RESIN_CLUMP.defaultBlockState();
            } else if (var5.is(Blocks.WATER) && var5.getFluidState().isSource()) {
                var5 = (IBlockData)Blocks.RESIN_CLUMP.defaultBlockState().setValue(MultifaceBlock.WATERLOGGED, true);
            }
            if (!var5.is(Blocks.RESIN_CLUMP) || MultifaceBlock.hasFace(var5, var6)) continue;
            this.level.setBlock(var4, (IBlockData)var5.setValue(MultifaceBlock.getFaceProperty(var6), true), 3);
            var0.setValue((Object)var4);
            return BlockPosition.b.STOP;
        }
        return BlockPosition.b.ACCEPT;
    }
}

