/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class CrafterBlockEntity
extends TileEntityLootable
implements InventoryCrafting {
    public static final int CONTAINER_WIDTH = 3;
    public static final int CONTAINER_HEIGHT = 3;
    public static final int CONTAINER_SIZE = 9;
    public static final int SLOT_DISABLED = 1;
    public static final int SLOT_ENABLED = 0;
    public static final int DATA_TRIGGERED = 9;
    public static final int NUM_DATA = 10;
    private NonNullList<ItemStack> items = NonNullList.withSize(9, ItemStack.EMPTY);
    public int craftingTicksRemaining = 0;
    protected final IContainerProperties containerData = new IContainerProperties(this){
        private final int[] slotStates = new int[9];
        private int triggered = 0;

        @Override
        public int get(int var0) {
            return var0 == 9 ? this.triggered : this.slotStates[var0];
        }

        @Override
        public void set(int var0, int var1) {
            if (var0 == 9) {
                this.triggered = var1;
            } else {
                this.slotStates[var0] = var1;
            }
        }

        @Override
        public int getCount() {
            return 10;
        }
    };

    public CrafterBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CRAFTER, var0, var1);
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.crafter");
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new CrafterMenu(var0, var1, this, this.containerData);
    }

    public void setSlotState(int var0, boolean var1) {
        if (!this.slotCanBeDisabled(var0)) {
            return;
        }
        this.containerData.set(var0, var1 ? 0 : 1);
        this.setChanged();
    }

    public boolean isSlotDisabled(int var0) {
        if (var0 >= 0 && var0 < 9) {
            return this.containerData.get(var0) == 1;
        }
        return false;
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (this.containerData.get(var0) == 1) {
            return false;
        }
        ItemStack var2 = this.items.get(var0);
        int var3 = var2.getCount();
        if (var3 >= var2.getMaxStackSize()) {
            return false;
        }
        if (var2.isEmpty()) {
            return true;
        }
        return !this.smallerStackExist(var3, var2, var0);
    }

    private boolean smallerStackExist(int var0, ItemStack var1, int var2) {
        for (int var3 = var2 + 1; var3 < 9; ++var3) {
            ItemStack var4;
            if (this.isSlotDisabled(var3) || !(var4 = this.getItem(var3)).isEmpty() && (var4.getCount() >= var0 || !ItemStack.isSameItemSameComponents(var4, var1))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.craftingTicksRemaining = var0.getInt("crafting_ticks_remaining");
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items, var1);
        }
        int[] var2 = var0.getIntArray("disabled_slots");
        for (int var3 = 0; var3 < 9; ++var3) {
            this.containerData.set(var3, 0);
        }
        for (int var6 : var2) {
            if (!this.slotCanBeDisabled(var6)) continue;
            this.containerData.set(var6, 1);
        }
        this.containerData.set(9, var0.getInt("triggered"));
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        var0.putInt("crafting_ticks_remaining", this.craftingTicksRemaining);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items, var1);
        }
        this.addDisabledSlots(var0);
        this.addTriggered(var0);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.items.get(var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        if (this.isSlotDisabled(var0)) {
            this.setSlotState(var0, true);
        }
        super.setItem(var0, var1);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }

    @Override
    public void fillStackedContents(StackedItemContents var0) {
        for (ItemStack var2 : this.items) {
            var0.accountSimpleStack(var2);
        }
    }

    private void addDisabledSlots(NBTTagCompound var0) {
        IntArrayList var1 = new IntArrayList();
        for (int var2 = 0; var2 < 9; ++var2) {
            if (!this.isSlotDisabled(var2)) continue;
            var1.add(var2);
        }
        var0.putIntArray("disabled_slots", (List<Integer>)var1);
    }

    private void addTriggered(NBTTagCompound var0) {
        var0.putInt("triggered", this.containerData.get(9));
    }

    public void setTriggered(boolean var0) {
        this.containerData.set(9, var0 ? 1 : 0);
    }

    @VisibleForTesting
    public boolean isTriggered() {
        return this.containerData.get(9) == 1;
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, CrafterBlockEntity var3) {
        int var4 = var3.craftingTicksRemaining - 1;
        if (var4 < 0) {
            return;
        }
        var3.craftingTicksRemaining = var4;
        if (var4 == 0) {
            var0.setBlock(var1, (IBlockData)var2.setValue(CrafterBlock.CRAFTING, false), 3);
        }
    }

    public void setCraftingTicksRemaining(int var0) {
        this.craftingTicksRemaining = var0;
    }

    public int getRedstoneSignal() {
        int var0 = 0;
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (var2.isEmpty() && !this.isSlotDisabled(var1)) continue;
            ++var0;
        }
        return var0;
    }

    private boolean slotCanBeDisabled(int var0) {
        return var0 > -1 && var0 < 9 && this.items.get(var0).isEmpty();
    }

    public /* synthetic */ List getItems() {
        return this.getItems();
    }
}

