/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGlassAbstract;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;

public class WaterloggedTransparentBlock
extends BlockGlassAbstract
implements IBlockWaterlogged {
    public static final MapCodec<WaterloggedTransparentBlock> CODEC = WaterloggedTransparentBlock.simpleCodec(WaterloggedTransparentBlock::new);
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;

    protected MapCodec<? extends WaterloggedTransparentBlock> codec() {
        return CODEC;
    }

    protected WaterloggedTransparentBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, false));
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var1.is(FluidTypes.WATER));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(true);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(WATERLOGGED);
    }
}

