/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class ParticleLeavesBlock
extends BlockLeaves {
    public static final MapCodec<ParticleLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("chance").forGetter(var0 -> var0.chance), (App)Particles.CODEC.fieldOf("particle").forGetter(var0 -> var0.particle), ParticleLeavesBlock.propertiesCodec()).apply((Applicative)var02, ParticleLeavesBlock::new));
    private final ParticleParam particle;
    private final int chance;

    public MapCodec<ParticleLeavesBlock> codec() {
        return CODEC;
    }

    public ParticleLeavesBlock(int var0, ParticleParam var1, BlockBase.Info var2) {
        super(var2);
        this.chance = var0;
        this.particle = var1;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        super.animateTick(var0, var1, var2, var3);
        if (var3.nextInt(this.chance) != 0) {
            return;
        }
        BlockPosition var4 = var2.below();
        IBlockData var5 = var1.getBlockState(var4);
        if (ParticleLeavesBlock.isFaceFull(var5.getCollisionShape(var1, var4), EnumDirection.UP)) {
            return;
        }
        ParticleUtils.spawnParticleBelow(var1, var2, var3, this.particle);
    }
}

