/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> CODEC = BlockTNT.simpleCodec(BlockTNT::new);
    public static final BlockStateBoolean UNSTABLE = BlockProperties.UNSTABLE;

    public MapCodec<BlockTNT> codec() {
        return CODEC;
    }

    public BlockTNT(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(UNSTABLE, false));
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        if (var1.hasNeighborSignal(var2)) {
            BlockTNT.explode(var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.hasNeighborSignal(var2)) {
            BlockTNT.explode(var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide() && !var3.isCreative() && var2.getValue(UNSTABLE).booleanValue()) {
            BlockTNT.explode(var0, var1);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public void wasExploded(WorldServer var0, BlockPosition var1, Explosion var2) {
        EntityTNTPrimed var3 = new EntityTNTPrimed(var0, (double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5, var2.getIndirectSourceEntity());
        int var4 = var3.getFuse();
        var3.setFuse((short)(var0.random.nextInt(var4 / 4) + var4 / 8));
        var0.addFreshEntity(var3);
    }

    public static void explode(World var0, BlockPosition var1) {
        BlockTNT.explode(var0, var1, null);
    }

    private static void explode(World var0, BlockPosition var1, @Nullable EntityLiving var2) {
        if (var0.isClientSide) {
            return;
        }
        EntityTNTPrimed var3 = new EntityTNTPrimed(var0, (double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5, var2);
        var0.addFreshEntity(var3);
        var0.playSound(null, var3.getX(), var3.getY(), var3.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var0.gameEvent((Entity)var2, GameEvent.PRIME_FUSE, var1);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (!var0.is(Items.FLINT_AND_STEEL) && !var0.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
        }
        BlockTNT.explode(var2, var3, var4);
        var2.setBlock(var3, Blocks.AIR.defaultBlockState(), 11);
        Item var7 = var0.getItem();
        if (var0.is(Items.FLINT_AND_STEEL)) {
            var0.hurtAndBreak(1, var4, EntityLiving.getSlotForHand(var5));
        } else {
            var0.consume(1, var4);
        }
        var4.awardStat(StatisticList.ITEM_USED.get(var7));
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        if (var0 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var0;
            BlockPosition var5 = var2.getBlockPos();
            Entity var6 = var3.getOwner();
            if (var3.isOnFire() && var3.mayInteract(var4, var5)) {
                BlockTNT.explode(var0, var5, var6 instanceof EntityLiving ? (EntityLiving)var6 : null);
                var0.removeBlock(var5, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(Explosion var0) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(UNSTABLE);
    }
}

