/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockPumpkin
extends Block {
    public static final MapCodec<BlockPumpkin> CODEC = BlockPumpkin.simpleCodec(BlockPumpkin::new);

    public MapCodec<BlockPumpkin> codec() {
        return CODEC;
    }

    protected BlockPumpkin(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (!var0.is(Items.SHEARS)) {
            return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
        }
        if (var2.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        EnumDirection var7 = var6.getDirection();
        EnumDirection var8 = var7.getAxis() == EnumDirection.EnumAxis.Y ? var4.getDirection().getOpposite() : var7;
        var2.playSound(null, var3, SoundEffects.PUMPKIN_CARVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var2.setBlock(var3, (IBlockData)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(BlockPumpkinCarved.FACING, var8), 11);
        EntityItem var9 = new EntityItem(var2, (double)var3.getX() + 0.5 + (double)var8.getStepX() * 0.65, (double)var3.getY() + 0.1, (double)var3.getZ() + 0.5 + (double)var8.getStepZ() * 0.65, new ItemStack(Items.PUMPKIN_SEEDS, 4));
        var9.setDeltaMovement(0.05 * (double)var8.getStepX() + var2.random.nextDouble() * 0.02, 0.05, 0.05 * (double)var8.getStepZ() + var2.random.nextDouble() * 0.02);
        var2.addFreshEntity(var9);
        var0.hurtAndBreak(1, var4, EntityLiving.getSlotForHand(var5));
        var2.gameEvent((Entity)var4, GameEvent.SHEAR, var3);
        var4.awardStat(StatisticList.ITEM_USED.get(Items.SHEARS));
        return EnumInteractionResult.SUCCESS;
    }
}

