/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockMonsterEggs
extends Block {
    public static final MapCodec<BlockMonsterEggs> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("host").forGetter(BlockMonsterEggs::getHostBlock), BlockMonsterEggs.propertiesCodec()).apply((Applicative)var0, BlockMonsterEggs::new));
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public MapCodec<? extends BlockMonsterEggs> codec() {
        return CODEC;
    }

    public BlockMonsterEggs(Block var0, BlockBase.Info var1) {
        super(var1.destroyTime(var0.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
        this.hostBlock = var0;
        BLOCK_BY_HOST_BLOCK.put(var0, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(IBlockData var0) {
        return BLOCK_BY_HOST_BLOCK.containsKey(var0.getBlock());
    }

    private void spawnInfestation(WorldServer var0, BlockPosition var1) {
        EntitySilverfish var2 = EntityTypes.SILVERFISH.create(var0, EntitySpawnReason.TRIGGERED);
        if (var2 != null) {
            var2.moveTo((double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5, 0.0f, 0.0f);
            var0.addFreshEntity(var2);
            var2.spawnAnim();
        }
    }

    @Override
    protected void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var1.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !EnchantmentManager.hasTag(var3, EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            this.spawnInfestation(var1, var2);
        }
    }

    public static IBlockData infestedStateByHost(IBlockData var0) {
        return BlockMonsterEggs.getNewStateWithProperties(HOST_TO_INFESTED_STATES, var0, () -> BLOCK_BY_HOST_BLOCK.get(var0.getBlock()).defaultBlockState());
    }

    public IBlockData hostStateByInfested(IBlockData var0) {
        return BlockMonsterEggs.getNewStateWithProperties(INFESTED_TO_HOST_STATES, var0, () -> this.getHostBlock().defaultBlockState());
    }

    private static IBlockData getNewStateWithProperties(Map<IBlockData, IBlockData> var0, IBlockData var12, Supplier<IBlockData> var2) {
        return var0.computeIfAbsent(var12, var1 -> {
            IBlockData var2 = (IBlockData)var2.get();
            for (IBlockState<?> var4 : var1.getProperties()) {
                var2 = var2.hasProperty(var4) ? (IBlockData)var2.setValue(var4, var1.getValue(var4)) : var2;
            }
            return var2;
        });
    }
}

