/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockFireAbstract
extends Block {
    private static final int SECONDS_ON_FIRE = 8;
    private static final int MIN_FIRE_TICKS_TO_ADD = 1;
    private static final int MAX_FIRE_TICKS_TO_ADD = 3;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BlockFireAbstract(BlockBase.Info var0, float var1) {
        super(var0);
        this.fireDamage = var1;
    }

    protected abstract MapCodec<? extends BlockFireAbstract> codec();

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return BlockFireAbstract.getState(var0.getLevel(), var0.getClickedPos());
    }

    public static IBlockData getState(IBlockAccess var0, BlockPosition var1) {
        BlockPosition var2 = var1.below();
        IBlockData var3 = var0.getBlockState(var2);
        if (BlockSoulFire.canSurviveOnBlock(var3)) {
            return Blocks.SOUL_FIRE.defaultBlockState();
        }
        return ((BlockFire)Blocks.FIRE).getStateForPlacement(var0, var1);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return DOWN_AABB;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        block12: {
            double var11;
            double var9;
            double var7;
            int var6;
            block11: {
                BlockPosition var4;
                IBlockData var5;
                if (var3.nextInt(24) == 0) {
                    var1.playLocalSound((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.FIRE_AMBIENT, SoundCategory.BLOCKS, 1.0f + var3.nextFloat(), var3.nextFloat() * 0.7f + 0.3f, false);
                }
                if (!this.canBurn(var5 = var1.getBlockState(var4 = var2.below())) && !var5.isFaceSturdy(var1, var4, EnumDirection.UP)) break block11;
                for (int var62 = 0; var62 < 3; ++var62) {
                    double var72 = (double)var2.getX() + var3.nextDouble();
                    double var92 = (double)var2.getY() + var3.nextDouble() * 0.5 + 0.5;
                    double var112 = (double)var2.getZ() + var3.nextDouble();
                    var1.addParticle(Particles.LARGE_SMOKE, var72, var92, var112, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (this.canBurn(var1.getBlockState(var2.west()))) {
                for (var6 = 0; var6 < 2; ++var6) {
                    var7 = (double)var2.getX() + var3.nextDouble() * (double)0.1f;
                    var9 = (double)var2.getY() + var3.nextDouble();
                    var11 = (double)var2.getZ() + var3.nextDouble();
                    var1.addParticle(Particles.LARGE_SMOKE, var7, var9, var11, 0.0, 0.0, 0.0);
                }
            }
            if (this.canBurn(var1.getBlockState(var2.east()))) {
                for (var6 = 0; var6 < 2; ++var6) {
                    var7 = (double)(var2.getX() + 1) - var3.nextDouble() * (double)0.1f;
                    var9 = (double)var2.getY() + var3.nextDouble();
                    var11 = (double)var2.getZ() + var3.nextDouble();
                    var1.addParticle(Particles.LARGE_SMOKE, var7, var9, var11, 0.0, 0.0, 0.0);
                }
            }
            if (this.canBurn(var1.getBlockState(var2.north()))) {
                for (var6 = 0; var6 < 2; ++var6) {
                    var7 = (double)var2.getX() + var3.nextDouble();
                    var9 = (double)var2.getY() + var3.nextDouble();
                    var11 = (double)var2.getZ() + var3.nextDouble() * (double)0.1f;
                    var1.addParticle(Particles.LARGE_SMOKE, var7, var9, var11, 0.0, 0.0, 0.0);
                }
            }
            if (this.canBurn(var1.getBlockState(var2.south()))) {
                for (var6 = 0; var6 < 2; ++var6) {
                    var7 = (double)var2.getX() + var3.nextDouble();
                    var9 = (double)var2.getY() + var3.nextDouble();
                    var11 = (double)(var2.getZ() + 1) - var3.nextDouble() * (double)0.1f;
                    var1.addParticle(Particles.LARGE_SMOKE, var7, var9, var11, 0.0, 0.0, 0.0);
                }
            }
            if (!this.canBurn(var1.getBlockState(var2.above()))) break block12;
            for (var6 = 0; var6 < 2; ++var6) {
                var7 = (double)var2.getX() + var3.nextDouble();
                var9 = (double)(var2.getY() + 1) - var3.nextDouble() * (double)0.1f;
                var11 = (double)var2.getZ() + var3.nextDouble();
                var1.addParticle(Particles.LARGE_SMOKE, var7, var9, var11, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean canBurn(IBlockData var1);

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (!var3.fireImmune()) {
            if (var3.getRemainingFireTicks() < 0) {
                var3.setRemainingFireTicks(var3.getRemainingFireTicks() + 1);
            } else if (var3 instanceof EntityPlayer) {
                int var4 = var1.getRandom().nextInt(1, 3);
                var3.setRemainingFireTicks(var3.getRemainingFireTicks() + var4);
            }
            if (var3.getRemainingFireTicks() >= 0) {
                var3.igniteForSeconds(8.0f);
            }
        }
        var3.hurt(var1.damageSources().inFire(), this.fireDamage);
        super.entityInside(var0, var1, var2, var3);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        Optional<BlockPortalShape> var5;
        if (var3.is(var0.getBlock())) {
            return;
        }
        if (BlockFireAbstract.inPortalDimension(var1) && (var5 = BlockPortalShape.findEmptyPortalShape(var1, var2, EnumDirection.EnumAxis.X)).isPresent()) {
            var5.get().createPortalBlocks(var1);
            return;
        }
        if (!var0.canSurvive(var1, var2)) {
            var1.removeBlock(var2, false);
        }
    }

    private static boolean inPortalDimension(World var0) {
        return var0.dimension() == World.OVERWORLD || var0.dimension() == World.NETHER;
    }

    @Override
    protected void spawnDestroyParticles(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3) {
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide()) {
            var0.levelEvent(null, 1009, var1, 0);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    public static boolean canBePlacedAt(World var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        if (!var3.isAir()) {
            return false;
        }
        return BlockFireAbstract.getState(var0, var1).canSurvive(var0, var1) || BlockFireAbstract.isPortal(var0, var1, var2);
    }

    private static boolean isPortal(World var0, BlockPosition var1, EnumDirection var2) {
        if (!BlockFireAbstract.inPortalDimension(var0)) {
            return false;
        }
        BlockPosition.MutableBlockPosition var3 = var1.mutable();
        boolean var4 = false;
        for (EnumDirection var8 : EnumDirection.values()) {
            if (!var0.getBlockState(var3.set(var1).move(var8)).is(Blocks.OBSIDIAN)) continue;
            var4 = true;
            break;
        }
        if (!var4) {
            return false;
        }
        EnumDirection.EnumAxis var5 = var2.getAxis().isHorizontal() ? var2.getCounterClockWise().getAxis() : EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomAxis(var0.random);
        return BlockPortalShape.findEmptyPortalShape(var0, var1, var5).isPresent();
    }
}

