/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockFire
extends BlockFireAbstract {
    public static final MapCodec<BlockFire> CODEC = BlockFire.simpleCodec(BlockFire::new);
    public static final int MAX_AGE = 15;
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    public static final BlockStateBoolean UP = BlockSprawling.UP;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION.entrySet().stream().filter(var0 -> var0.getKey() != EnumDirection.DOWN).collect(SystemUtils.toMap());
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    public final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();

    public MapCodec<BlockFire> codec() {
        return CODEC;
    }

    public BlockFire(BlockBase.Info var02) {
        super(var02, 1.0f);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(var0 -> var0.getValue(AGE) == 0).collect(Collectors.toMap(Function.identity(), BlockFire::calculateShape)));
    }

    private static VoxelShape calculateShape(IBlockData var0) {
        VoxelShape var1 = VoxelShapes.empty();
        if (var0.getValue(UP).booleanValue()) {
            var1 = UP_AABB;
        }
        if (var0.getValue(NORTH).booleanValue()) {
            var1 = VoxelShapes.or(var1, NORTH_AABB);
        }
        if (var0.getValue(SOUTH).booleanValue()) {
            var1 = VoxelShapes.or(var1, SOUTH_AABB);
        }
        if (var0.getValue(EAST).booleanValue()) {
            var1 = VoxelShapes.or(var1, EAST_AABB);
        }
        if (var0.getValue(WEST).booleanValue()) {
            var1 = VoxelShapes.or(var1, WEST_AABB);
        }
        return var1.isEmpty() ? DOWN_AABB : var1;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (this.canSurvive(var0, var1, var3)) {
            return this.getStateWithAge(var1, var3, var0.getValue(AGE));
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapesCache.get(var0.setValue(AGE, 0));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.getStateForPlacement(var0.getLevel(), var0.getClickedPos());
    }

    protected IBlockData getStateForPlacement(IBlockAccess var0, BlockPosition var1) {
        BlockPosition var2 = var1.below();
        IBlockData var3 = var0.getBlockState(var2);
        if (this.canBurn(var3) || var3.isFaceSturdy(var0, var2, EnumDirection.UP)) {
            return this.defaultBlockState();
        }
        IBlockData var4 = this.defaultBlockState();
        for (EnumDirection var8 : EnumDirection.values()) {
            BlockStateBoolean var9 = PROPERTY_BY_DIRECTION.get(var8);
            if (var9 == null) continue;
            var4 = (IBlockData)var4.setValue(var9, this.canBurn(var0.getBlockState(var1.relative(var8))));
        }
        return var4;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        return var1.getBlockState(var3).isFaceSturdy(var1, var3, EnumDirection.UP) || this.isValidFireLocation(var1, var2);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        boolean var8;
        var1.scheduleTick(var2, this, BlockFire.getFireTickDelay(var1.random));
        if (!var1.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            return;
        }
        if (!var0.canSurvive(var1, var2)) {
            var1.removeBlock(var2, false);
        }
        IBlockData var4 = var1.getBlockState(var2.below());
        boolean var5 = var4.is(var1.dimensionType().infiniburn());
        int var6 = var0.getValue(AGE);
        if (!var5 && var1.isRaining() && this.isNearRain(var1, var2) && var3.nextFloat() < 0.2f + (float)var6 * 0.03f) {
            var1.removeBlock(var2, false);
            return;
        }
        int var7 = Math.min(15, var6 + var3.nextInt(3) / 2);
        if (var6 != var7) {
            var0 = (IBlockData)var0.setValue(AGE, var7);
            var1.setBlock(var2, var0, 4);
        }
        if (!var5) {
            if (!this.isValidFireLocation(var1, var2)) {
                BlockPosition var82 = var2.below();
                if (!var1.getBlockState(var82).isFaceSturdy(var1, var82, EnumDirection.UP) || var6 > 3) {
                    var1.removeBlock(var2, false);
                }
                return;
            }
            if (var6 == 15 && var3.nextInt(4) == 0 && !this.canBurn(var1.getBlockState(var2.below()))) {
                var1.removeBlock(var2, false);
                return;
            }
        }
        int var9 = (var8 = var1.getBiome(var2).is(BiomeTags.INCREASED_FIRE_BURNOUT)) ? -50 : 0;
        this.checkBurnOut(var1, var2.east(), 300 + var9, var3, var6);
        this.checkBurnOut(var1, var2.west(), 300 + var9, var3, var6);
        this.checkBurnOut(var1, var2.below(), 250 + var9, var3, var6);
        this.checkBurnOut(var1, var2.above(), 250 + var9, var3, var6);
        this.checkBurnOut(var1, var2.north(), 300 + var9, var3, var6);
        this.checkBurnOut(var1, var2.south(), 300 + var9, var3, var6);
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (int var11 = -1; var11 <= 1; ++var11) {
            for (int var12 = -1; var12 <= 1; ++var12) {
                for (int var13 = -1; var13 <= 4; ++var13) {
                    if (var11 == 0 && var13 == 0 && var12 == 0) continue;
                    int var14 = 100;
                    if (var13 > 1) {
                        var14 += (var13 - 1) * 100;
                    }
                    var10.setWithOffset(var2, var11, var13, var12);
                    int var15 = this.getIgniteOdds(var1, var10);
                    if (var15 <= 0) continue;
                    int var16 = (var15 + 40 + var1.getDifficulty().getId() * 7) / (var6 + 30);
                    if (var8) {
                        var16 /= 2;
                    }
                    if (var16 <= 0 || var3.nextInt(var14) > var16 || var1.isRaining() && this.isNearRain(var1, var10)) continue;
                    int var17 = Math.min(15, var6 + var3.nextInt(5) / 4);
                    var1.setBlock(var10, this.getStateWithAge(var1, var10, var17), 3);
                }
            }
        }
    }

    protected boolean isNearRain(World var0, BlockPosition var1) {
        return var0.isRainingAt(var1) || var0.isRainingAt(var1.west()) || var0.isRainingAt(var1.east()) || var0.isRainingAt(var1.north()) || var0.isRainingAt(var1.south());
    }

    private int getBurnOdds(IBlockData var0) {
        if (var0.hasProperty(BlockProperties.WATERLOGGED) && var0.getValue(BlockProperties.WATERLOGGED).booleanValue()) {
            return 0;
        }
        return this.burnOdds.getInt((Object)var0.getBlock());
    }

    private int getIgniteOdds(IBlockData var0) {
        if (var0.hasProperty(BlockProperties.WATERLOGGED) && var0.getValue(BlockProperties.WATERLOGGED).booleanValue()) {
            return 0;
        }
        return this.igniteOdds.getInt((Object)var0.getBlock());
    }

    private void checkBurnOut(World var0, BlockPosition var1, int var2, RandomSource var3, int var4) {
        int var5 = this.getBurnOdds(var0.getBlockState(var1));
        if (var3.nextInt(var2) < var5) {
            IBlockData var6 = var0.getBlockState(var1);
            if (var3.nextInt(var4 + 10) < 5 && !var0.isRainingAt(var1)) {
                int var7 = Math.min(var4 + var3.nextInt(5) / 4, 15);
                var0.setBlock(var1, this.getStateWithAge(var0, var1, var7), 3);
            } else {
                var0.removeBlock(var1, false);
            }
            Block var7 = var6.getBlock();
            if (var7 instanceof BlockTNT) {
                BlockTNT.explode(var0, var1);
            }
        }
    }

    private IBlockData getStateWithAge(IWorldReader var0, BlockPosition var1, int var2) {
        IBlockData var3 = BlockFire.getState(var0, var1);
        if (var3.is(Blocks.FIRE)) {
            return (IBlockData)var3.setValue(AGE, var2);
        }
        return var3;
    }

    private boolean isValidFireLocation(IBlockAccess var0, BlockPosition var1) {
        for (EnumDirection var5 : EnumDirection.values()) {
            if (!this.canBurn(var0.getBlockState(var1.relative(var5)))) continue;
            return true;
        }
        return false;
    }

    private int getIgniteOdds(IWorldReader var0, BlockPosition var1) {
        if (!var0.isEmptyBlock(var1)) {
            return 0;
        }
        int var2 = 0;
        for (EnumDirection var6 : EnumDirection.values()) {
            IBlockData var7 = var0.getBlockState(var1.relative(var6));
            var2 = Math.max(this.getIgniteOdds(var7), var2);
        }
        return var2;
    }

    @Override
    protected boolean canBurn(IBlockData var0) {
        return this.getIgniteOdds(var0) > 0;
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        super.onPlace(var0, var1, var2, var3, var4);
        var1.scheduleTick(var2, this, BlockFire.getFireTickDelay(var1.random));
    }

    private static int getFireTickDelay(RandomSource var0) {
        return 30 + var0.nextInt(10);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE, NORTH, EAST, SOUTH, WEST, UP);
    }

    public void setFlammable(Block var0, int var1, int var2) {
        this.igniteOdds.put((Object)var0, var1);
        this.burnOdds.put((Object)var0, var2);
    }

    public static void bootStrap() {
        BlockFire var0 = (BlockFire)Blocks.FIRE;
        var0.setFlammable(Blocks.OAK_PLANKS, 5, 20);
        var0.setFlammable(Blocks.SPRUCE_PLANKS, 5, 20);
        var0.setFlammable(Blocks.BIRCH_PLANKS, 5, 20);
        var0.setFlammable(Blocks.JUNGLE_PLANKS, 5, 20);
        var0.setFlammable(Blocks.ACACIA_PLANKS, 5, 20);
        var0.setFlammable(Blocks.CHERRY_PLANKS, 5, 20);
        var0.setFlammable(Blocks.DARK_OAK_PLANKS, 5, 20);
        var0.setFlammable(Blocks.PALE_OAK_PLANKS, 5, 20);
        var0.setFlammable(Blocks.MANGROVE_PLANKS, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_PLANKS, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_MOSAIC, 5, 20);
        var0.setFlammable(Blocks.OAK_SLAB, 5, 20);
        var0.setFlammable(Blocks.SPRUCE_SLAB, 5, 20);
        var0.setFlammable(Blocks.BIRCH_SLAB, 5, 20);
        var0.setFlammable(Blocks.JUNGLE_SLAB, 5, 20);
        var0.setFlammable(Blocks.ACACIA_SLAB, 5, 20);
        var0.setFlammable(Blocks.CHERRY_SLAB, 5, 20);
        var0.setFlammable(Blocks.DARK_OAK_SLAB, 5, 20);
        var0.setFlammable(Blocks.PALE_OAK_SLAB, 5, 20);
        var0.setFlammable(Blocks.MANGROVE_SLAB, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_SLAB, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_MOSAIC_SLAB, 5, 20);
        var0.setFlammable(Blocks.OAK_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.SPRUCE_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.BIRCH_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.JUNGLE_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.ACACIA_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.CHERRY_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.DARK_OAK_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.PALE_OAK_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.MANGROVE_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_FENCE_GATE, 5, 20);
        var0.setFlammable(Blocks.OAK_FENCE, 5, 20);
        var0.setFlammable(Blocks.SPRUCE_FENCE, 5, 20);
        var0.setFlammable(Blocks.BIRCH_FENCE, 5, 20);
        var0.setFlammable(Blocks.JUNGLE_FENCE, 5, 20);
        var0.setFlammable(Blocks.ACACIA_FENCE, 5, 20);
        var0.setFlammable(Blocks.CHERRY_FENCE, 5, 20);
        var0.setFlammable(Blocks.DARK_OAK_FENCE, 5, 20);
        var0.setFlammable(Blocks.PALE_OAK_FENCE, 5, 20);
        var0.setFlammable(Blocks.MANGROVE_FENCE, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_FENCE, 5, 20);
        var0.setFlammable(Blocks.OAK_STAIRS, 5, 20);
        var0.setFlammable(Blocks.BIRCH_STAIRS, 5, 20);
        var0.setFlammable(Blocks.SPRUCE_STAIRS, 5, 20);
        var0.setFlammable(Blocks.JUNGLE_STAIRS, 5, 20);
        var0.setFlammable(Blocks.ACACIA_STAIRS, 5, 20);
        var0.setFlammable(Blocks.CHERRY_STAIRS, 5, 20);
        var0.setFlammable(Blocks.DARK_OAK_STAIRS, 5, 20);
        var0.setFlammable(Blocks.PALE_OAK_STAIRS, 5, 20);
        var0.setFlammable(Blocks.MANGROVE_STAIRS, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_STAIRS, 5, 20);
        var0.setFlammable(Blocks.BAMBOO_MOSAIC_STAIRS, 5, 20);
        var0.setFlammable(Blocks.OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.SPRUCE_LOG, 5, 5);
        var0.setFlammable(Blocks.BIRCH_LOG, 5, 5);
        var0.setFlammable(Blocks.JUNGLE_LOG, 5, 5);
        var0.setFlammable(Blocks.ACACIA_LOG, 5, 5);
        var0.setFlammable(Blocks.CHERRY_LOG, 5, 5);
        var0.setFlammable(Blocks.PALE_OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.DARK_OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.MANGROVE_LOG, 5, 5);
        var0.setFlammable(Blocks.BAMBOO_BLOCK, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_SPRUCE_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_BIRCH_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_JUNGLE_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_ACACIA_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_CHERRY_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_DARK_OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_PALE_OAK_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_MANGROVE_LOG, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_BAMBOO_BLOCK, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_SPRUCE_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_BIRCH_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_JUNGLE_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_ACACIA_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_CHERRY_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_DARK_OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_PALE_OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.STRIPPED_MANGROVE_WOOD, 5, 5);
        var0.setFlammable(Blocks.OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.SPRUCE_WOOD, 5, 5);
        var0.setFlammable(Blocks.BIRCH_WOOD, 5, 5);
        var0.setFlammable(Blocks.JUNGLE_WOOD, 5, 5);
        var0.setFlammable(Blocks.ACACIA_WOOD, 5, 5);
        var0.setFlammable(Blocks.CHERRY_WOOD, 5, 5);
        var0.setFlammable(Blocks.PALE_OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.DARK_OAK_WOOD, 5, 5);
        var0.setFlammable(Blocks.MANGROVE_WOOD, 5, 5);
        var0.setFlammable(Blocks.MANGROVE_ROOTS, 5, 20);
        var0.setFlammable(Blocks.OAK_LEAVES, 30, 60);
        var0.setFlammable(Blocks.SPRUCE_LEAVES, 30, 60);
        var0.setFlammable(Blocks.BIRCH_LEAVES, 30, 60);
        var0.setFlammable(Blocks.JUNGLE_LEAVES, 30, 60);
        var0.setFlammable(Blocks.ACACIA_LEAVES, 30, 60);
        var0.setFlammable(Blocks.CHERRY_LEAVES, 30, 60);
        var0.setFlammable(Blocks.DARK_OAK_LEAVES, 30, 60);
        var0.setFlammable(Blocks.PALE_OAK_LEAVES, 30, 60);
        var0.setFlammable(Blocks.MANGROVE_LEAVES, 30, 60);
        var0.setFlammable(Blocks.BOOKSHELF, 30, 20);
        var0.setFlammable(Blocks.TNT, 15, 100);
        var0.setFlammable(Blocks.SHORT_GRASS, 60, 100);
        var0.setFlammable(Blocks.FERN, 60, 100);
        var0.setFlammable(Blocks.DEAD_BUSH, 60, 100);
        var0.setFlammable(Blocks.SUNFLOWER, 60, 100);
        var0.setFlammable(Blocks.LILAC, 60, 100);
        var0.setFlammable(Blocks.ROSE_BUSH, 60, 100);
        var0.setFlammable(Blocks.PEONY, 60, 100);
        var0.setFlammable(Blocks.TALL_GRASS, 60, 100);
        var0.setFlammable(Blocks.LARGE_FERN, 60, 100);
        var0.setFlammable(Blocks.DANDELION, 60, 100);
        var0.setFlammable(Blocks.POPPY, 60, 100);
        var0.setFlammable(Blocks.OPEN_EYEBLOSSOM, 60, 100);
        var0.setFlammable(Blocks.CLOSED_EYEBLOSSOM, 60, 100);
        var0.setFlammable(Blocks.BLUE_ORCHID, 60, 100);
        var0.setFlammable(Blocks.ALLIUM, 60, 100);
        var0.setFlammable(Blocks.AZURE_BLUET, 60, 100);
        var0.setFlammable(Blocks.RED_TULIP, 60, 100);
        var0.setFlammable(Blocks.ORANGE_TULIP, 60, 100);
        var0.setFlammable(Blocks.WHITE_TULIP, 60, 100);
        var0.setFlammable(Blocks.PINK_TULIP, 60, 100);
        var0.setFlammable(Blocks.OXEYE_DAISY, 60, 100);
        var0.setFlammable(Blocks.CORNFLOWER, 60, 100);
        var0.setFlammable(Blocks.LILY_OF_THE_VALLEY, 60, 100);
        var0.setFlammable(Blocks.TORCHFLOWER, 60, 100);
        var0.setFlammable(Blocks.PITCHER_PLANT, 60, 100);
        var0.setFlammable(Blocks.WITHER_ROSE, 60, 100);
        var0.setFlammable(Blocks.PINK_PETALS, 60, 100);
        var0.setFlammable(Blocks.WHITE_WOOL, 30, 60);
        var0.setFlammable(Blocks.ORANGE_WOOL, 30, 60);
        var0.setFlammable(Blocks.MAGENTA_WOOL, 30, 60);
        var0.setFlammable(Blocks.LIGHT_BLUE_WOOL, 30, 60);
        var0.setFlammable(Blocks.YELLOW_WOOL, 30, 60);
        var0.setFlammable(Blocks.LIME_WOOL, 30, 60);
        var0.setFlammable(Blocks.PINK_WOOL, 30, 60);
        var0.setFlammable(Blocks.GRAY_WOOL, 30, 60);
        var0.setFlammable(Blocks.LIGHT_GRAY_WOOL, 30, 60);
        var0.setFlammable(Blocks.CYAN_WOOL, 30, 60);
        var0.setFlammable(Blocks.PURPLE_WOOL, 30, 60);
        var0.setFlammable(Blocks.BLUE_WOOL, 30, 60);
        var0.setFlammable(Blocks.BROWN_WOOL, 30, 60);
        var0.setFlammable(Blocks.GREEN_WOOL, 30, 60);
        var0.setFlammable(Blocks.RED_WOOL, 30, 60);
        var0.setFlammable(Blocks.BLACK_WOOL, 30, 60);
        var0.setFlammable(Blocks.VINE, 15, 100);
        var0.setFlammable(Blocks.COAL_BLOCK, 5, 5);
        var0.setFlammable(Blocks.HAY_BLOCK, 60, 20);
        var0.setFlammable(Blocks.TARGET, 15, 20);
        var0.setFlammable(Blocks.WHITE_CARPET, 60, 20);
        var0.setFlammable(Blocks.ORANGE_CARPET, 60, 20);
        var0.setFlammable(Blocks.MAGENTA_CARPET, 60, 20);
        var0.setFlammable(Blocks.LIGHT_BLUE_CARPET, 60, 20);
        var0.setFlammable(Blocks.YELLOW_CARPET, 60, 20);
        var0.setFlammable(Blocks.LIME_CARPET, 60, 20);
        var0.setFlammable(Blocks.PINK_CARPET, 60, 20);
        var0.setFlammable(Blocks.GRAY_CARPET, 60, 20);
        var0.setFlammable(Blocks.LIGHT_GRAY_CARPET, 60, 20);
        var0.setFlammable(Blocks.CYAN_CARPET, 60, 20);
        var0.setFlammable(Blocks.PURPLE_CARPET, 60, 20);
        var0.setFlammable(Blocks.BLUE_CARPET, 60, 20);
        var0.setFlammable(Blocks.BROWN_CARPET, 60, 20);
        var0.setFlammable(Blocks.GREEN_CARPET, 60, 20);
        var0.setFlammable(Blocks.RED_CARPET, 60, 20);
        var0.setFlammable(Blocks.BLACK_CARPET, 60, 20);
        var0.setFlammable(Blocks.PALE_MOSS_BLOCK, 5, 100);
        var0.setFlammable(Blocks.PALE_MOSS_CARPET, 5, 100);
        var0.setFlammable(Blocks.PALE_HANGING_MOSS, 5, 100);
        var0.setFlammable(Blocks.DRIED_KELP_BLOCK, 30, 60);
        var0.setFlammable(Blocks.BAMBOO, 60, 60);
        var0.setFlammable(Blocks.SCAFFOLDING, 60, 60);
        var0.setFlammable(Blocks.LECTERN, 30, 20);
        var0.setFlammable(Blocks.COMPOSTER, 5, 20);
        var0.setFlammable(Blocks.SWEET_BERRY_BUSH, 60, 100);
        var0.setFlammable(Blocks.BEEHIVE, 5, 20);
        var0.setFlammable(Blocks.BEE_NEST, 30, 20);
        var0.setFlammable(Blocks.AZALEA_LEAVES, 30, 60);
        var0.setFlammable(Blocks.FLOWERING_AZALEA_LEAVES, 30, 60);
        var0.setFlammable(Blocks.CAVE_VINES, 15, 60);
        var0.setFlammable(Blocks.CAVE_VINES_PLANT, 15, 60);
        var0.setFlammable(Blocks.SPORE_BLOSSOM, 60, 100);
        var0.setFlammable(Blocks.AZALEA, 30, 60);
        var0.setFlammable(Blocks.FLOWERING_AZALEA, 30, 60);
        var0.setFlammable(Blocks.BIG_DRIPLEAF, 60, 100);
        var0.setFlammable(Blocks.BIG_DRIPLEAF_STEM, 60, 100);
        var0.setFlammable(Blocks.SMALL_DRIPLEAF, 60, 100);
        var0.setFlammable(Blocks.HANGING_ROOTS, 30, 60);
        var0.setFlammable(Blocks.GLOW_LICHEN, 15, 100);
    }
}

