/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLeash;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockFence
extends BlockTall {
    public static final MapCodec<BlockFence> CODEC = BlockFence.simpleCodec(BlockFence::new);
    private final VoxelShape[] occlusionByIndex;

    public MapCodec<BlockFence> codec() {
        return CODEC;
    }

    public BlockFence(BlockBase.Info var0) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 24.0f, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(WATERLOGGED, false));
        this.occlusionByIndex = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0) {
        return this.occlusionByIndex[this.getAABBIndex(var0)];
    }

    @Override
    protected VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getShape(var0, var1, var2, var3);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    public boolean connectsTo(IBlockData var0, boolean var1, EnumDirection var2) {
        Block var3 = var0.getBlock();
        boolean var4 = this.isSameFence(var0);
        boolean var5 = var3 instanceof BlockFenceGate && BlockFenceGate.connectsToDirection(var0, var2);
        return !BlockFence.isExceptionForConnection(var0) && var1 || var4 || var5;
    }

    private boolean isSameFence(IBlockData var0) {
        return var0.is(TagsBlock.FENCES) && var0.is(TagsBlock.WOODEN_FENCES) == this.defaultBlockState().is(TagsBlock.WOODEN_FENCES);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        return !var1.isClientSide() ? ItemLeash.bindPlayerMobs(var3, var1, var2) : EnumInteractionResult.PASS;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPosition var4 = var2.north();
        BlockPosition var5 = var2.east();
        BlockPosition var6 = var2.south();
        BlockPosition var7 = var2.west();
        IBlockData var8 = var1.getBlockState(var4);
        IBlockData var9 = var1.getBlockState(var5);
        IBlockData var10 = var1.getBlockState(var6);
        IBlockData var11 = var1.getBlockState(var7);
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)super.getStateForPlacement(var0).setValue(NORTH, this.connectsTo(var8, var8.isFaceSturdy(var1, var4, EnumDirection.SOUTH), EnumDirection.SOUTH))).setValue(EAST, this.connectsTo(var9, var9.isFaceSturdy(var1, var5, EnumDirection.WEST), EnumDirection.WEST))).setValue(SOUTH, this.connectsTo(var10, var10.isFaceSturdy(var1, var6, EnumDirection.NORTH), EnumDirection.NORTH))).setValue(WEST, this.connectsTo(var11, var11.isFaceSturdy(var1, var7, EnumDirection.EAST), EnumDirection.EAST))).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue((IBlockState)PROPERTY_BY_DIRECTION.get(var4), this.connectsTo(var6, var6.isFaceSturdy(var1, var5, var4.getOpposite()), var4.getOpposite()));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }
}

