/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnchantmentTable
extends BlockTileEntity {
    public static final MapCodec<BlockEnchantmentTable> CODEC = BlockEnchantmentTable.simpleCodec(BlockEnchantmentTable::new);
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    public static final List<BlockPosition> BOOKSHELF_OFFSETS = BlockPosition.betweenClosedStream(-2, 0, -2, 2, 1, 2).filter(var0 -> Math.abs(var0.getX()) == 2 || Math.abs(var0.getZ()) == 2).map(BlockPosition::immutable).toList();

    public MapCodec<BlockEnchantmentTable> codec() {
        return CODEC;
    }

    protected BlockEnchantmentTable(BlockBase.Info var0) {
        super(var0);
    }

    public static boolean isValidBookShelf(World var0, BlockPosition var1, BlockPosition var2) {
        return var0.getBlockState(var1.offset(var2)).is(TagsBlock.ENCHANTMENT_POWER_PROVIDER) && var0.getBlockState(var1.offset(var2.getX() / 2, var2.getY(), var2.getZ() / 2)).is(TagsBlock.ENCHANTMENT_POWER_TRANSMITTER);
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        super.animateTick(var0, var1, var2, var3);
        for (BlockPosition var5 : BOOKSHELF_OFFSETS) {
            if (var3.nextInt(16) != 0 || !BlockEnchantmentTable.isValidBookShelf(var1, var2, var5)) continue;
            var1.addParticle(Particles.ENCHANT, (double)var2.getX() + 0.5, (double)var2.getY() + 2.0, (double)var2.getZ() + 0.5, (double)((float)var5.getX() + var3.nextFloat()) - 0.5, (float)var5.getY() - var3.nextFloat() - 1.0f, (double)((float)var5.getZ() + var3.nextFloat()) - 0.5);
        }
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEnchantTable(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide ? BlockEnchantmentTable.createTickerHelper(var2, TileEntityTypes.ENCHANTING_TABLE, TileEntityEnchantTable::bookAnimationTick) : null;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var1.isClientSide) {
            var3.openMenu(var0.getMenuProvider(var1, var2));
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var22) {
        TileEntity var32 = var1.getBlockEntity(var22);
        if (var32 instanceof TileEntityEnchantTable) {
            IChatBaseComponent var42 = ((INamableTileEntity)((Object)var32)).getDisplayName();
            return new TileInventory((var2, var3, var4) -> new ContainerEnchantTable(var2, var3, ContainerAccess.create(var1, var22)), var42);
        }
        return null;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

