/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class AmethystClusterBlock
extends AmethystBlock
implements IBlockWaterlogged {
    public static final MapCodec<AmethystClusterBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.FLOAT.fieldOf("height").forGetter(var0 -> Float.valueOf(var0.height)), (App)Codec.FLOAT.fieldOf("aabb_offset").forGetter(var0 -> Float.valueOf(var0.aabbOffset)), AmethystClusterBlock.propertiesCodec()).apply((Applicative)var02, AmethystClusterBlock::new));
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.FACING;
    private final float height;
    private final float aabbOffset;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public MapCodec<AmethystClusterBlock> codec() {
        return CODEC;
    }

    public AmethystClusterBlock(float var0, float var1, BlockBase.Info var2) {
        super(var2);
        this.registerDefaultState((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, EnumDirection.UP));
        this.upAabb = Block.box(var1, 0.0, var1, 16.0f - var1, var0, 16.0f - var1);
        this.downAabb = Block.box(var1, 16.0f - var0, var1, 16.0f - var1, 16.0, 16.0f - var1);
        this.northAabb = Block.box(var1, var1, 16.0f - var0, 16.0f - var1, 16.0f - var1, 16.0);
        this.southAabb = Block.box(var1, var1, 0.0, 16.0f - var1, 16.0f - var1, var0);
        this.eastAabb = Block.box(0.0, var1, var1, var0, 16.0f - var1, 16.0f - var1);
        this.westAabb = Block.box(16.0f - var0, var1, var1, 16.0, 16.0f - var1, 16.0f - var1);
        this.height = var0;
        this.aabbOffset = var1;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection var4 = var0.getValue(FACING);
        switch (var4) {
            case NORTH: {
                return this.northAabb;
            }
            case SOUTH: {
                return this.southAabb;
            }
            case EAST: {
                return this.eastAabb;
            }
            case WEST: {
                return this.westAabb;
            }
            case DOWN: {
                return this.downAabb;
            }
        }
        return this.upAabb;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(FACING);
        BlockPosition var4 = var2.relative(var3.getOpposite());
        return var1.getBlockState(var4).isFaceSturdy(var1, var4, var3);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4 == var0.getValue(FACING).getOpposite() && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var1.getFluidState(var2).getType() == FluidTypes.WATER)).setValue(FACING, var0.getClickedFace());
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(WATERLOGGED, FACING);
    }
}

