/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;

public class BiomeFog {
    public static final Codec<BiomeFog> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("fog_color").forGetter(var0 -> var0.fogColor), (App)Codec.INT.fieldOf("water_color").forGetter(var0 -> var0.waterColor), (App)Codec.INT.fieldOf("water_fog_color").forGetter(var0 -> var0.waterFogColor), (App)Codec.INT.fieldOf("sky_color").forGetter(var0 -> var0.skyColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(var0 -> var0.foliageColorOverride), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(var0 -> var0.grassColorOverride), (App)GrassColor.CODEC.optionalFieldOf("grass_color_modifier", (Object)GrassColor.NONE).forGetter(var0 -> var0.grassColorModifier), (App)BiomeParticles.CODEC.optionalFieldOf("particle").forGetter(var0 -> var0.ambientParticleSettings), (App)SoundEffect.CODEC.optionalFieldOf("ambient_sound").forGetter(var0 -> var0.ambientLoopSoundEvent), (App)CaveSoundSettings.CODEC.optionalFieldOf("mood_sound").forGetter(var0 -> var0.ambientMoodSettings), (App)CaveSound.CODEC.optionalFieldOf("additions_sound").forGetter(var0 -> var0.ambientAdditionsSettings), (App)SimpleWeightedRandomList.wrappedCodecAllowingEmpty(Music.CODEC).optionalFieldOf("music").forGetter(var0 -> var0.backgroundMusic), (App)Codec.FLOAT.fieldOf("music_volume").orElse((Object)Float.valueOf(1.0f)).forGetter(var0 -> Float.valueOf(var0.backgroundMusicVolume))).apply((Applicative)var02, BiomeFog::new));
    private final int fogColor;
    private final int waterColor;
    private final int waterFogColor;
    private final int skyColor;
    private final Optional<Integer> foliageColorOverride;
    private final Optional<Integer> grassColorOverride;
    private final GrassColor grassColorModifier;
    private final Optional<BiomeParticles> ambientParticleSettings;
    private final Optional<Holder<SoundEffect>> ambientLoopSoundEvent;
    private final Optional<CaveSoundSettings> ambientMoodSettings;
    private final Optional<CaveSound> ambientAdditionsSettings;
    private final Optional<SimpleWeightedRandomList<Music>> backgroundMusic;
    private final float backgroundMusicVolume;

    BiomeFog(int var0, int var1, int var2, int var3, Optional<Integer> var4, Optional<Integer> var5, GrassColor var6, Optional<BiomeParticles> var7, Optional<Holder<SoundEffect>> var8, Optional<CaveSoundSettings> var9, Optional<CaveSound> var10, Optional<SimpleWeightedRandomList<Music>> var11, float var12) {
        this.fogColor = var0;
        this.waterColor = var1;
        this.waterFogColor = var2;
        this.skyColor = var3;
        this.foliageColorOverride = var4;
        this.grassColorOverride = var5;
        this.grassColorModifier = var6;
        this.ambientParticleSettings = var7;
        this.ambientLoopSoundEvent = var8;
        this.ambientMoodSettings = var9;
        this.ambientAdditionsSettings = var10;
        this.backgroundMusic = var11;
        this.backgroundMusicVolume = var12;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public Optional<Integer> getFoliageColorOverride() {
        return this.foliageColorOverride;
    }

    public Optional<Integer> getGrassColorOverride() {
        return this.grassColorOverride;
    }

    public GrassColor getGrassColorModifier() {
        return this.grassColorModifier;
    }

    public Optional<BiomeParticles> getAmbientParticleSettings() {
        return this.ambientParticleSettings;
    }

    public Optional<Holder<SoundEffect>> getAmbientLoopSoundEvent() {
        return this.ambientLoopSoundEvent;
    }

    public Optional<CaveSoundSettings> getAmbientMoodSettings() {
        return this.ambientMoodSettings;
    }

    public Optional<CaveSound> getAmbientAdditionsSettings() {
        return this.ambientAdditionsSettings;
    }

    public Optional<SimpleWeightedRandomList<Music>> getBackgroundMusic() {
        return this.backgroundMusic;
    }

    public float getBackgroundMusicVolume() {
        return this.backgroundMusicVolume;
    }

    public static abstract sealed class GrassColor
    extends Enum<GrassColor>
    implements INamable {
        public static final /* enum */ GrassColor NONE = new GrassColor("none"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return var4;
            }
        };
        public static final /* enum */ GrassColor DARK_FOREST = new GrassColor("dark_forest"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return (var4 & 0xFEFEFE) + 2634762 >> 1;
            }
        };
        public static final /* enum */ GrassColor SWAMP = new GrassColor("swamp"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                double var5 = BiomeBase.BIOME_INFO_NOISE.getValue(var0 * 0.0225, var2 * 0.0225, false);
                if (var5 < -0.1) {
                    return 5011004;
                }
                return 6975545;
            }
        };
        private final String name;
        public static final Codec<GrassColor> CODEC;
        private static final /* synthetic */ GrassColor[] f;

        public static GrassColor[] values() {
            return (GrassColor[])f.clone();
        }

        public static GrassColor valueOf(String var0) {
            return Enum.valueOf(GrassColor.class, var0);
        }

        public abstract int modifyColor(double var1, double var3, int var5);

        GrassColor(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ GrassColor[] b() {
            return new GrassColor[]{NONE, DARK_FOREST, SWAMP};
        }

        static {
            f = GrassColor.b();
            CODEC = INamable.fromEnum(GrassColor::values);
        }
    }

    public static class a {
        private OptionalInt fogColor = OptionalInt.empty();
        private OptionalInt waterColor = OptionalInt.empty();
        private OptionalInt waterFogColor = OptionalInt.empty();
        private OptionalInt skyColor = OptionalInt.empty();
        private Optional<Integer> foliageColorOverride = Optional.empty();
        private Optional<Integer> grassColorOverride = Optional.empty();
        private GrassColor grassColorModifier = GrassColor.NONE;
        private Optional<BiomeParticles> ambientParticle = Optional.empty();
        private Optional<Holder<SoundEffect>> ambientLoopSoundEvent = Optional.empty();
        private Optional<CaveSoundSettings> ambientMoodSettings = Optional.empty();
        private Optional<CaveSound> ambientAdditionsSettings = Optional.empty();
        private Optional<SimpleWeightedRandomList<Music>> backgroundMusic = Optional.empty();
        private float backgroundMusicVolume = 1.0f;

        public a fogColor(int var0) {
            this.fogColor = OptionalInt.of(var0);
            return this;
        }

        public a waterColor(int var0) {
            this.waterColor = OptionalInt.of(var0);
            return this;
        }

        public a waterFogColor(int var0) {
            this.waterFogColor = OptionalInt.of(var0);
            return this;
        }

        public a skyColor(int var0) {
            this.skyColor = OptionalInt.of(var0);
            return this;
        }

        public a foliageColorOverride(int var0) {
            this.foliageColorOverride = Optional.of(var0);
            return this;
        }

        public a grassColorOverride(int var0) {
            this.grassColorOverride = Optional.of(var0);
            return this;
        }

        public a grassColorModifier(GrassColor var0) {
            this.grassColorModifier = var0;
            return this;
        }

        public a ambientParticle(BiomeParticles var0) {
            this.ambientParticle = Optional.of(var0);
            return this;
        }

        public a ambientLoopSound(Holder<SoundEffect> var0) {
            this.ambientLoopSoundEvent = Optional.of(var0);
            return this;
        }

        public a ambientMoodSound(CaveSoundSettings var0) {
            this.ambientMoodSettings = Optional.of(var0);
            return this;
        }

        public a ambientAdditionsSound(CaveSound var0) {
            this.ambientAdditionsSettings = Optional.of(var0);
            return this;
        }

        public a backgroundMusic(@Nullable Music var0) {
            if (var0 == null) {
                this.backgroundMusic = Optional.empty();
                return this;
            }
            this.backgroundMusic = Optional.of(SimpleWeightedRandomList.single(var0));
            return this;
        }

        public a silenceAllBackgroundMusic() {
            return this.backgroundMusic(SimpleWeightedRandomList.empty()).backgroundMusicVolume(0.0f);
        }

        public a backgroundMusic(SimpleWeightedRandomList<Music> var0) {
            this.backgroundMusic = Optional.of(var0);
            return this;
        }

        public a backgroundMusicVolume(float var0) {
            this.backgroundMusicVolume = var0;
            return this;
        }

        public BiomeFog build() {
            return new BiomeFog(this.fogColor.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.waterColor.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.waterFogColor.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.skyColor.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.foliageColorOverride, this.grassColorOverride, this.grassColorModifier, this.ambientParticle, this.ambientLoopSoundEvent, this.ambientMoodSettings, this.ambientAdditionsSettings, this.backgroundMusic, this.backgroundMusicVolume);
        }
    }
}

