/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;

public final class BiomeBase {
    public static final Codec<BiomeBase> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.CODEC.forGetter(var0 -> var0.climateSettings), (App)BiomeFog.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects), (App)BiomeSettingsGeneration.CODEC.forGetter(var0 -> var0.generationSettings), (App)BiomeSettingsMobs.CODEC.forGetter(var0 -> var0.mobSettings)).apply((Applicative)var02, BiomeBase::new));
    public static final Codec<BiomeBase> NETWORK_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.CODEC.forGetter(var0 -> var0.climateSettings), (App)BiomeFog.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects)).apply((Applicative)var02, (var0, var1) -> new BiomeBase((ClimateSettings)var0, (BiomeFog)var1, BiomeSettingsGeneration.EMPTY, BiomeSettingsMobs.EMPTY)));
    public static final Codec<Holder<BiomeBase>> CODEC = RegistryFileCodec.create(Registries.BIOME, DIRECT_CODEC);
    public static final Codec<HolderSet<BiomeBase>> LIST_CODEC = RegistryCodecs.homogeneousList(Registries.BIOME, DIRECT_CODEC);
    private static final NoiseGenerator3 TEMPERATURE_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 FROZEN_TEMPERATURE_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 BIOME_INFO_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int TEMPERATURE_CACHE_SIZE = 1024;
    public final ClimateSettings climateSettings;
    private final BiomeSettingsGeneration generationSettings;
    private final BiomeSettingsMobs mobSettings;
    private final BiomeFog specialEffects;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> SystemUtils.make(() -> {
        Long2FloatLinkedOpenHashMap var0 = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue(Float.NaN);
        return var0;
    }));

    BiomeBase(ClimateSettings var0, BiomeFog var1, BiomeSettingsGeneration var2, BiomeSettingsMobs var3) {
        this.climateSettings = var0;
        this.generationSettings = var2;
        this.mobSettings = var3;
        this.specialEffects = var1;
    }

    public int getSkyColor() {
        return this.specialEffects.getSkyColor();
    }

    public BiomeSettingsMobs getMobSettings() {
        return this.mobSettings;
    }

    public boolean hasPrecipitation() {
        return this.climateSettings.hasPrecipitation();
    }

    public Precipitation getPrecipitationAt(BlockPosition var0, int var1) {
        if (!this.hasPrecipitation()) {
            return Precipitation.NONE;
        }
        return this.coldEnoughToSnow(var0, var1) ? Precipitation.SNOW : Precipitation.RAIN;
    }

    private float getHeightAdjustedTemperature(BlockPosition var0, int var1) {
        float var2 = this.climateSettings.temperatureModifier.modifyTemperature(var0, this.getBaseTemperature());
        int var3 = var1 + 17;
        if (var0.getY() > var3) {
            float var4 = (float)(TEMPERATURE_NOISE.getValue((float)var0.getX() / 8.0f, (float)var0.getZ() / 8.0f, false) * 8.0);
            return var2 - (var4 + (float)var0.getY() - (float)var3) * 0.05f / 40.0f;
        }
        return var2;
    }

    @Deprecated
    public float getTemperature(BlockPosition var0, int var1) {
        long var2 = var0.asLong();
        Long2FloatLinkedOpenHashMap var4 = this.temperatureCache.get();
        float var5 = var4.get(var2);
        if (!Float.isNaN(var5)) {
            return var5;
        }
        float var6 = this.getHeightAdjustedTemperature(var0, var1);
        if (var4.size() == 1024) {
            var4.removeFirstFloat();
        }
        var4.put(var2, var6);
        return var6;
    }

    public boolean shouldFreeze(IWorldReader var0, BlockPosition var1) {
        return this.shouldFreeze(var0, var1, true);
    }

    public boolean shouldFreeze(IWorldReader var0, BlockPosition var1, boolean var2) {
        if (this.warmEnoughToRain(var1, var0.getSeaLevel())) {
            return false;
        }
        if (var0.isInsideBuildHeight(var1.getY()) && var0.getBrightness(EnumSkyBlock.BLOCK, var1) < 10) {
            IBlockData var3 = var0.getBlockState(var1);
            Fluid var4 = var0.getFluidState(var1);
            if (var4.getType() == FluidTypes.WATER && var3.getBlock() instanceof BlockFluids) {
                boolean var5;
                if (!var2) {
                    return true;
                }
                boolean bl = var5 = var0.isWaterAt(var1.west()) && var0.isWaterAt(var1.east()) && var0.isWaterAt(var1.north()) && var0.isWaterAt(var1.south());
                if (!var5) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean coldEnoughToSnow(BlockPosition var0, int var1) {
        return !this.warmEnoughToRain(var0, var1);
    }

    public boolean warmEnoughToRain(BlockPosition var0, int var1) {
        return this.getTemperature(var0, var1) >= 0.15f;
    }

    public boolean shouldMeltFrozenOceanIcebergSlightly(BlockPosition var0, int var1) {
        return this.getTemperature(var0, var1) > 0.1f;
    }

    public boolean shouldSnow(IWorldReader var0, BlockPosition var1) {
        IBlockData var2;
        if (this.warmEnoughToRain(var1, var0.getSeaLevel())) {
            return false;
        }
        return var0.isInsideBuildHeight(var1.getY()) && var0.getBrightness(EnumSkyBlock.BLOCK, var1) < 10 && ((var2 = var0.getBlockState(var1)).isAir() || var2.is(Blocks.SNOW)) && Blocks.SNOW.defaultBlockState().canSurvive(var0, var1);
    }

    public BiomeSettingsGeneration getGenerationSettings() {
        return this.generationSettings;
    }

    public int getFogColor() {
        return this.specialEffects.getFogColor();
    }

    public int getGrassColor(double var0, double var2) {
        int var4 = this.specialEffects.getGrassColorOverride().orElseGet(this::getGrassColorFromTexture);
        return this.specialEffects.getGrassColorModifier().modifyColor(var0, var2, var4);
    }

    private int getGrassColorFromTexture() {
        double var0 = MathHelper.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = MathHelper.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return GrassColor.get(var0, var2);
    }

    public int getFoliageColor() {
        return this.specialEffects.getFoliageColorOverride().orElseGet(this::getFoliageColorFromTexture);
    }

    private int getFoliageColorFromTexture() {
        double var0 = MathHelper.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = MathHelper.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return FoliageColor.get(var0, var2);
    }

    public float getBaseTemperature() {
        return this.climateSettings.temperature;
    }

    public BiomeFog getSpecialEffects() {
        return this.specialEffects;
    }

    public int getWaterColor() {
        return this.specialEffects.getWaterColor();
    }

    public int getWaterFogColor() {
        return this.specialEffects.getWaterFogColor();
    }

    public Optional<BiomeParticles> getAmbientParticle() {
        return this.specialEffects.getAmbientParticleSettings();
    }

    public Optional<Holder<SoundEffect>> getAmbientLoop() {
        return this.specialEffects.getAmbientLoopSoundEvent();
    }

    public Optional<CaveSoundSettings> getAmbientMood() {
        return this.specialEffects.getAmbientMoodSettings();
    }

    public Optional<CaveSound> getAmbientAdditions() {
        return this.specialEffects.getAmbientAdditionsSettings();
    }

    public Optional<SimpleWeightedRandomList<Music>> getBackgroundMusic() {
        return this.specialEffects.getBackgroundMusic();
    }

    public float getBackgroundMusicVolume() {
        return this.specialEffects.getBackgroundMusicVolume();
    }

    public static final class ClimateSettings
    extends Record {
        private final boolean hasPrecipitation;
        final float temperature;
        final TemperatureModifier temperatureModifier;
        final float downfall;
        public static final MapCodec<ClimateSettings> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(var0 -> var0.hasPrecipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(var0 -> Float.valueOf(var0.temperature)), (App)TemperatureModifier.CODEC.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(var0 -> var0.temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(var0 -> Float.valueOf(var0.downfall))).apply((Applicative)var02, ClimateSettings::new));

        ClimateSettings(boolean var0, float var1, TemperatureModifier var2, float var3) {
            this.hasPrecipitation = var0;
            this.temperature = var1;
            this.temperatureModifier = var2;
            this.downfall = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this, var0);
        }

        public boolean hasPrecipitation() {
            return this.hasPrecipitation;
        }

        public float temperature() {
            return this.temperature;
        }

        public TemperatureModifier temperatureModifier() {
            return this.temperatureModifier;
        }

        public float downfall() {
            return this.downfall;
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements INamable {
        public static final /* enum */ Precipitation NONE = new Precipitation("none");
        public static final /* enum */ Precipitation RAIN = new Precipitation("rain");
        public static final /* enum */ Precipitation SNOW = new Precipitation("snow");
        public static final Codec<Precipitation> CODEC;
        private final String name;
        private static final /* synthetic */ Precipitation[] f;

        public static Precipitation[] values() {
            return (Precipitation[])f.clone();
        }

        public static Precipitation valueOf(String var0) {
            return Enum.valueOf(Precipitation.class, var0);
        }

        private Precipitation(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Precipitation[] a() {
            return new Precipitation[]{NONE, RAIN, SNOW};
        }

        static {
            f = Precipitation.a();
            CODEC = INamable.fromEnum(Precipitation::values);
        }
    }

    public static abstract sealed class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier NONE = new TemperatureModifier("none"){

            @Override
            public float modifyTemperature(BlockPosition var0, float var1) {
                return var1;
            }
        };
        public static final /* enum */ TemperatureModifier FROZEN = new TemperatureModifier("frozen"){

            @Override
            public float modifyTemperature(BlockPosition var0, float var1) {
                double var8;
                double var4;
                double var2 = FROZEN_TEMPERATURE_NOISE.getValue((double)var0.getX() * 0.05, (double)var0.getZ() * 0.05, false) * 7.0;
                double var6 = var2 + (var4 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.2, (double)var0.getZ() * 0.2, false));
                if (var6 < 0.3 && (var8 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.09, (double)var0.getZ() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return var1;
            }
        };
        private final String name;
        public static final Codec<TemperatureModifier> CODEC;
        private static final /* synthetic */ TemperatureModifier[] e;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])e.clone();
        }

        public static TemperatureModifier valueOf(String var0) {
            return Enum.valueOf(TemperatureModifier.class, var0);
        }

        public abstract float modifyTemperature(BlockPosition var1, float var2);

        TemperatureModifier(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{NONE, FROZEN};
        }

        static {
            e = TemperatureModifier.b();
            CODEC = INamable.fromEnum(TemperatureModifier::values);
        }
    }

    public static class a {
        private boolean hasPrecipitation = true;
        @Nullable
        private Float temperature;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;
        @Nullable
        private Float downfall;
        @Nullable
        private BiomeFog specialEffects;
        @Nullable
        private BiomeSettingsMobs mobSpawnSettings;
        @Nullable
        private BiomeSettingsGeneration generationSettings;

        public a hasPrecipitation(boolean var0) {
            this.hasPrecipitation = var0;
            return this;
        }

        public a temperature(float var0) {
            this.temperature = Float.valueOf(var0);
            return this;
        }

        public a downfall(float var0) {
            this.downfall = Float.valueOf(var0);
            return this;
        }

        public a specialEffects(BiomeFog var0) {
            this.specialEffects = var0;
            return this;
        }

        public a mobSpawnSettings(BiomeSettingsMobs var0) {
            this.mobSpawnSettings = var0;
            return this;
        }

        public a generationSettings(BiomeSettingsGeneration var0) {
            this.generationSettings = var0;
            return this;
        }

        public a temperatureAdjustment(TemperatureModifier var0) {
            this.temperatureModifier = var0;
            return this;
        }

        public BiomeBase build() {
            if (this.temperature == null || this.downfall == null || this.specialEffects == null || this.mobSpawnSettings == null || this.generationSettings == null) {
                throw new IllegalStateException("You are missing parameters to build a proper biome\n" + String.valueOf(this));
            }
            return new BiomeBase(new ClimateSettings(this.hasPrecipitation, this.temperature.floatValue(), this.temperatureModifier, this.downfall.floatValue()), this.specialEffects, this.generationSettings, this.mobSpawnSettings);
        }

        public String toString() {
            return "BiomeBuilder{\nhasPrecipitation=" + this.hasPrecipitation + ",\ntemperature=" + this.temperature + ",\ntemperatureModifier=" + String.valueOf(this.temperatureModifier) + ",\ndownfall=" + this.downfall + ",\nspecialEffects=" + String.valueOf(this.specialEffects) + ",\nmobSpawnSettings=" + String.valueOf(this.mobSpawnSettings) + ",\ngenerationSettings=" + String.valueOf(this.generationSettings) + ",\n}";
        }
    }
}

