/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.IWorldTime;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public interface GeneratorAccess
extends ICombinedAccess,
IWorldTime,
ScheduledTickAccess {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    @Override
    default public <T> NextTickListEntry<T> createTick(BlockPosition var0, T var1, int var2, TickListPriority var3) {
        return new NextTickListEntry<T>(var1, var0, this.getLevelData().getGameTime() + (long)var2, var3, this.nextSubTickCount());
    }

    @Override
    default public <T> NextTickListEntry<T> createTick(BlockPosition var0, T var1, int var2) {
        return new NextTickListEntry<T>(var1, var0, this.getLevelData().getGameTime() + (long)var2, this.nextSubTickCount());
    }

    public WorldData getLevelData();

    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var1);

    @Nullable
    public MinecraftServer getServer();

    default public EnumDifficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public IChunkProvider getChunkSource();

    @Override
    default public boolean hasChunk(int var0, int var1) {
        return this.getChunkSource().hasChunk(var0, var1);
    }

    public RandomSource getRandom();

    default public void blockUpdated(BlockPosition var0, Block var1) {
    }

    default public void neighborShapeChanged(EnumDirection var0, BlockPosition var1, BlockPosition var2, IBlockData var3, int var4, int var5) {
        NeighborUpdater.executeShapeUpdate(this, var0, var1, var2, var3, var4, var5 - 1);
    }

    default public void playSound(@Nullable EntityHuman var0, BlockPosition var1, SoundEffect var2, SoundCategory var3) {
        this.playSound(var0, var1, var2, var3, 1.0f, 1.0f);
    }

    public void playSound(@Nullable EntityHuman var1, BlockPosition var2, SoundEffect var3, SoundCategory var4, float var5, float var6);

    public void addParticle(ParticleParam var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable EntityHuman var1, int var2, BlockPosition var3, int var4);

    default public void levelEvent(int var0, BlockPosition var1, int var2) {
        this.levelEvent(null, var0, var1, var2);
    }

    public void gameEvent(Holder<GameEvent> var1, Vec3D var2, GameEvent.a var3);

    default public void gameEvent(@Nullable Entity var0, Holder<GameEvent> var1, Vec3D var2) {
        this.gameEvent(var1, var2, new GameEvent.a(var0, null));
    }

    default public void gameEvent(@Nullable Entity var0, Holder<GameEvent> var1, BlockPosition var2) {
        this.gameEvent(var1, var2, new GameEvent.a(var0, null));
    }

    default public void gameEvent(Holder<GameEvent> var0, BlockPosition var1, GameEvent.a var2) {
        this.gameEvent(var0, Vec3D.atCenterOf(var1), var2);
    }

    default public void gameEvent(ResourceKey<GameEvent> var0, BlockPosition var1, GameEvent.a var2) {
        this.gameEvent((Holder<GameEvent>)this.registryAccess().lookupOrThrow(Registries.GAME_EVENT).getOrThrow(var0), var1, var2);
    }
}

