/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.ChangeItemDamage;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageImmunity;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.MultiplyValue;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.RemoveBinomial;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.SetValue;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.EnchantmentActiveCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionInverted;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionWeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.phys.Vec3D;

public class Enchantments {
    public static final ResourceKey<Enchantment> PROTECTION = Enchantments.key("protection");
    public static final ResourceKey<Enchantment> FIRE_PROTECTION = Enchantments.key("fire_protection");
    public static final ResourceKey<Enchantment> FEATHER_FALLING = Enchantments.key("feather_falling");
    public static final ResourceKey<Enchantment> BLAST_PROTECTION = Enchantments.key("blast_protection");
    public static final ResourceKey<Enchantment> PROJECTILE_PROTECTION = Enchantments.key("projectile_protection");
    public static final ResourceKey<Enchantment> RESPIRATION = Enchantments.key("respiration");
    public static final ResourceKey<Enchantment> AQUA_AFFINITY = Enchantments.key("aqua_affinity");
    public static final ResourceKey<Enchantment> THORNS = Enchantments.key("thorns");
    public static final ResourceKey<Enchantment> DEPTH_STRIDER = Enchantments.key("depth_strider");
    public static final ResourceKey<Enchantment> FROST_WALKER = Enchantments.key("frost_walker");
    public static final ResourceKey<Enchantment> BINDING_CURSE = Enchantments.key("binding_curse");
    public static final ResourceKey<Enchantment> SOUL_SPEED = Enchantments.key("soul_speed");
    public static final ResourceKey<Enchantment> SWIFT_SNEAK = Enchantments.key("swift_sneak");
    public static final ResourceKey<Enchantment> SHARPNESS = Enchantments.key("sharpness");
    public static final ResourceKey<Enchantment> SMITE = Enchantments.key("smite");
    public static final ResourceKey<Enchantment> BANE_OF_ARTHROPODS = Enchantments.key("bane_of_arthropods");
    public static final ResourceKey<Enchantment> KNOCKBACK = Enchantments.key("knockback");
    public static final ResourceKey<Enchantment> FIRE_ASPECT = Enchantments.key("fire_aspect");
    public static final ResourceKey<Enchantment> LOOTING = Enchantments.key("looting");
    public static final ResourceKey<Enchantment> SWEEPING_EDGE = Enchantments.key("sweeping_edge");
    public static final ResourceKey<Enchantment> EFFICIENCY = Enchantments.key("efficiency");
    public static final ResourceKey<Enchantment> SILK_TOUCH = Enchantments.key("silk_touch");
    public static final ResourceKey<Enchantment> UNBREAKING = Enchantments.key("unbreaking");
    public static final ResourceKey<Enchantment> FORTUNE = Enchantments.key("fortune");
    public static final ResourceKey<Enchantment> POWER = Enchantments.key("power");
    public static final ResourceKey<Enchantment> PUNCH = Enchantments.key("punch");
    public static final ResourceKey<Enchantment> FLAME = Enchantments.key("flame");
    public static final ResourceKey<Enchantment> INFINITY = Enchantments.key("infinity");
    public static final ResourceKey<Enchantment> LUCK_OF_THE_SEA = Enchantments.key("luck_of_the_sea");
    public static final ResourceKey<Enchantment> LURE = Enchantments.key("lure");
    public static final ResourceKey<Enchantment> LOYALTY = Enchantments.key("loyalty");
    public static final ResourceKey<Enchantment> IMPALING = Enchantments.key("impaling");
    public static final ResourceKey<Enchantment> RIPTIDE = Enchantments.key("riptide");
    public static final ResourceKey<Enchantment> CHANNELING = Enchantments.key("channeling");
    public static final ResourceKey<Enchantment> MULTISHOT = Enchantments.key("multishot");
    public static final ResourceKey<Enchantment> QUICK_CHARGE = Enchantments.key("quick_charge");
    public static final ResourceKey<Enchantment> PIERCING = Enchantments.key("piercing");
    public static final ResourceKey<Enchantment> DENSITY = Enchantments.key("density");
    public static final ResourceKey<Enchantment> BREACH = Enchantments.key("breach");
    public static final ResourceKey<Enchantment> WIND_BURST = Enchantments.key("wind_burst");
    public static final ResourceKey<Enchantment> MENDING = Enchantments.key("mending");
    public static final ResourceKey<Enchantment> VANISHING_CURSE = Enchantments.key("vanishing_curse");

    public static void bootstrap(BootstrapContext<Enchantment> var0) {
        HolderGetter<DamageType> var1 = var0.lookup(Registries.DAMAGE_TYPE);
        HolderGetter<Enchantment> var2 = var0.lookup(Registries.ENCHANTMENT);
        HolderGetter<Item> var3 = var0.lookup(Registries.ITEM);
        HolderGetter<Block> var4 = var0.lookup(Registries.BLOCK);
        HolderGetter<EntityTypes<?>> var5 = var0.lookup(Registries.ENTITY_TYPE);
        Enchantments.register(var0, PROTECTION, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 10, 4, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(12, 11), 1, EquipmentSlotGroup.ARMOR)).exclusiveWith(var2.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(1.0f)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        Enchantments.register(var0, FIRE_PROTECTION, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(10, 8), Enchantment.dynamicCost(18, 8), 2, EquipmentSlotGroup.ARMOR)).exclusiveWith(var2.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0f)), AllOfCondition.allOf(LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_FIRE)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY))))).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.fire_protection"), GenericAttributes.BURNING_TIME, LevelBasedValue.perLevel(-0.15f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)));
        Enchantments.register(var0, FEATHER_FALLING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(5, 6), Enchantment.dynamicCost(11, 6), 2, EquipmentSlotGroup.ARMOR)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(3.0f)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_FALL)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        Enchantments.register(var0, BLAST_PROTECTION, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 2, 4, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(13, 8), 4, EquipmentSlotGroup.ARMOR)).exclusiveWith(var2.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0f)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_EXPLOSION)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.blast_protection"), GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE, LevelBasedValue.perLevel(0.15f), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, PROJECTILE_PROTECTION, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(3, 6), Enchantment.dynamicCost(9, 6), 2, EquipmentSlotGroup.ARMOR)).exclusiveWith(var2.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0f)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        Enchantments.register(var0, RESPIRATION, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.HEAD_ARMOR_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(40, 10), 4, EquipmentSlotGroup.HEAD)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.respiration"), GenericAttributes.OXYGEN_BONUS, LevelBasedValue.perLevel(1.0f), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, AQUA_AFFINITY, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.HEAD_ARMOR_ENCHANTABLE), 2, 1, Enchantment.constantCost(1), Enchantment.constantCost(41), 4, EquipmentSlotGroup.HEAD)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.aqua_affinity"), GenericAttributes.SUBMERGED_MINING_SPEED, LevelBasedValue.perLevel(4.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        Enchantments.register(var0, THORNS, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), var3.getOrThrow(TagsItem.CHEST_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 8, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, AllOf.entityEffects(new DamageEntity(LevelBasedValue.constant(1.0f), LevelBasedValue.constant(5.0f), var1.getOrThrow(DamageTypes.THORNS)), new ChangeItemDamage(LevelBasedValue.constant(2.0f))), LootItemConditionRandomChance.randomChance(EnchantmentLevelProvider.forEnchantmentLevel(LevelBasedValue.perLevel(0.15f)))));
        Enchantments.register(var0, DEPTH_STRIDER, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, EquipmentSlotGroup.FEET)).exclusiveWith(var2.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.depth_strider"), GenericAttributes.WATER_MOVEMENT_EFFICIENCY, LevelBasedValue.perLevel(0.33333334f), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, FROST_WALKER, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, EquipmentSlotGroup.FEET)).exclusiveWith(var2.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_IMMUNITY, DamageImmunity.INSTANCE, LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.BURN_FROM_STEPPING)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new ReplaceDisk(new LevelBasedValue.a(LevelBasedValue.perLevel(3.0f, 1.0f), 0.0f, 16.0f), LevelBasedValue.constant(1.0f), new BaseBlockPosition(0, -1, 0), Optional.of(BlockPredicate.allOf(BlockPredicate.matchesTag(new BaseBlockPosition(0, 1, 0), TagsBlock.AIR), BlockPredicate.matchesBlocks(Blocks.WATER), BlockPredicate.matchesFluids(FluidTypes.WATER), BlockPredicate.unobstructed())), WorldGenFeatureStateProvider.simple(Blocks.FROSTED_ICE), Optional.of(GameEvent.BLOCK_PLACE)), AllOfCondition.allOf(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(true))), LootItemConditionInverted.invert(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().vehicle(CriterionConditionEntity.a.entity()))))));
        Enchantments.register(var0, BINDING_CURSE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.EQUIPPABLE_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.ARMOR)).withEffect(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE));
        CriterionConditionEntity.a var6 = CriterionConditionEntity.a.entity().periodicTick(5).flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false).setOnGround(true)).moving(MovementPredicate.horizontalSpeed(CriterionConditionValue.DoubleRange.atLeast(1.0E-5f))).movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(var4, TagsBlock.SOUL_SPEED_BLOCKS)));
        AllOfCondition.a var7 = AllOfCondition.allOf(LootItemConditionInverted.invert(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().vehicle(CriterionConditionEntity.a.entity()))), AnyOfCondition.anyOf(AllOfCondition.allOf(EnchantmentActiveCheck.enchantmentActiveCheck(), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false))), AnyOfCondition.anyOf(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(var4, TagsBlock.SOUL_SPEED_BLOCKS)))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(false)).build()))), AllOfCondition.allOf(EnchantmentActiveCheck.enchantmentInactiveCheck(), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(var4, TagsBlock.SOUL_SPEED_BLOCKS))).flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false))))));
        Enchantments.register(var0, SOUL_SPEED, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 8, EquipmentSlotGroup.FEET)).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, AllOf.locationBasedEffects(new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.soul_speed"), GenericAttributes.MOVEMENT_SPEED, LevelBasedValue.perLevel(0.0405f, 0.0105f), AttributeModifier.Operation.ADD_VALUE), new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.soul_speed"), GenericAttributes.MOVEMENT_EFFICIENCY, LevelBasedValue.constant(1.0f), AttributeModifier.Operation.ADD_VALUE)), var7).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new ChangeItemDamage(LevelBasedValue.constant(1.0f)), AllOfCondition.allOf(LootItemConditionRandomChance.randomChance(EnchantmentLevelProvider.forEnchantmentLevel(LevelBasedValue.constant(0.04f))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(true)).movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(var4, TagsBlock.SOUL_SPEED_BLOCKS)))))).withEffect(EnchantmentEffectComponents.TICK, new SpawnParticlesEffect(Particles.SOUL, SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.offsetFromEntityPosition(0.1f), SpawnParticlesEffect.movementScaled(-0.2f), SpawnParticlesEffect.fixedVelocity(ConstantFloat.of(0.1f)), ConstantFloat.of(1.0f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, var6)).withEffect(EnchantmentEffectComponents.TICK, new PlaySoundEffect(SoundEffects.SOUL_ESCAPE, ConstantFloat.of(0.6f), UniformFloat.of(0.6f, 1.0f)), AllOfCondition.allOf(LootItemConditionRandomChance.randomChance(0.35f), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, var6))));
        Enchantments.register(var0, SWIFT_SNEAK, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.LEG_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 8, EquipmentSlotGroup.LEGS)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.swift_sneak"), GenericAttributes.SNEAKING_SPEED, LevelBasedValue.perLevel(0.15f), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, SHARPNESS, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.SHARP_WEAPON_ENCHANTABLE), var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(21, 11), 1, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(1.0f, 0.5f))));
        Enchantments.register(var0, SMITE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.WEAPON_ENCHANTABLE), var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(var5, TagsEntity.SENSITIVE_TO_SMITE)))));
        Enchantments.register(var0, BANE_OF_ARTHROPODS, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.WEAPON_ENCHANTABLE), var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(var5, TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS)))).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new ApplyMobEffect(HolderSet.direct(MobEffects.MOVEMENT_SLOWDOWN), LevelBasedValue.constant(1.5f), LevelBasedValue.perLevel(1.5f, 0.5f), LevelBasedValue.constant(3.0f), LevelBasedValue.constant(3.0f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(var5, TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS))).and(LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().isDirect(true)))));
        Enchantments.register(var0, KNOCKBACK, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 2, Enchantment.dynamicCost(5, 20), Enchantment.dynamicCost(55, 20), 2, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.KNOCKBACK, new AddValue(LevelBasedValue.perLevel(1.0f))));
        Enchantments.register(var0, FIRE_ASPECT, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FIRE_ASPECT_ENCHANTABLE), var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new Ignite(LevelBasedValue.perLevel(4.0f)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().isDirect(true))));
        Enchantments.register(var0, LOOTING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.EQUIPMENT_DROPS, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new AddValue(LevelBasedValue.perLevel(0.01f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.ATTACKER, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(var5, EntityTypes.PLAYER)))));
        Enchantments.register(var0, SWEEPING_EDGE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(5, 9), Enchantment.dynamicCost(20, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.sweeping_edge"), GenericAttributes.SWEEPING_DAMAGE_RATIO, new LevelBasedValue.c(LevelBasedValue.perLevel(1.0f), LevelBasedValue.perLevel(2.0f, 1.0f)), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, EFFICIENCY, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MINING_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(51, 10), 1, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.efficiency"), GenericAttributes.MINING_EFFICIENCY, new LevelBasedValue.d(1.0f), AttributeModifier.Operation.ADD_VALUE)));
        Enchantments.register(var0, SILK_TOUCH, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MINING_LOOT_ENCHANTABLE), 1, 1, Enchantment.constantCost(15), Enchantment.constantCost(65), 8, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.MINING_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.BLOCK_EXPERIENCE, new SetValue(LevelBasedValue.constant(0.0f))));
        Enchantments.register(var0, UNBREAKING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.DURABILITY_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(55, 8), 2, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.ITEM_DAMAGE, new RemoveBinomial(new LevelBasedValue.c(LevelBasedValue.perLevel(2.0f), LevelBasedValue.perLevel(10.0f, 5.0f))), LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(var3, TagsItem.ARMOR_ENCHANTABLE))).withEffect(EnchantmentEffectComponents.ITEM_DAMAGE, new RemoveBinomial(new LevelBasedValue.c(LevelBasedValue.perLevel(1.0f), LevelBasedValue.perLevel(2.0f, 1.0f))), LootItemConditionInverted.invert(LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(var3, TagsItem.ARMOR_ENCHANTABLE)))));
        Enchantments.register(var0, FORTUNE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MINING_LOOT_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.MINING_EXCLUSIVE)));
        Enchantments.register(var0, POWER, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.BOW_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(16, 10), 1, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(1.0f, 0.5f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(var5, TagsEntity.ARROWS).build())));
        Enchantments.register(var0, PUNCH, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.BOW_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(12, 20), Enchantment.dynamicCost(37, 20), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.KNOCKBACK, new AddValue(LevelBasedValue.perLevel(1.0f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(var5, TagsEntity.ARROWS).build())));
        Enchantments.register(var0, FLAME, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.BOW_ENCHANTABLE), 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.PROJECTILE_SPAWNED, new Ignite(LevelBasedValue.constant(100.0f))));
        Enchantments.register(var0, INFINITY, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.BOW_ENCHANTABLE), 1, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 8, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.BOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.AMMO_USE, new SetValue(LevelBasedValue.constant(0.0f)), LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(var3, Items.ARROW))));
        Enchantments.register(var0, LUCK_OF_THE_SEA, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FISHING_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.FISHING_LUCK_BONUS, new AddValue(LevelBasedValue.perLevel(1.0f))));
        Enchantments.register(var0, LURE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.FISHING_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.FISHING_TIME_REDUCTION, new AddValue(LevelBasedValue.perLevel(5.0f))));
        Enchantments.register(var0, LOYALTY, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(12, 7), Enchantment.constantCost(50), 2, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.TRIDENT_RETURN_ACCELERATION, new AddValue(LevelBasedValue.perLevel(1.0f))));
        Enchantments.register(var0, IMPALING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 2, 5, Enchantment.dynamicCost(1, 8), Enchantment.dynamicCost(21, 8), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5f)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(var5, TagsEntity.SENSITIVE_TO_IMPALING)).build())));
        Enchantments.register(var0, RIPTIDE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(17, 7), Enchantment.constantCost(50), 4, EquipmentSlotGroup.HAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.RIPTIDE_EXCLUSIVE)).withSpecialEffect(EnchantmentEffectComponents.TRIDENT_SPIN_ATTACK_STRENGTH, new AddValue(LevelBasedValue.perLevel(1.5f, 0.75f))).withSpecialEffect(EnchantmentEffectComponents.TRIDENT_SOUND, List.of(SoundEffects.TRIDENT_RIPTIDE_1, SoundEffects.TRIDENT_RIPTIDE_2, SoundEffects.TRIDENT_RIPTIDE_3)));
        Enchantments.register(var0, CHANNELING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, AllOf.entityEffects(new SummonEntityEffect(HolderSet.direct(EntityTypes.LIGHTNING_BOLT.builtInRegistryHolder()), false), new PlaySoundEffect(SoundEffects.TRIDENT_THUNDER, ConstantFloat.of(5.0f), ConstantFloat.of(1.0f))), AllOfCondition.allOf(LootItemConditionWeatherCheck.weather().setThundering(true), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().located(CriterionConditionLocation.a.location().setCanSeeSky(true))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(var5, EntityTypes.TRIDENT)))).withEffect(EnchantmentEffectComponents.HIT_BLOCK, AllOf.entityEffects(new SummonEntityEffect(HolderSet.direct(EntityTypes.LIGHTNING_BOLT.builtInRegistryHolder()), false), new PlaySoundEffect(SoundEffects.TRIDENT_THUNDER, ConstantFloat.of(5.0f), ConstantFloat.of(1.0f))), AllOfCondition.allOf(LootItemConditionWeatherCheck.weather().setThundering(true), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().of(var5, EntityTypes.TRIDENT)), LootItemConditionLocationCheck.checkLocation(CriterionConditionLocation.a.location().setCanSeeSky(true)), LootItemConditionBlockStateProperty.hasBlockStateProperties(Blocks.LIGHTNING_ROD))));
        Enchantments.register(var0, MULTISHOT, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.CROSSBOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.PROJECTILE_COUNT, new AddValue(LevelBasedValue.perLevel(2.0f))).withEffect(EnchantmentEffectComponents.PROJECTILE_SPREAD, new AddValue(LevelBasedValue.perLevel(10.0f))));
        Enchantments.register(var0, QUICK_CHARGE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(12, 20), Enchantment.constantCost(50), 2, EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.OFFHAND)).withSpecialEffect(EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME, new AddValue(LevelBasedValue.perLevel(-0.25f))).withSpecialEffect(EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS, List.of(new ItemCrossbow.b(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_1), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)), new ItemCrossbow.b(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_2), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)), new ItemCrossbow.b(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_3), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)))));
        Enchantments.register(var0, PIERCING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 10, 4, Enchantment.dynamicCost(1, 10), Enchantment.constantCost(50), 1, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.CROSSBOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.PROJECTILE_PIERCING, new AddValue(LevelBasedValue.perLevel(1.0f))));
        Enchantments.register(var0, DENSITY, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MACE_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.SMASH_DAMAGE_PER_FALLEN_BLOCK, new AddValue(LevelBasedValue.perLevel(0.5f))));
        Enchantments.register(var0, BREACH, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MACE_ENCHANTABLE), 2, 4, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(var2.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ARMOR_EFFECTIVENESS, new AddValue(LevelBasedValue.perLevel(-0.15f))));
        Enchantments.register(var0, WIND_BURST, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.MACE_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.ATTACKER, new ExplodeEffect(false, Optional.empty(), Optional.of(LevelBasedValue.lookup(List.of(Float.valueOf(1.2f), Float.valueOf(1.75f), Float.valueOf(2.2f)), LevelBasedValue.perLevel(1.5f, 0.35f))), var4.get(TagsBlock.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()), Vec3D.ZERO, LevelBasedValue.constant(3.5f), false, World.a.TRIGGER, Particles.GUST_EMITTER_SMALL, Particles.GUST_EMITTER_LARGE, SoundEffects.WIND_CHARGE_BURST), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false)).moving(MovementPredicate.fallDistance(CriterionConditionValue.DoubleRange.atLeast(1.5))))));
        Enchantments.register(var0, MENDING, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.DURABILITY_ENCHANTABLE), 2, 1, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 4, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.REPAIR_WITH_XP, new MultiplyValue(LevelBasedValue.constant(2.0f))));
        Enchantments.register(var0, VANISHING_CURSE, Enchantment.enchantment(Enchantment.definition(var3.getOrThrow(TagsItem.VANISHING_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP));
    }

    private static void register(BootstrapContext<Enchantment> var0, ResourceKey<Enchantment> var1, Enchantment.a var2) {
        var0.register(var1, var2.build(var1.location()));
    }

    private static ResourceKey<Enchantment> key(String var0) {
        return ResourceKey.create(Registries.ENCHANTMENT, MinecraftKey.withDefaultNamespace(var0));
    }
}

