/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.block.entity.FuelValues;

public interface SlotDisplay {
    public static final Codec<SlotDisplay> CODEC = BuiltInRegistries.SLOT_DISPLAY.byNameCodec().dispatch(SlotDisplay::type, i::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotDisplay> STREAM_CODEC = ByteBufCodecs.registry(Registries.SLOT_DISPLAY).dispatch(SlotDisplay::type, i::streamCodec);

    public <T> Stream<T> resolve(ContextMap var1, DisplayContentsFactory<T> var2);

    public i<? extends SlotDisplay> type();

    default public boolean isEnabled(FeatureFlagSet var0) {
        return true;
    }

    default public List<ItemStack> resolveForStacks(ContextMap var0) {
        return this.resolve(var0, e.INSTANCE).toList();
    }

    default public ItemStack resolveForFirstStack(ContextMap var0) {
        return this.resolve(var0, e.INSTANCE).findFirst().orElse(ItemStack.EMPTY);
    }

    public static class e
    implements DisplayContentsFactory.b<ItemStack> {
        public static final e INSTANCE = new e();

        @Override
        public ItemStack forStack(ItemStack var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object forStack(ItemStack itemStack) {
            return this.forStack(itemStack);
        }
    }

    public record j(SlotDisplay input, SlotDisplay remainder) implements SlotDisplay
    {
        public static final MapCodec<j> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("input").forGetter(j::input), (App)CODEC.fieldOf("remainder").forGetter(j::remainder)).apply((Applicative)var0, j::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, j> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, j::input, STREAM_CODEC, j::remainder, j::new);
        public static final i<j> TYPE = new i<j>(MAP_CODEC, STREAM_CODEC);

        public i<j> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            if (var1 instanceof DisplayContentsFactory.a) {
                DisplayContentsFactory.a var22 = (DisplayContentsFactory.a)var1;
                List var3 = this.remainder.resolve(var0, var1).toList();
                return this.input.resolve(var0, var1).map(var2 -> var22.addRemainder(var2, var3));
            }
            return this.input.resolve(var0, var1);
        }

        @Override
        public boolean isEnabled(FeatureFlagSet var0) {
            return this.input.isEnabled(var0) && this.remainder.isEnabled(var0);
        }
    }

    public record b(List<SlotDisplay> contents) implements SlotDisplay
    {
        public static final MapCodec<b> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.listOf().fieldOf("contents").forGetter(b::contents)).apply((Applicative)var0, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC.apply(ByteBufCodecs.list()), b::contents, b::new);
        public static final i<b> TYPE = new i<b>(MAP_CODEC, STREAM_CODEC);

        public i<b> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            return this.contents.stream().flatMap(var2 -> var2.resolve(var0, var1));
        }

        @Override
        public boolean isEnabled(FeatureFlagSet var0) {
            return this.contents.stream().allMatch(var1 -> var1.isEnabled(var0));
        }
    }

    public record h(TagKey<Item> tag) implements SlotDisplay
    {
        public static final MapCodec<h> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(h::tag)).apply((Applicative)var0, h::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, h> STREAM_CODEC = StreamCodec.composite(TagKey.streamCodec(Registries.ITEM), h::tag, h::new);
        public static final i<h> TYPE = new i<h>(MAP_CODEC, STREAM_CODEC);

        public i<h> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var02, DisplayContentsFactory<T> var12) {
            if (var12 instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b var2 = (DisplayContentsFactory.b)var12;
                HolderLookup.a var3 = var02.getOptional(SlotDisplayContext.REGISTRIES);
                if (var3 != null) {
                    return var3.lookupOrThrow(Registries.ITEM).get(this.tag).map(var1 -> var1.stream().map(var2::forStack)).stream().flatMap(var0 -> var0);
                }
            }
            return Stream.empty();
        }
    }

    public record f(ItemStack stack) implements SlotDisplay
    {
        public static final MapCodec<f> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(f::stack)).apply((Applicative)var0, f::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, f> STREAM_CODEC = StreamCodec.composite(ItemStack.STREAM_CODEC, f::stack, f::new);
        public static final i<f> TYPE = new i<f>(MAP_CODEC, STREAM_CODEC);

        public i<f> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            if (var1 instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b var2 = (DisplayContentsFactory.b)var1;
                return Stream.of(var2.forStack(this.stack));
            }
            return Stream.empty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object var0) {
            if (this == var0) return true;
            if (!(var0 instanceof f)) return false;
            f var1 = (f)var0;
            if (!ItemStack.matches(this.stack, var1.stack)) return false;
            return true;
        }

        @Override
        public boolean isEnabled(FeatureFlagSet var0) {
            return this.stack.getItem().isEnabled(var0);
        }
    }

    public record d(Holder<Item> item) implements SlotDisplay
    {
        public static final MapCodec<d> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Item.CODEC.fieldOf("item").forGetter(d::item)).apply((Applicative)var0, d::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, d> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ITEM), d::item, d::new);
        public static final i<d> TYPE = new i<d>(MAP_CODEC, STREAM_CODEC);

        public d(Item var0) {
            this(var0.builtInRegistryHolder());
        }

        public i<d> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            if (var1 instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b var2 = (DisplayContentsFactory.b)var1;
                return Stream.of(var2.forStack(this.item));
            }
            return Stream.empty();
        }

        @Override
        public boolean isEnabled(FeatureFlagSet var0) {
            return this.item.value().isEnabled(var0);
        }
    }

    public record g(SlotDisplay base, SlotDisplay material, SlotDisplay pattern) implements SlotDisplay
    {
        public static final MapCodec<g> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("base").forGetter(g::base), (App)CODEC.fieldOf("material").forGetter(g::material), (App)CODEC.fieldOf("pattern").forGetter(g::pattern)).apply((Applicative)var0, g::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, g> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, g::base, STREAM_CODEC, g::material, STREAM_CODEC, g::pattern, g::new);
        public static final i<g> TYPE = new i<g>(MAP_CODEC, STREAM_CODEC);

        public i<g> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var02, DisplayContentsFactory<T> var1) {
            if (var1 instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b var2 = (DisplayContentsFactory.b)var1;
                HolderLookup.a var3 = var02.getOptional(SlotDisplayContext.REGISTRIES);
                if (var3 != null) {
                    RandomSource var4 = RandomSource.create(System.identityHashCode(this));
                    List<ItemStack> var5 = this.base.resolveForStacks(var02);
                    if (var5.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> var6 = this.material.resolveForStacks(var02);
                    if (var6.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> var7 = this.pattern.resolveForStacks(var02);
                    if (var7.isEmpty()) {
                        return Stream.empty();
                    }
                    return Stream.generate(() -> {
                        ItemStack var5 = (ItemStack)SystemUtils.getRandom(var5, var4);
                        ItemStack var6 = (ItemStack)SystemUtils.getRandom(var6, var4);
                        ItemStack var7 = (ItemStack)SystemUtils.getRandom(var7, var4);
                        return SmithingTrimRecipe.applyTrim(var3, var5, var6, var7);
                    }).limit(256L).filter(var0 -> !var0.isEmpty()).limit(16L).map(var2::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class a
    implements SlotDisplay {
        public static final a INSTANCE = new a();
        public static final MapCodec<a> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final i<a> TYPE = new i<a>(MAP_CODEC, STREAM_CODEC);

        private a() {
        }

        public i<a> type() {
            return TYPE;
        }

        public String toString() {
            return "<any fuel>";
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            if (var1 instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b var2 = (DisplayContentsFactory.b)var1;
                FuelValues var3 = var0.getOptional(SlotDisplayContext.FUEL_VALUES);
                if (var3 != null) {
                    return var3.fuelItems().stream().map(var2::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class c
    implements SlotDisplay {
        public static final c INSTANCE = new c();
        public static final MapCodec<c> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, c> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final i<c> TYPE = new i<c>(MAP_CODEC, STREAM_CODEC);

        private c() {
        }

        public i<c> type() {
            return TYPE;
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public <T> Stream<T> resolve(ContextMap var0, DisplayContentsFactory<T> var1) {
            return Stream.empty();
        }
    }

    public record i<T extends SlotDisplay>(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
    }
}

