/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final Optional<RecipeItemStack> template;
    final Optional<RecipeItemStack> base;
    final Optional<RecipeItemStack> addition;
    final ItemStack result;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingTransformRecipe(Optional<RecipeItemStack> var0, Optional<RecipeItemStack> var1, Optional<RecipeItemStack> var2, ItemStack var3) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
        this.result = var3;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput var0, HolderLookup.a var1) {
        ItemStack var2 = var0.base().transmuteCopy(this.result.getItem(), this.result.getCount());
        var2.applyComponents(this.result.getComponentsPatch());
        return var2;
    }

    @Override
    public Optional<RecipeItemStack> templateIngredient() {
        return this.template;
    }

    @Override
    public Optional<RecipeItemStack> baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<RecipeItemStack> additionIngredient() {
        return this.addition;
    }

    @Override
    public RecipeSerializer<SmithingTransformRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(RecipeItemStack.optionalIngredientToDisplay(this.template), RecipeItemStack.optionalIngredientToDisplay(this.base), RecipeItemStack.optionalIngredientToDisplay(this.addition), new SlotDisplay.f(this.result), new SlotDisplay.d(Items.SMITHING_TABLE)));
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.optionalFieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.optionalFieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.optionalFieldOf("addition").forGetter(var0 -> var0.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(var0 -> var0.result)).apply((Applicative)var02, SmithingTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.composite(RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.template, RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.base, RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.addition, ItemStack.STREAM_CODEC, var0 -> var0.result, SmithingTransformRecipe::new);

        @Override
        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

