/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomData EMPTY = new CustomData(new NBTTagCompound());
    private static final String TYPE_TAG = "id";
    public static final Codec<CustomData> CODEC = Codec.withAlternative(NBTTagCompound.CODEC, MojangsonParser.AS_CODEC).xmap(CustomData::new, var0 -> var0.tag);
    public static final Codec<CustomData> CODEC_WITH_ID = CODEC.validate(var0 -> var0.getUnsafe().contains(TYPE_TAG, 8) ? DataResult.success((Object)var0) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(var0)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, var0 -> var0.tag);
    private final NBTTagCompound tag;

    private CustomData(NBTTagCompound var0) {
        this.tag = var0;
    }

    public static CustomData of(NBTTagCompound var0) {
        return new CustomData(var0.copy());
    }

    public static Predicate<ItemStack> itemMatcher(DataComponentType<CustomData> var0, NBTTagCompound var1) {
        return var2 -> {
            CustomData var3 = var2.getOrDefault(var0, EMPTY);
            return var3.matchedBy(var1);
        };
    }

    public boolean matchedBy(NBTTagCompound var0) {
        return GameProfileSerializer.compareNbt(var0, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> var0, ItemStack var1, Consumer<NBTTagCompound> var2) {
        CustomData var3 = var1.getOrDefault(var0, EMPTY).update(var2);
        if (var3.tag.isEmpty()) {
            var1.remove(var0);
        } else {
            var1.set(var0, var3);
        }
    }

    public static void set(DataComponentType<CustomData> var0, ItemStack var1, NBTTagCompound var2) {
        if (!var2.isEmpty()) {
            var1.set(var0, CustomData.of(var2));
        } else {
            var1.remove(var0);
        }
    }

    public CustomData update(Consumer<NBTTagCompound> var0) {
        NBTTagCompound var1 = this.tag.copy();
        var0.accept(var1);
        return new CustomData(var1);
    }

    @Nullable
    public MinecraftKey parseEntityId() {
        if (!this.tag.contains(TYPE_TAG, 8)) {
            return null;
        }
        return MinecraftKey.tryParse(this.tag.getString(TYPE_TAG));
    }

    @Nullable
    public <T> T parseEntityType(HolderLookup.a var0, ResourceKey<? extends IRegistry<T>> var1) {
        MinecraftKey var22 = this.parseEntityId();
        if (var22 == null) {
            return null;
        }
        return var0.lookup(var1).flatMap(var2 -> var2.get(ResourceKey.create(var1, var22))).map(Holder::value).orElse(null);
    }

    public void loadInto(Entity var0) {
        NBTTagCompound var1 = var0.saveWithoutId(new NBTTagCompound());
        UUID var2 = var0.getUUID();
        var1.merge(this.tag);
        var0.load(var1);
        var0.setUUID(var2);
    }

    public boolean loadInto(TileEntity var0, HolderLookup.a var1) {
        NBTTagCompound var2 = var0.saveCustomOnly(var1);
        NBTTagCompound var3 = var2.copy();
        var2.merge(this.tag);
        if (!var2.equals(var3)) {
            try {
                var0.loadCustomOnly(var2, var1);
                var0.setChanged();
                return true;
            }
            catch (Exception var4) {
                LOGGER.warn("Failed to apply custom data to block entity at {}", (Object)var0.getBlockPos(), (Object)var4);
                try {
                    var0.loadCustomOnly(var3, var1);
                }
                catch (Exception var5) {
                    LOGGER.warn("Failed to rollback block entity at {} after failure", (Object)var0.getBlockPos(), (Object)var5);
                }
            }
        }
        return false;
    }

    public <T> DataResult<CustomData> update(DynamicOps<NBTBase> var02, MapEncoder<T> var1, T var2) {
        return var1.encode(var2, var02, var02.mapBuilder()).build((Object)this.tag).map(var0 -> new CustomData((NBTTagCompound)var0));
    }

    public <T> DataResult<T> read(MapDecoder<T> var0) {
        return this.read(DynamicOpsNBT.INSTANCE, var0);
    }

    public <T> DataResult<T> read(DynamicOps<NBTBase> var0, MapDecoder<T> var1) {
        MapLike var2 = (MapLike)var0.getMap((Object)this.tag).getOrThrow();
        return var1.decode(var0, var2);
    }

    public int size() {
        return this.tag.size();
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public NBTTagCompound copyTag() {
        return this.tag.copy();
    }

    public boolean contains(String var0) {
        return this.tag.contains(var0);
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof CustomData) {
            CustomData var1 = (CustomData)var0;
            return this.tag.equals(var1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    @Deprecated
    public NBTTagCompound getUnsafe() {
        return this.tag;
    }
}

