/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public record BlockItemStateProperties(Map<String, String> properties) {
    public static final BlockItemStateProperties EMPTY = new BlockItemStateProperties(Map.of());
    public static final Codec<BlockItemStateProperties> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(BlockItemStateProperties::new, BlockItemStateProperties::properties);
    private static final StreamCodec<ByteBuf, Map<String, String>> PROPERTIES_STREAM_CODEC = ByteBufCodecs.map(Object2ObjectOpenHashMap::new, ByteBufCodecs.STRING_UTF8, ByteBufCodecs.STRING_UTF8);
    public static final StreamCodec<ByteBuf, BlockItemStateProperties> STREAM_CODEC = PROPERTIES_STREAM_CODEC.map(BlockItemStateProperties::new, BlockItemStateProperties::properties);

    public <T extends Comparable<T>> BlockItemStateProperties with(IBlockState<T> var0, T var1) {
        return new BlockItemStateProperties(SystemUtils.copyAndPut(this.properties, var0.getName(), var0.getName(var1)));
    }

    public <T extends Comparable<T>> BlockItemStateProperties with(IBlockState<T> var0, IBlockData var1) {
        return this.with(var0, var1.getValue(var0));
    }

    @Nullable
    public <T extends Comparable<T>> T get(IBlockState<T> var0) {
        String var1 = this.properties.get(var0.getName());
        if (var1 == null) {
            return null;
        }
        return (T)((Comparable)var0.getValue(var1).orElse(null));
    }

    public IBlockData apply(IBlockData var0) {
        BlockStateList<Block, IBlockData> var1 = var0.getBlock().getStateDefinition();
        for (Map.Entry<String, String> var3 : this.properties.entrySet()) {
            IBlockState<?> var4 = var1.getProperty(var3.getKey());
            if (var4 == null) continue;
            var0 = BlockItemStateProperties.updateState(var0, var4, var3.getValue());
        }
        return var0;
    }

    private static <T extends Comparable<T>> IBlockData updateState(IBlockData var0, IBlockState<T> var1, String var22) {
        return var1.getValue(var22).map(var2 -> (IBlockData)var0.setValue(var1, var2)).orElse(var0);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

