/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.World;

public record PotionContents(Optional<Holder<PotionRegistry>> potion, Optional<Integer> customColor, List<MobEffect> customEffects, Optional<String> customName) implements ConsumableListener
{
    private final List<MobEffect> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final IChatBaseComponent NO_EFFECT = IChatBaseComponent.translatable("effect.none").withStyle(EnumChatFormat.GRAY);
    public static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)PotionRegistry.CODEC.optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffect.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::customName)).apply((Applicative)var0, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, PotionRegistry.CODEC, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite(PotionRegistry.STREAM_CODEC.apply(ByteBufCodecs::optional), PotionContents::potion, ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, MobEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), PotionContents::customName, PotionContents::new);

    public PotionContents(Holder<PotionRegistry> var0) {
        this(Optional.of(var0), Optional.empty(), List.of(), Optional.empty());
    }

    public static ItemStack createItemStack(Item var0, Holder<PotionRegistry> var1) {
        ItemStack var2 = new ItemStack(var0);
        var2.set(DataComponents.POTION_CONTENTS, new PotionContents(var1));
        return var2;
    }

    public boolean is(Holder<PotionRegistry> var0) {
        return this.potion.isPresent() && this.potion.get().is(var0) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffect> getAllEffects() {
        if (this.potion.isEmpty()) {
            return this.customEffects;
        }
        if (this.customEffects.isEmpty()) {
            return this.potion.get().value().getEffects();
        }
        return Iterables.concat(this.potion.get().value().getEffects(), this.customEffects);
    }

    public void forEachEffect(Consumer<MobEffect> var0) {
        if (this.potion.isPresent()) {
            for (MobEffect var2 : this.potion.get().value().getEffects()) {
                var0.accept(new MobEffect(var2));
            }
        }
        for (MobEffect var2 : this.customEffects) {
            var0.accept(new MobEffect(var2));
        }
    }

    public PotionContents withPotion(Holder<PotionRegistry> var0) {
        return new PotionContents(Optional.of(var0), this.customColor, this.customEffects, this.customName);
    }

    public PotionContents withEffectAdded(MobEffect var0) {
        return new PotionContents(this.potion, this.customColor, SystemUtils.copyAndAdd(this.customEffects, var0), this.customName);
    }

    public int getColor() {
        return this.getColorOr(-13083194);
    }

    public int getColorOr(int var0) {
        if (this.customColor.isPresent()) {
            return this.customColor.get();
        }
        return PotionContents.getColorOptional(this.getAllEffects()).orElse(var0);
    }

    public IChatBaseComponent getName(String var0) {
        String var1 = this.customName.or(() -> this.potion.map(var0 -> ((PotionRegistry)var0.value()).name())).orElse("empty");
        return IChatBaseComponent.translatable(var0 + var1);
    }

    public static OptionalInt getColorOptional(Iterable<MobEffect> var0) {
        int var1 = 0;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (MobEffect var6 : var0) {
            if (!var6.isVisible()) continue;
            int var7 = var6.getEffect().value().getColor();
            int var8 = var6.getAmplifier() + 1;
            var1 += var8 * ARGB.red(var7);
            var2 += var8 * ARGB.green(var7);
            var3 += var8 * ARGB.blue(var7);
            var4 += var8;
        }
        if (var4 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ARGB.color(var1 / var4, var2 / var4, var3 / var4));
    }

    public boolean hasEffects() {
        if (!this.customEffects.isEmpty()) {
            return true;
        }
        return this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffect> customEffects() {
        return Lists.transform(this.customEffects, MobEffect::new);
    }

    public void addPotionTooltip(Consumer<IChatBaseComponent> var0, float var1, float var2) {
        PotionContents.addPotionTooltip(this.getAllEffects(), var0, var1, var2);
    }

    public void applyToLivingEntity(EntityLiving var0) {
        EntityHuman var32;
        World world = var0.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        EntityHuman var2 = var0 instanceof EntityHuman ? (var32 = (EntityHuman)var0) : null;
        this.forEachEffect(var3 -> {
            if (var3.getEffect().value().isInstantenous()) {
                var3.getEffect().value().applyInstantenousEffect(var1, var2, var2, var0, var3.getAmplifier(), 1.0);
            } else {
                var0.addEffect((MobEffect)var3);
            }
        });
    }

    public static void addPotionTooltip(Iterable<MobEffect> var0, Consumer<IChatBaseComponent> var12, float var22, float var3) {
        Object var8;
        ArrayList var4 = Lists.newArrayList();
        boolean var5 = true;
        for (MobEffect var7 : var0) {
            var5 = false;
            var8 = IChatBaseComponent.translatable(var7.getDescriptionId());
            Holder<MobEffectList> var9 = var7.getEffect();
            var9.value().createModifiers(var7.getAmplifier(), (var1, var2) -> var4.add(new Pair(var1, var2)));
            if (var7.getAmplifier() > 0) {
                var8 = IChatBaseComponent.translatable("potion.withAmplifier", var8, IChatBaseComponent.translatable("potion.potency." + var7.getAmplifier()));
            }
            if (!var7.endsWithin(20)) {
                var8 = IChatBaseComponent.translatable("potion.withDuration", var8, MobEffectUtil.formatDuration(var7, var22, var3));
            }
            var12.accept(((IChatMutableComponent)var8).withStyle(var9.value().getCategory().getTooltipFormatting()));
        }
        if (var5) {
            var12.accept(NO_EFFECT);
        }
        if (!var4.isEmpty()) {
            var12.accept(CommonComponents.EMPTY);
            var12.accept(IChatBaseComponent.translatable("potion.whenDrank").withStyle(EnumChatFormat.DARK_PURPLE));
            for (MobEffect var7 : var4) {
                var8 = (AttributeModifier)var7.getSecond();
                double var9 = ((AttributeModifier)var8).amount();
                double var11 = ((AttributeModifier)var8).operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || ((AttributeModifier)var8).operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? ((AttributeModifier)var8).amount() * 100.0 : ((AttributeModifier)var8).amount();
                if (var9 > 0.0) {
                    var12.accept(IChatBaseComponent.translatable("attribute.modifier.plus." + ((AttributeModifier)var8).operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var11), IChatBaseComponent.translatable(((AttributeBase)((Holder)var7.getFirst()).value()).getDescriptionId())).withStyle(EnumChatFormat.BLUE));
                    continue;
                }
                if (!(var9 < 0.0)) continue;
                var12.accept(IChatBaseComponent.translatable("attribute.modifier.take." + ((AttributeModifier)var8).operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var11 *= -1.0), IChatBaseComponent.translatable(((AttributeBase)((Holder)var7.getFirst()).value()).getDescriptionId())).withStyle(EnumChatFormat.RED));
            }
        }
    }

    @Override
    public void onConsume(World var0, EntityLiving var1, ItemStack var2, Consumable var3) {
        this.applyToLivingEntity(var1);
    }
}

