/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record ToolMaterial(TagKey<Block> incorrectBlocksForDrops, int durability, float speed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems) {
    public static final ToolMaterial WOOD = new ToolMaterial(TagsBlock.INCORRECT_FOR_WOODEN_TOOL, 59, 2.0f, 0.0f, 15, TagsItem.WOODEN_TOOL_MATERIALS);
    public static final ToolMaterial STONE = new ToolMaterial(TagsBlock.INCORRECT_FOR_STONE_TOOL, 131, 4.0f, 1.0f, 5, TagsItem.STONE_TOOL_MATERIALS);
    public static final ToolMaterial IRON = new ToolMaterial(TagsBlock.INCORRECT_FOR_IRON_TOOL, 250, 6.0f, 2.0f, 14, TagsItem.IRON_TOOL_MATERIALS);
    public static final ToolMaterial DIAMOND = new ToolMaterial(TagsBlock.INCORRECT_FOR_DIAMOND_TOOL, 1561, 8.0f, 3.0f, 10, TagsItem.DIAMOND_TOOL_MATERIALS);
    public static final ToolMaterial GOLD = new ToolMaterial(TagsBlock.INCORRECT_FOR_GOLD_TOOL, 32, 12.0f, 0.0f, 22, TagsItem.GOLD_TOOL_MATERIALS);
    public static final ToolMaterial NETHERITE = new ToolMaterial(TagsBlock.INCORRECT_FOR_NETHERITE_TOOL, 2031, 9.0f, 4.0f, 15, TagsItem.NETHERITE_TOOL_MATERIALS);

    private Item.Info applyCommonProperties(Item.Info var0) {
        return var0.durability(this.durability).repairable(this.repairItems).enchantable(this.enchantmentValue);
    }

    public Item.Info applyToolProperties(Item.Info var0, TagKey<Block> var1, float var2, float var3) {
        HolderGetter<Block> var4 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(var0).component(DataComponents.TOOL, new Tool(List.of(Tool.a.deniesDrops(var4.getOrThrow(this.incorrectBlocksForDrops)), Tool.a.minesAndDrops(var4.getOrThrow(var1), this.speed)), 1.0f, 1)).attributes(this.createToolAttributes(var2, var3));
    }

    private ItemAttributeModifiers createToolAttributes(float var0, float var1) {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, var0 + this.attackDamageBonus, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, var1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public Item.Info applySwordProperties(Item.Info var0, float var1, float var2) {
        HolderGetter<Block> var3 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(var0).component(DataComponents.TOOL, new Tool(List.of(Tool.a.minesAndDrops(HolderSet.direct(Blocks.COBWEB.builtInRegistryHolder()), 15.0f), Tool.a.overrideSpeed(var3.getOrThrow(TagsBlock.SWORD_EFFICIENT), 1.5f)), 1.0f, 2)).attributes(this.createSwordAttributes(var1, var2));
    }

    private ItemAttributeModifiers createSwordAttributes(float var0, float var1) {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, var0 + this.attackDamageBonus, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, var1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

