/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class ItemWorldMap
extends Item {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;

    public ItemWorldMap(Item.Info var0) {
        super(var0);
    }

    public static ItemStack create(World var0, int var1, int var2, byte var3, boolean var4, boolean var5) {
        ItemStack var6 = new ItemStack(Items.FILLED_MAP);
        MapId var7 = ItemWorldMap.createNewSavedData(var0, var1, var2, var3, var4, var5, var0.dimension());
        var6.set(DataComponents.MAP_ID, var7);
        return var6;
    }

    @Nullable
    public static WorldMap getSavedData(@Nullable MapId var0, World var1) {
        return var0 == null ? null : var1.getMapData(var0);
    }

    @Nullable
    public static WorldMap getSavedData(ItemStack var0, World var1) {
        MapId var2 = var0.get(DataComponents.MAP_ID);
        return ItemWorldMap.getSavedData(var2, var1);
    }

    public static MapId createNewSavedData(World var0, int var1, int var2, int var3, boolean var4, boolean var5, ResourceKey<World> var6) {
        WorldMap var7 = WorldMap.createFresh(var1, var2, (byte)var3, var4, var5, var6);
        MapId var8 = var0.getFreeMapId();
        var0.setMapData(var8, var7);
        return var8;
    }

    public void update(World var0, Entity var1, WorldMap var2) {
        if (var0.dimension() != var2.dimension || !(var1 instanceof EntityHuman)) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.centerX;
        int var5 = var2.centerZ;
        int var6 = MathHelper.floor(var1.getX() - (double)var4) / var3 + 64;
        int var7 = MathHelper.floor(var1.getZ() - (double)var5) / var3 + 64;
        int var8 = 128 / var3;
        if (var0.dimensionType().hasCeiling()) {
            var8 /= 2;
        }
        WorldMap.WorldMapHumanTracker var9 = var2.getHoldingPlayer((EntityHuman)var1);
        ++var9.step;
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var11 = new BlockPosition.MutableBlockPosition();
        boolean var12 = false;
        for (int var13 = var6 - var8 + 1; var13 < var6 + var8; ++var13) {
            if ((var13 & 0xF) != (var9.step & 0xF) && !var12) continue;
            var12 = false;
            double var14 = 0.0;
            for (int var16 = var7 - var8 - 1; var16 < var7 + var8; ++var16) {
                double var28;
                if (var13 < 0 || var16 < -1 || var13 >= 128 || var16 >= 128) continue;
                int var17 = MathHelper.square(var13 - var6) + MathHelper.square(var16 - var7);
                boolean var18 = var17 > (var8 - 2) * (var8 - 2);
                int var19 = (var4 / var3 + var13 - 64) * var3;
                int var20 = (var5 / var3 + var16 - 64) * var3;
                LinkedHashMultiset var21 = LinkedHashMultiset.create();
                Chunk var22 = var0.getChunk(SectionPosition.blockToSectionCoord(var19), SectionPosition.blockToSectionCoord(var20));
                if (var22.isEmpty()) continue;
                int var23 = 0;
                double var24 = 0.0;
                if (var0.dimensionType().hasCeiling()) {
                    var26 = var19 + var20 * 231871;
                    if (((var26 = var26 * var26 * 31287121 + var26 * 11) >> 20 & 1) == 0) {
                        var21.add((Object)Blocks.DIRT.defaultBlockState().getMapColor(var0, BlockPosition.ZERO), 10);
                    } else {
                        var21.add((Object)Blocks.STONE.defaultBlockState().getMapColor(var0, BlockPosition.ZERO), 100);
                    }
                    var24 = 100.0;
                } else {
                    for (var26 = 0; var26 < var3; ++var26) {
                        for (int var27 = 0; var27 < var3; ++var27) {
                            IBlockData var29;
                            var10.set(var19 + var26, 0, var20 + var27);
                            int var282 = var22.getHeight(HeightMap.Type.WORLD_SURFACE, var10.getX(), var10.getZ()) + 1;
                            if (var282 > var0.getMinY()) {
                                do {
                                    var10.setY(--var282);
                                } while ((var29 = var22.getBlockState(var10)).getMapColor(var0, var10) == MaterialMapColor.NONE && var282 > var0.getMinY());
                                if (var282 > var0.getMinY() && !var29.getFluidState().isEmpty()) {
                                    IBlockData var31;
                                    int var30 = var282 - 1;
                                    var11.set(var10);
                                    do {
                                        var11.setY(var30--);
                                        var31 = var22.getBlockState(var11);
                                        ++var23;
                                    } while (var30 > var0.getMinY() && !var31.getFluidState().isEmpty());
                                    var29 = this.getCorrectStateForFluidBlock(var0, var29, var10);
                                }
                            } else {
                                var29 = Blocks.BEDROCK.defaultBlockState();
                            }
                            var2.checkBanners(var0, var10.getX(), var10.getZ());
                            var24 += (double)var282 / (double)(var3 * var3);
                            var21.add((Object)var29.getMapColor(var0, var10));
                        }
                    }
                }
                MaterialMapColor var26 = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)var21), (Object)MaterialMapColor.NONE);
                MaterialMapColor.a var27 = var26 == MaterialMapColor.WATER ? ((var28 = (double)(var23 /= var3 * var3) * 0.1 + (double)(var13 + var16 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.HIGH : (var28 > 0.9 ? MaterialMapColor.a.LOW : MaterialMapColor.a.NORMAL)) : ((var28 = (var24 - var14) * 4.0 / (double)(var3 + 4) + ((double)(var13 + var16 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.HIGH : (var28 < -0.6 ? MaterialMapColor.a.LOW : MaterialMapColor.a.NORMAL));
                var14 = var24;
                if (var16 < 0 || var17 >= var8 * var8 || var18 && (var13 + var16 & 1) == 0) continue;
                var12 |= var2.updateColor(var13, var16, var26.getPackedId(var27));
            }
        }
    }

    private IBlockData getCorrectStateForFluidBlock(World var0, IBlockData var1, BlockPosition var2) {
        Fluid var3 = var1.getFluidState();
        if (!var3.isEmpty() && !var1.isFaceSturdy(var0, var2, EnumDirection.UP)) {
            return var3.createLegacyBlock();
        }
        return var1;
    }

    private static boolean isBiomeWatery(boolean[] var0, int var1, int var2) {
        return var0[var2 * 128 + var1];
    }

    public static void renderBiomePreviewMap(WorldServer var0, ItemStack var1) {
        int var11;
        int var10;
        WorldMap var2 = ItemWorldMap.getSavedData(var1, (World)var0);
        if (var2 == null) {
            return;
        }
        if (var0.dimension() != var2.dimension) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.centerX;
        int var5 = var2.centerZ;
        boolean[] var6 = new boolean[16384];
        int var7 = var4 / var3 - 64;
        int var8 = var5 / var3 - 64;
        BlockPosition.MutableBlockPosition var9 = new BlockPosition.MutableBlockPosition();
        for (var10 = 0; var10 < 128; ++var10) {
            for (var11 = 0; var11 < 128; ++var11) {
                Holder<BiomeBase> var12 = var0.getBiome(var9.set((var7 + var11) * var3, 0, (var8 + var10) * var3));
                var6[var10 * 128 + var11] = var12.is(BiomeTags.WATER_ON_MAP_OUTLINES);
            }
        }
        for (var10 = 1; var10 < 127; ++var10) {
            for (var11 = 1; var11 < 127; ++var11) {
                int var12 = 0;
                for (int var13 = -1; var13 < 2; ++var13) {
                    for (int var14 = -1; var14 < 2; ++var14) {
                        if (var13 == 0 && var14 == 0 || !ItemWorldMap.isBiomeWatery(var6, var10 + var13, var11 + var14)) continue;
                        ++var12;
                    }
                }
                MaterialMapColor.a var13 = MaterialMapColor.a.LOWEST;
                MaterialMapColor var14 = MaterialMapColor.NONE;
                if (ItemWorldMap.isBiomeWatery(var6, var10, var11)) {
                    var14 = MaterialMapColor.COLOR_ORANGE;
                    if (var12 > 7 && var11 % 2 == 0) {
                        switch ((var10 + (int)(MathHelper.sin((float)var11 + 0.0f) * 7.0f)) / 8 % 5) {
                            case 0: 
                            case 4: {
                                var13 = MaterialMapColor.a.LOW;
                                break;
                            }
                            case 1: 
                            case 3: {
                                var13 = MaterialMapColor.a.NORMAL;
                                break;
                            }
                            case 2: {
                                var13 = MaterialMapColor.a.HIGH;
                            }
                        }
                    } else if (var12 > 7) {
                        var14 = MaterialMapColor.NONE;
                    } else if (var12 > 5) {
                        var13 = MaterialMapColor.a.NORMAL;
                    } else if (var12 > 3) {
                        var13 = MaterialMapColor.a.LOW;
                    } else if (var12 > 1) {
                        var13 = MaterialMapColor.a.LOW;
                    }
                } else if (var12 > 0) {
                    var14 = MaterialMapColor.COLOR_BROWN;
                    var13 = var12 > 3 ? MaterialMapColor.a.NORMAL : MaterialMapColor.a.LOWEST;
                }
                if (var14 == MaterialMapColor.NONE) continue;
                var2.setColor(var10, var11, var14.getPackedId(var13));
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack var0, World var1, Entity var2, int var3, boolean var4) {
        if (var1.isClientSide) {
            return;
        }
        WorldMap var5 = ItemWorldMap.getSavedData(var0, var1);
        if (var5 == null) {
            return;
        }
        if (var2 instanceof EntityHuman) {
            EntityHuman var6 = (EntityHuman)var2;
            var5.tickCarriedBy(var6, var0);
        }
        if (!var5.locked && (var4 || var2 instanceof EntityHuman && ((EntityHuman)var2).getOffhandItem() == var0)) {
            this.update(var1, var2, var5);
        }
    }

    @Override
    public void onCraftedPostProcess(ItemStack var0, World var1) {
        MapPostProcessing var2 = var0.remove(DataComponents.MAP_POST_PROCESSING);
        if (var2 == null) {
            return;
        }
        switch (var2) {
            case LOCK: {
                ItemWorldMap.lockMap(var1, var0);
                break;
            }
            case SCALE: {
                ItemWorldMap.scaleMap(var0, var1);
            }
        }
    }

    private static void scaleMap(ItemStack var0, World var1) {
        WorldMap var2 = ItemWorldMap.getSavedData(var0, var1);
        if (var2 != null) {
            MapId var3 = var1.getFreeMapId();
            var1.setMapData(var3, var2.scaled());
            var0.set(DataComponents.MAP_ID, var3);
        }
    }

    public static void lockMap(World var0, ItemStack var1) {
        WorldMap var2 = ItemWorldMap.getSavedData(var1, var0);
        if (var2 != null) {
            MapId var3 = var0.getFreeMapId();
            WorldMap var4 = var2.locked();
            var0.setMapData(var3, var4);
            var1.set(DataComponents.MAP_ID, var3);
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        MapId var4 = var0.get(DataComponents.MAP_ID);
        WorldMap var5 = var4 != null ? var1.mapData(var4) : null;
        MapPostProcessing var6 = var0.get(DataComponents.MAP_POST_PROCESSING);
        if (var5 != null && (var5.locked || var6 == MapPostProcessing.LOCK)) {
            var2.add(IChatBaseComponent.translatable("filled_map.locked", var4.id()).withStyle(EnumChatFormat.GRAY));
        }
        if (var3.isAdvanced()) {
            if (var5 != null) {
                if (var6 == null) {
                    var2.add(ItemWorldMap.getTooltipForId(var4));
                }
                byte var7 = var6 == MapPostProcessing.SCALE ? (byte)1 : 0;
                int var8 = Math.min(var5.scale + var7, 4);
                var2.add(IChatBaseComponent.translatable("filled_map.scale", 1 << var8).withStyle(EnumChatFormat.GRAY));
                var2.add(IChatBaseComponent.translatable("filled_map.level", var8, 4).withStyle(EnumChatFormat.GRAY));
            } else {
                var2.add(IChatBaseComponent.translatable("filled_map.unknown").withStyle(EnumChatFormat.GRAY));
            }
        }
    }

    public static IChatBaseComponent getTooltipForId(MapId var0) {
        return IChatBaseComponent.translatable("filled_map.id", var0.id()).withStyle(EnumChatFormat.GRAY);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(TagsBlock.BANNERS)) {
            WorldMap var2;
            if (!var0.getLevel().isClientSide && (var2 = ItemWorldMap.getSavedData(var0.getItemInHand(), var0.getLevel())) != null && !var2.toggleBanner(var0.getLevel(), var0.getClickedPos())) {
                return EnumInteractionResult.FAIL;
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }
}

