/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class ItemGlassBottle
extends Item {
    public ItemGlassBottle(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(World var02, EntityHuman var1, EnumHand var2) {
        List<EntityAreaEffectCloud> var3 = var02.getEntitiesOfClass(EntityAreaEffectCloud.class, var1.getBoundingBox().inflate(2.0), var0 -> var0 != null && var0.isAlive() && var0.getOwner() instanceof EntityEnderDragon);
        ItemStack var4 = var1.getItemInHand(var2);
        if (!var3.isEmpty()) {
            EntityAreaEffectCloud var5 = var3.get(0);
            var5.setRadius(var5.getRadius() - 0.5f);
            var02.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.BOTTLE_FILL_DRAGONBREATH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            var02.gameEvent((Entity)var1, GameEvent.FLUID_PICKUP, var1.position());
            if (var1 instanceof EntityPlayer) {
                EntityPlayer var6 = (EntityPlayer)var1;
                CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(var6, var4, var5);
            }
            return EnumInteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem(var4, var1, new ItemStack(Items.DRAGON_BREATH)));
        }
        MovingObjectPositionBlock var5 = ItemGlassBottle.getPlayerPOVHitResult(var02, var1, RayTrace.FluidCollisionOption.SOURCE_ONLY);
        if (var5.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return EnumInteractionResult.PASS;
        }
        if (var5.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            BlockPosition var6 = var5.getBlockPos();
            if (!var02.mayInteract(var1, var6)) {
                return EnumInteractionResult.PASS;
            }
            if (var02.getFluidState(var6).is(TagsFluid.WATER)) {
                var02.playSound(var1, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.BOTTLE_FILL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                var02.gameEvent((Entity)var1, GameEvent.FLUID_PICKUP, var6);
                return EnumInteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem(var4, var1, PotionContents.createItemStack(Items.POTION, Potions.WATER)));
            }
        }
        return EnumInteractionResult.PASS;
    }

    protected ItemStack turnBottleIntoItem(ItemStack var0, EntityHuman var1, ItemStack var2) {
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return ItemLiquidUtil.createFilledResult(var0, var1, var2);
    }
}

