/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class ItemBucket
extends Item
implements DispensibleContainerItem {
    public final FluidType content;

    public ItemBucket(FluidType var0, Item.Info var1) {
        super(var1);
        this.content = var0;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var12, EnumHand var2) {
        ItemStack var3 = var12.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemBucket.getPlayerPOVHitResult(var0, var12, this.content == FluidTypes.EMPTY ? RayTrace.FluidCollisionOption.SOURCE_ONLY : RayTrace.FluidCollisionOption.NONE);
        if (var4.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return EnumInteractionResult.PASS;
        }
        if (var4.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            BlockPosition var9;
            BlockPosition var5 = var4.getBlockPos();
            EnumDirection var6 = var4.getDirection();
            BlockPosition var7 = var5.relative(var6);
            if (!var0.mayInteract(var12, var5) || !var12.mayUseItemAt(var7, var6, var3)) {
                return EnumInteractionResult.FAIL;
            }
            if (this.content == FluidTypes.EMPTY) {
                IFluidSource var92;
                ItemStack var10;
                IBlockData var8 = var0.getBlockState(var5);
                Block block = var8.getBlock();
                if (block instanceof IFluidSource && !(var10 = (var92 = (IFluidSource)((Object)block)).pickupBlock(var12, var0, var5, var8)).isEmpty()) {
                    var12.awardStat(StatisticList.ITEM_USED.get(this));
                    var92.getPickupSound().ifPresent(var1 -> var12.playSound((SoundEffect)var1, 1.0f, 1.0f));
                    var0.gameEvent((Entity)var12, GameEvent.FLUID_PICKUP, var5);
                    ItemStack var11 = ItemLiquidUtil.createFilledResult(var3, var12, var10);
                    if (!var0.isClientSide) {
                        CriterionTriggers.FILLED_BUCKET.trigger((EntityPlayer)var12, var10);
                    }
                    return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var11);
                }
                return EnumInteractionResult.FAIL;
            }
            IBlockData var8 = var0.getBlockState(var5);
            BlockPosition blockPosition = var9 = var8.getBlock() instanceof IFluidContainer && this.content == FluidTypes.WATER ? var5 : var7;
            if (this.emptyContents(var12, var0, var9, var4)) {
                this.checkExtraContent(var12, var0, var3, var9);
                if (var12 instanceof EntityPlayer) {
                    CriterionTriggers.PLACED_BLOCK.trigger((EntityPlayer)var12, var9, var3);
                }
                var12.awardStat(StatisticList.ITEM_USED.get(this));
                ItemStack var10 = ItemLiquidUtil.createFilledResult(var3, var12, ItemBucket.getEmptySuccessItem(var3, var12));
                return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var10);
            }
            return EnumInteractionResult.FAIL;
        }
        return EnumInteractionResult.PASS;
    }

    public static ItemStack getEmptySuccessItem(ItemStack var0, EntityHuman var1) {
        if (!var1.hasInfiniteMaterials()) {
            return new ItemStack(Items.BUCKET);
        }
        return var0;
    }

    @Override
    public void checkExtraContent(@Nullable EntityHuman var0, World var1, ItemStack var2, BlockPosition var3) {
    }

    @Override
    public boolean emptyContents(@Nullable EntityHuman var0, World var1, BlockPosition var2, @Nullable MovingObjectPositionBlock var3) {
        IFluidContainer var9;
        boolean var8;
        FluidType fluidType = this.content;
        if (!(fluidType instanceof FluidTypeFlowing)) {
            return false;
        }
        FluidTypeFlowing var4 = (FluidTypeFlowing)fluidType;
        IBlockData var5 = var1.getBlockState(var2);
        Block var6 = var5.getBlock();
        boolean var7 = var5.canBeReplaced(this.content);
        boolean bl = var8 = var5.isAir() || var7 || var6 instanceof IFluidContainer && (var9 = (IFluidContainer)((Object)var6)).canPlaceLiquid(var0, var1, var2, var5, this.content);
        if (!var8) {
            return var3 != null && this.emptyContents(var0, var1, var3.getBlockPos().relative(var3.getDirection()), null);
        }
        if (var1.dimensionType().ultraWarm() && this.content.is(TagsFluid.WATER)) {
            int var92 = var2.getX();
            int var10 = var2.getY();
            int var11 = var2.getZ();
            var1.playSound(var0, var2, SoundEffects.FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (var1.random.nextFloat() - var1.random.nextFloat()) * 0.8f);
            for (int var12 = 0; var12 < 8; ++var12) {
                var1.addParticle(Particles.LARGE_SMOKE, (double)var92 + Math.random(), (double)var10 + Math.random(), (double)var11 + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (var6 instanceof IFluidContainer) {
            var9 = (IFluidContainer)((Object)var6);
            if (this.content == FluidTypes.WATER) {
                var9.placeLiquid(var1, var2, var5, var4.getSource(false));
                this.playEmptySound(var0, var1, var2);
                return true;
            }
        }
        if (!var1.isClientSide && var7 && !var5.liquid()) {
            var1.destroyBlock(var2, true);
        }
        if (var1.setBlock(var2, this.content.defaultFluidState().createLegacyBlock(), 11) || var5.getFluidState().isSource()) {
            this.playEmptySound(var0, var1, var2);
            return true;
        }
        return false;
    }

    protected void playEmptySound(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2) {
        SoundEffect var3 = this.content.is(TagsFluid.LAVA) ? SoundEffects.BUCKET_EMPTY_LAVA : SoundEffects.BUCKET_EMPTY;
        var1.playSound(var0, var2, var3, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var1.gameEvent((Entity)var0, GameEvent.FLUID_PLACE, var2);
    }
}

