/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> instruments;

    public InstrumentItem(TagKey<Instrument> var0, Item.Info var1) {
        super(var1);
        this.instruments = var0;
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        HolderLookup.a var4 = var1.registries();
        if (var4 == null) {
            return;
        }
        Optional<Holder<Instrument>> var5 = this.getInstrument(var0, var4);
        if (var5.isPresent()) {
            IChatMutableComponent var6 = var5.get().value().description().copy();
            ChatComponentUtils.mergeStyles(var6, ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY));
            var2.add(var6);
        }
    }

    public static ItemStack create(Item var0, Holder<Instrument> var1) {
        ItemStack var2 = new ItemStack(var0);
        var2.set(DataComponents.INSTRUMENT, var1);
        return var2;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Optional<Holder<Instrument>> var4 = this.getInstrument(var3, var1.registryAccess());
        if (var4.isPresent()) {
            Instrument var5 = var4.get().value();
            var1.startUsingItem(var2);
            InstrumentItem.play(var0, var1, var5);
            var1.getCooldowns().addCooldown(var3, MathHelper.floor(var5.useDuration() * 20.0f));
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.FAIL;
    }

    @Override
    public int getUseDuration(ItemStack var02, EntityLiving var1) {
        Optional<Holder<Instrument>> var2 = this.getInstrument(var02, var1.registryAccess());
        return var2.map(var0 -> MathHelper.floor(((Instrument)var0.value()).useDuration() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack var0, HolderLookup.a var1) {
        Iterator var4;
        Holder<Instrument> var2 = var0.get(DataComponents.INSTRUMENT);
        if (var2 != null) {
            return Optional.of(var2);
        }
        Optional<HolderSet.Named<Instrument>> var3 = var1.lookupOrThrow(Registries.INSTRUMENT).get(this.instruments);
        if (var3.isPresent() && (var4 = var3.get().iterator()).hasNext()) {
            return Optional.of(var4.next());
        }
        return Optional.empty();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.TOOT_HORN;
    }

    private static void play(World var0, EntityHuman var1, Instrument var2) {
        SoundEffect var3 = var2.soundEvent().value();
        float var4 = var2.range() / 16.0f;
        var0.playSound(var1, var1, var3, SoundCategory.RECORDS, var4, 1.0f);
        var0.gameEvent(GameEvent.INSTRUMENT_PLAY, var1.position(), GameEvent.a.of(var1));
    }
}

