/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public record EitherHolder<T>(Optional<Holder<T>> holder, ResourceKey<T> key) {
    public EitherHolder(Holder<T> var0) {
        this(Optional.of(var0), var0.unwrapKey().orElseThrow());
    }

    public EitherHolder(ResourceKey<T> var0) {
        this(Optional.empty(), var0);
    }

    public static <T> Codec<EitherHolder<T>> codec(ResourceKey<IRegistry<T>> var02, Codec<Holder<T>> var1) {
        return Codec.either(var1, (Codec)ResourceKey.codec(var02).comapFlatMap(var0 -> DataResult.error(() -> "Cannot parse as key without registry"), Function.identity())).xmap(EitherHolder::fromEither, EitherHolder::asEither);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, EitherHolder<T>> streamCodec(ResourceKey<IRegistry<T>> var0, StreamCodec<RegistryFriendlyByteBuf, Holder<T>> var1) {
        return StreamCodec.composite(ByteBufCodecs.either(var1, ResourceKey.streamCodec(var0)), EitherHolder::asEither, EitherHolder::fromEither);
    }

    public Either<Holder<T>, ResourceKey<T>> asEither() {
        return this.holder.map(Either::left).orElseGet(() -> Either.right(this.key));
    }

    public static <T> EitherHolder<T> fromEither(Either<Holder<T>, ResourceKey<T>> var0) {
        return (EitherHolder)var0.map(EitherHolder::new, EitherHolder::new);
    }

    public Optional<T> unwrap(IRegistry<T> var0) {
        return this.holder.map(Holder::value).or(() -> var0.getOptional(this.key));
    }

    public Optional<Holder<T>> unwrap(HolderLookup.a var0) {
        return this.holder.or(() -> var0.lookupOrThrow(this.key.registryKey()).get(this.key));
    }
}

