/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int MAX_SHOWN_GRID_ITEMS_X = 4;
    public static final int MAX_SHOWN_GRID_ITEMS_Y = 3;
    public static final int MAX_SHOWN_GRID_ITEMS = 12;
    public static final int OVERFLOWING_MAX_SHOWN_GRID_ITEMS = 11;
    private static final int FULL_BAR_COLOR = ARGB.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int BAR_COLOR = ARGB.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int TICKS_AFTER_FIRST_THROW = 10;
    private static final int TICKS_BETWEEN_THROWS = 2;
    private static final int TICKS_MAX_THROW_DURATION = 200;

    public BundleItem(Item.Info var0) {
        super(var0);
    }

    public static float getFullnessDisplay(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.weight().floatValue();
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        BundleContents var4 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var4 == null) {
            return false;
        }
        ItemStack var5 = var1.getItem();
        BundleContents.a var6 = new BundleContents.a(var4);
        if (var2 == ClickAction.PRIMARY && !var5.isEmpty()) {
            if (var6.tryTransfer(var1, var3) > 0) {
                BundleItem.playInsertSound(var3);
            } else {
                BundleItem.playInsertFailSound(var3);
            }
            var0.set(DataComponents.BUNDLE_CONTENTS, var6.toImmutable());
            this.broadcastChangesOnContainerMenu(var3);
            return true;
        }
        if (var2 == ClickAction.SECONDARY && var5.isEmpty()) {
            ItemStack var7 = var6.removeOne();
            if (var7 != null) {
                ItemStack var8 = var1.safeInsert(var7);
                if (var8.getCount() > 0) {
                    var6.tryInsert(var8);
                } else {
                    BundleItem.playRemoveOneSound(var3);
                }
            }
            var0.set(DataComponents.BUNDLE_CONTENTS, var6.toImmutable());
            this.broadcastChangesOnContainerMenu(var3);
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        if (var3 == ClickAction.PRIMARY && var1.isEmpty()) {
            BundleItem.toggleSelectedItem(var0, -1);
            return false;
        }
        BundleContents var6 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var6 == null) {
            return false;
        }
        BundleContents.a var7 = new BundleContents.a(var6);
        if (var3 == ClickAction.PRIMARY && !var1.isEmpty()) {
            if (var2.allowModification(var4) && var7.tryInsert(var1) > 0) {
                BundleItem.playInsertSound(var4);
            } else {
                BundleItem.playInsertFailSound(var4);
            }
            var0.set(DataComponents.BUNDLE_CONTENTS, var7.toImmutable());
            this.broadcastChangesOnContainerMenu(var4);
            return true;
        }
        if (var3 == ClickAction.SECONDARY && var1.isEmpty()) {
            ItemStack var8;
            if (var2.allowModification(var4) && (var8 = var7.removeOne()) != null) {
                BundleItem.playRemoveOneSound(var4);
                var5.set(var8);
            }
            var0.set(DataComponents.BUNDLE_CONTENTS, var7.toImmutable());
            this.broadcastChangesOnContainerMenu(var4);
            return true;
        }
        BundleItem.toggleSelectedItem(var0, -1);
        return false;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        var1.startUsingItem(var2);
        return EnumInteractionResult.SUCCESS;
    }

    private void dropContent(World var0, EntityHuman var1, ItemStack var2) {
        if (this.dropContent(var2, var1)) {
            BundleItem.playDropContentsSound(var0, var1);
            var1.awardStat(StatisticList.ITEM_USED.get(this));
        }
    }

    @Override
    public boolean isBarVisible(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + MathHelper.mulAndTruncate(var1.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.weight().compareTo(Fraction.ONE) >= 0 ? FULL_BAR_COLOR : BAR_COLOR;
    }

    public static void toggleSelectedItem(ItemStack var0, int var1) {
        BundleContents var2 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var2 == null) {
            return;
        }
        BundleContents.a var3 = new BundleContents.a(var2);
        var3.toggleSelectedItem(var1);
        var0.set(DataComponents.BUNDLE_CONTENTS, var3.toImmutable());
    }

    public static boolean hasSelectedItem(ItemStack var0) {
        BundleContents var1 = var0.get(DataComponents.BUNDLE_CONTENTS);
        return var1 != null && var1.getSelectedItem() != -1;
    }

    public static int getSelectedItem(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack var0) {
        BundleContents var1 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var1 != null && var1.getSelectedItem() != -1) {
            return var1.getItemUnsafe(var1.getSelectedItem());
        }
        return ItemStack.EMPTY;
    }

    public static int getNumberOfItemsToShow(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.getNumberOfItemsToShow();
    }

    private boolean dropContent(ItemStack var0, EntityHuman var1) {
        BundleContents var2 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var2 == null || var2.isEmpty()) {
            return false;
        }
        Optional<ItemStack> var3 = BundleItem.removeOneItemFromBundle(var0, var1, var2);
        if (var3.isPresent()) {
            var1.drop(var3.get(), true);
            return true;
        }
        return false;
    }

    private static Optional<ItemStack> removeOneItemFromBundle(ItemStack var0, EntityHuman var1, BundleContents var2) {
        BundleContents.a var3 = new BundleContents.a(var2);
        ItemStack var4 = var3.removeOne();
        if (var4 != null) {
            BundleItem.playRemoveOneSound(var1);
            var0.set(DataComponents.BUNDLE_CONTENTS, var3.toImmutable());
            return Optional.of(var4);
        }
        return Optional.empty();
    }

    @Override
    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
        if (var1 instanceof EntityHuman) {
            boolean var6;
            EntityHuman var4 = (EntityHuman)var1;
            int var5 = this.getUseDuration(var2, var1);
            boolean bl = var6 = var3 == var5;
            if (var6 || var3 < var5 - 10 && var3 % 2 == 0) {
                this.dropContent(var0, var4, var2);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 200;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.BUNDLE;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        if (var0.has(DataComponents.HIDE_TOOLTIP) || var0.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable(var0.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    public void onDestroyed(EntityItem var0) {
        BundleContents var1 = var0.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (var1 == null) {
            return;
        }
        var0.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemLiquidUtil.onContainerDestroyed(var0, var1.itemsCopy());
    }

    public static List<BundleItem> getAllBundleItemColors() {
        return Stream.of(Items.BUNDLE, Items.WHITE_BUNDLE, Items.ORANGE_BUNDLE, Items.MAGENTA_BUNDLE, Items.LIGHT_BLUE_BUNDLE, Items.YELLOW_BUNDLE, Items.LIME_BUNDLE, Items.PINK_BUNDLE, Items.GRAY_BUNDLE, Items.LIGHT_GRAY_BUNDLE, Items.CYAN_BUNDLE, Items.BLACK_BUNDLE, Items.BROWN_BUNDLE, Items.GREEN_BUNDLE, Items.RED_BUNDLE, Items.BLUE_BUNDLE, Items.PURPLE_BUNDLE).map(var0 -> (BundleItem)var0).toList();
    }

    public static Item getByColor(EnumColor var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumColor.WHITE -> Items.WHITE_BUNDLE;
            case EnumColor.ORANGE -> Items.ORANGE_BUNDLE;
            case EnumColor.MAGENTA -> Items.MAGENTA_BUNDLE;
            case EnumColor.LIGHT_BLUE -> Items.LIGHT_BLUE_BUNDLE;
            case EnumColor.YELLOW -> Items.YELLOW_BUNDLE;
            case EnumColor.LIME -> Items.LIME_BUNDLE;
            case EnumColor.PINK -> Items.PINK_BUNDLE;
            case EnumColor.GRAY -> Items.GRAY_BUNDLE;
            case EnumColor.LIGHT_GRAY -> Items.LIGHT_GRAY_BUNDLE;
            case EnumColor.CYAN -> Items.CYAN_BUNDLE;
            case EnumColor.BLUE -> Items.BLUE_BUNDLE;
            case EnumColor.BROWN -> Items.BROWN_BUNDLE;
            case EnumColor.GREEN -> Items.GREEN_BUNDLE;
            case EnumColor.RED -> Items.RED_BUNDLE;
            case EnumColor.BLACK -> Items.BLACK_BUNDLE;
            case EnumColor.PURPLE -> Items.PURPLE_BUNDLE;
        };
    }

    private static void playRemoveOneSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_INSERT, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(World var0, Entity var1) {
        var0.playSound(null, var1.blockPosition(), SoundEffects.BUNDLE_DROP_CONTENTS, SoundCategory.PLAYERS, 0.8f, 0.8f + var1.level().getRandom().nextFloat() * 0.4f);
    }

    private void broadcastChangesOnContainerMenu(EntityHuman var0) {
        Container var1 = var0.containerMenu;
        if (var1 != null) {
            var1.slotsChanged(var0.getInventory());
        }
    }
}

