/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;

public class SlotResult
extends Slot {
    private final InventoryCrafting craftSlots;
    private final EntityHuman player;
    private int removeCount;

    public SlotResult(EntityHuman var0, InventoryCrafting var1, IInventory var2, int var3, int var4, int var5) {
        super(var2, var3, var4, var5);
        this.player = var0;
        this.craftSlots = var1;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return false;
    }

    @Override
    public ItemStack remove(int var0) {
        if (this.hasItem()) {
            this.removeCount += Math.min(var0, this.getItem().getCount());
        }
        return super.remove(var0);
    }

    @Override
    protected void onQuickCraft(ItemStack var0, int var1) {
        this.removeCount += var1;
        this.checkTakeAchievements(var0);
    }

    @Override
    protected void onSwapCraft(int var0) {
        this.removeCount += var0;
    }

    @Override
    protected void checkTakeAchievements(ItemStack var0) {
        IInventory iInventory;
        if (this.removeCount > 0) {
            var0.onCraftedBy(this.player.level(), this.player, this.removeCount);
        }
        if ((iInventory = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder var1 = (RecipeCraftingHolder)((Object)iInventory);
            var1.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    private static NonNullList<ItemStack> copyAllInputItems(CraftingInput var0) {
        NonNullList<ItemStack> var1 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            var1.set(var2, var0.getItem(var2));
        }
        return var1;
    }

    private NonNullList<ItemStack> getRemainingItems(CraftingInput var0, World var12) {
        if (var12 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var12;
            return var2.recipeAccess().getRecipeFor(Recipes.CRAFTING, var0, var2).map(var1 -> ((RecipeCrafting)var1.value()).getRemainingItems(var0)).orElseGet(() -> SlotResult.copyAllInputItems(var0));
        }
        return RecipeCrafting.defaultCraftingReminder(var0);
    }

    @Override
    public void onTake(EntityHuman var0, ItemStack var1) {
        this.checkTakeAchievements(var1);
        CraftingInput.a var2 = this.craftSlots.asPositionedCraftInput();
        CraftingInput var3 = var2.input();
        int var4 = var2.left();
        int var5 = var2.top();
        NonNullList<ItemStack> var6 = this.getRemainingItems(var3, var0.level());
        for (int var7 = 0; var7 < var3.height(); ++var7) {
            for (int var8 = 0; var8 < var3.width(); ++var8) {
                int var9 = var8 + var4 + (var7 + var5) * this.craftSlots.getWidth();
                ItemStack var10 = this.craftSlots.getItem(var9);
                ItemStack var11 = var6.get(var8 + var7 * var3.width());
                if (!var10.isEmpty()) {
                    this.craftSlots.removeItem(var9, 1);
                    var10 = this.craftSlots.getItem(var9);
                }
                if (var11.isEmpty()) continue;
                if (var10.isEmpty()) {
                    this.craftSlots.setItem(var9, var11);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents(var10, var11)) {
                    var11.grow(var10.getCount());
                    this.craftSlots.setItem(var9, var11);
                    continue;
                }
                if (this.player.getInventory().add(var11)) continue;
                this.player.drop(var11, false);
            }
        }
    }

    @Override
    public boolean isFake() {
        return true;
    }
}

