/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class ContainerStonecutter
extends Container {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerAccess access;
    final ContainerProperty selectedRecipeIndex = ContainerProperty.standalone();
    private final World level;
    private SelectableRecipe.b<RecipeStonecutting> recipesForInput = SelectableRecipe.b.empty();
    private ItemStack input = ItemStack.EMPTY;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final IInventory container = new InventorySubcontainer(1){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerStonecutter.this.slotsChanged(this);
            ContainerStonecutter.this.slotUpdateListener.run();
        }
    };
    final InventoryCraftResult resultContainer = new InventoryCraftResult();

    public ContainerStonecutter(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerStonecutter(int var0, PlayerInventory var1, final ContainerAccess var2) {
        super(Containers.STONECUTTER, var0);
        this.access = var2;
        this.level = var1.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot(this.resultContainer, 1, 143, 33){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public void onTake(EntityHuman var02, ItemStack var12) {
                var12.onCraftedBy(var02.level(), var02, var12.getCount());
                ContainerStonecutter.this.resultContainer.awardUsedRecipes(var02, this.getRelevantItems());
                ItemStack var22 = ContainerStonecutter.this.inputSlot.remove(1);
                if (!var22.isEmpty()) {
                    ContainerStonecutter.this.setupResultSlot(ContainerStonecutter.this.selectedRecipeIndex.get());
                }
                var2.execute((var0, var1) -> {
                    long var22 = var0.getGameTime();
                    if (ContainerStonecutter.this.lastSoundTime != var22) {
                        var0.playSound(null, (BlockPosition)var1, SoundEffects.UI_STONECUTTER_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerStonecutter.this.lastSoundTime = var22;
                    }
                });
                super.onTake(var02, var12);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(ContainerStonecutter.this.inputSlot.getItem());
            }
        });
        this.addStandardInventorySlots(var1, 8, 84);
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public SelectableRecipe.b<RecipeStonecutting> getVisibleRecipes() {
        return this.recipesForInput;
    }

    public int getNumberOfVisibleRecipes() {
        return this.recipesForInput.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipesForInput.isEmpty();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerStonecutter.stillValid(this.access, var0, Blocks.STONECUTTER);
    }

    @Override
    public boolean clickMenuButton(EntityHuman var0, int var1) {
        if (this.selectedRecipeIndex.get() == var1) {
            return false;
        }
        if (this.isValidRecipeIndex(var1)) {
            this.selectedRecipeIndex.set(var1);
            this.setupResultSlot(var1);
        }
        return true;
    }

    private boolean isValidRecipeIndex(int var0) {
        return var0 >= 0 && var0 < this.recipesForInput.size();
    }

    @Override
    public void slotsChanged(IInventory var0) {
        ItemStack var1 = this.inputSlot.getItem();
        if (!var1.is(this.input.getItem())) {
            this.input = var1.copy();
            this.setupRecipeList(var1);
        }
    }

    private void setupRecipeList(ItemStack var0) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        this.recipesForInput = !var0.isEmpty() ? this.level.recipeAccess().stonecutterRecipes().selectByInput(var0) : SelectableRecipe.b.empty();
    }

    void setupResultSlot(int var02) {
        Optional<RecipeHolder<Object>> var1;
        if (!this.recipesForInput.isEmpty() && this.isValidRecipeIndex(var02)) {
            SelectableRecipe.a<RecipeStonecutting> var2 = this.recipesForInput.entries().get(var02);
            var1 = var2.recipe().recipe();
        } else {
            var1 = Optional.empty();
        }
        var1.ifPresentOrElse(var0 -> {
            this.resultContainer.setRecipeUsed((RecipeHolder<?>)var0);
            this.resultSlot.set(((RecipeStonecutting)var0.value()).assemble(new SingleRecipeInput(this.container.getItem(0)), (HolderLookup.a)this.level.registryAccess()));
        }, () -> {
            this.resultSlot.set(ItemStack.EMPTY);
            this.resultContainer.setRecipeUsed(null);
        });
        this.broadcastChanges();
    }

    @Override
    public Containers<?> getType() {
        return Containers.STONECUTTER;
    }

    public void registerUpdateListener(Runnable var0) {
        this.slotUpdateListener = var0;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultContainer && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            Item var5 = var4.getItem();
            var2 = var4.copy();
            if (var1 == 1) {
                var5.onCraftedBy(var4, var0.level(), var0);
                if (!this.moveItemStackTo(var4, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 0 ? !this.moveItemStackTo(var4, 2, 38, false) : (this.level.recipeAccess().stonecutterRecipes().acceptsInput(var4) ? !this.moveItemStackTo(var4, 0, 1, false) : (var1 >= 2 && var1 < 29 ? !this.moveItemStackTo(var4, 29, 38, false) : var1 >= 29 && var1 < 38 && !this.moveItemStackTo(var4, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            }
            var3.setChanged();
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
            if (var1 == 1) {
                var0.drop(var4, false);
            }
            this.broadcastChanges();
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.container));
    }
}

