/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;

class ArmorSlot
extends Slot {
    private final EntityLiving owner;
    private final EnumItemSlot slot;
    @Nullable
    private final MinecraftKey emptyIcon;

    public ArmorSlot(IInventory var0, EntityLiving var1, EnumItemSlot var2, int var3, int var4, int var5, @Nullable MinecraftKey var6) {
        super(var0, var3, var4, var5);
        this.owner = var1;
        this.slot = var2;
        this.emptyIcon = var6;
    }

    @Override
    public void setByPlayer(ItemStack var0, ItemStack var1) {
        this.owner.onEquipItem(this.slot, var1, var0);
        super.setByPlayer(var0, var1);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return this.slot == this.owner.getEquipmentSlotForItem(var0);
    }

    @Override
    public boolean mayPickup(EntityHuman var0) {
        ItemStack var1 = this.getItem();
        if (!var1.isEmpty() && !var0.isCreative() && EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        return super.mayPickup(var0);
    }

    @Override
    @Nullable
    public MinecraftKey getNoItemIcon() {
        return this.emptyIcon;
    }
}

