/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class MinecartBehavior {
    protected final EntityMinecartAbstract minecart;

    protected MinecartBehavior(EntityMinecartAbstract var0) {
        this.minecart = var0;
    }

    public void cancelLerp() {
    }

    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8) {
        this.setPos(var0, var2, var4);
        this.setYRot(var6 % 360.0f);
        this.setXRot(var7 % 360.0f);
    }

    public double lerpTargetX() {
        return this.getX();
    }

    public double lerpTargetY() {
        return this.getY();
    }

    public double lerpTargetZ() {
        return this.getZ();
    }

    public float lerpTargetXRot() {
        return this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.getYRot();
    }

    public void lerpMotion(double var0, double var2, double var4) {
        this.setDeltaMovement(var0, var2, var4);
    }

    public abstract void tick();

    public World level() {
        return this.minecart.level();
    }

    public abstract void moveAlongTrack(WorldServer var1);

    public abstract double stepAlongTrack(BlockPosition var1, BlockPropertyTrackPosition var2, double var3);

    public abstract boolean pushAndPickupEntities();

    public Vec3D getDeltaMovement() {
        return this.minecart.getDeltaMovement();
    }

    public void setDeltaMovement(Vec3D var0) {
        this.minecart.setDeltaMovement(var0);
    }

    public void setDeltaMovement(double var0, double var2, double var4) {
        this.minecart.setDeltaMovement(var0, var2, var4);
    }

    public Vec3D position() {
        return this.minecart.position();
    }

    public double getX() {
        return this.minecart.getX();
    }

    public double getY() {
        return this.minecart.getY();
    }

    public double getZ() {
        return this.minecart.getZ();
    }

    public void setPos(Vec3D var0) {
        this.minecart.setPos(var0);
    }

    public void setPos(double var0, double var2, double var4) {
        this.minecart.setPos(var0, var2, var4);
    }

    public float getXRot() {
        return this.minecart.getXRot();
    }

    public void setXRot(float var0) {
        this.minecart.setXRot(var0);
    }

    public float getYRot() {
        return this.minecart.getYRot();
    }

    public void setYRot(float var0) {
        this.minecart.setYRot(var0);
    }

    public EnumDirection getMotionDirection() {
        return this.minecart.getDirection();
    }

    public Vec3D getKnownMovement(Vec3D var0) {
        return var0;
    }

    public abstract double getMaxSpeed(WorldServer var1);

    public abstract double getSlowdownFactor();
}

