/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityMinecartMobSpawner
extends EntityMinecartAbstract {
    private final MobSpawnerAbstract spawner = new MobSpawnerAbstract(){

        @Override
        public void broadcastEvent(World var0, BlockPosition var1, int var2) {
            var0.broadcastEntityEvent(EntityMinecartMobSpawner.this, (byte)var2);
        }
    };
    private final Runnable ticker;

    public EntityMinecartMobSpawner(EntityTypes<? extends EntityMinecartMobSpawner> var0, World var1) {
        super(var0, var1);
        this.ticker = this.createTicker(var1);
    }

    @Override
    protected Item getDropItem() {
        return Items.MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.MINECART);
    }

    private Runnable createTicker(World var0) {
        return var0 instanceof WorldServer ? () -> this.spawner.serverTick((WorldServer)var0, this.blockPosition()) : () -> this.spawner.clientTick(var0, this.blockPosition());
    }

    @Override
    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.SPAWNER.defaultBlockState();
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.spawner.load(this.level(), this.blockPosition(), var0);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        this.spawner.save(var0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        this.spawner.onEventTriggered(this.level(), var0);
    }

    @Override
    public void tick() {
        super.tick();
        this.ticker.run();
    }

    public MobSpawnerAbstract getSpawner() {
        return this.spawner;
    }
}

