/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = EntityPositionTypes.getPlacementType(EntityTypes.RAVAGER);
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final IChatBaseComponent OMINOUS_BANNER_PATTERN_NAME = IChatBaseComponent.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final IChatBaseComponent RAID_NAME_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid");
    private static final IChatBaseComponent RAID_BAR_VICTORY_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent RAID_BAR_DEFEAT_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, EntityRaider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPosition center;
    private final WorldServer level;
    private boolean started;
    private final int id;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final BossBattleServer raidEvent = new BossBattleServer(RAID_NAME_COMPONENT, BossBattle.BarColor.RED, BossBattle.BarStyle.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    public final int numGroups;
    private Status status;
    private int celebrationTicks;
    private Optional<BlockPosition> waveSpawnPos = Optional.empty();

    public Raid(int var0, WorldServer var1, BlockPosition var2) {
        this.id = var0;
        this.level = var1;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = var2;
        this.numGroups = this.getNumGroups(var1.getDifficulty());
        this.status = Status.ONGOING;
    }

    public Raid(WorldServer var0, NBTTagCompound var1) {
        this.level = var0;
        this.id = var1.getInt("Id");
        this.started = var1.getBoolean("Started");
        this.active = var1.getBoolean("Active");
        this.ticksActive = var1.getLong("TicksActive");
        this.raidOmenLevel = var1.getInt("BadOmenLevel");
        this.groupsSpawned = var1.getInt("GroupsSpawned");
        this.raidCooldownTicks = var1.getInt("PreRaidTicks");
        this.postRaidTicks = var1.getInt("PostRaidTicks");
        this.totalHealth = var1.getFloat("TotalHealth");
        this.center = new BlockPosition(var1.getInt("CX"), var1.getInt("CY"), var1.getInt("CZ"));
        this.numGroups = var1.getInt("NumGroups");
        this.status = Status.getByName(var1.getString("Status"));
        this.heroesOfTheVillage.clear();
        if (var1.contains("HeroesOfTheVillage", 9)) {
            NBTTagList var2 = var1.getList("HeroesOfTheVillage", 11);
            for (NBTBase var4 : var2) {
                this.heroesOfTheVillage.add(GameProfileSerializer.loadUUID(var4));
            }
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isVictory() {
        return this.status == Status.VICTORY;
    }

    public boolean isLoss() {
        return this.status == Status.LOSS;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<EntityRaider> getAllRaiders() {
        HashSet var0 = Sets.newHashSet();
        for (Set<EntityRaider> var2 : this.groupRaiderMap.values()) {
            var0.addAll(var2);
        }
        return var0;
    }

    public World getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<EntityPlayer> validPlayer() {
        return var0 -> {
            BlockPosition var1 = var0.blockPosition();
            return var0.isAlive() && this.level.getRaidAt(var1) == this;
        };
    }

    private void updatePlayers() {
        HashSet var0 = Sets.newHashSet(this.raidEvent.getPlayers());
        List<EntityPlayer> var1 = this.level.getPlayers(this.validPlayer());
        for (EntityPlayer var3 : var1) {
            if (var0.contains(var3)) continue;
            this.raidEvent.addPlayer(var3);
        }
        for (EntityPlayer var3 : var0) {
            if (var1.contains(var3)) continue;
            this.raidEvent.removePlayer(var3);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int var0) {
        this.raidOmenLevel = var0;
    }

    public boolean absorbRaidOmen(EntityPlayer var0) {
        MobEffect var1 = var0.getEffect(MobEffects.RAID_OMEN);
        if (var1 == null) {
            return false;
        }
        this.raidOmenLevel += var1.getAmplifier() + 1;
        this.raidOmenLevel = MathHelper.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            var0.awardStat(StatisticList.RAID_TRIGGER);
            CriterionTriggers.RAID_OMEN.trigger(var0);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = Status.STOPPED;
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        if (this.status == Status.ONGOING) {
            int var3;
            boolean var2;
            boolean var0 = this.active;
            this.active = this.level.hasChunkAt(this.center);
            if (this.level.getDifficulty() == EnumDifficulty.PEACEFUL) {
                this.stop();
                return;
            }
            if (var0 != this.active) {
                this.raidEvent.setVisible(this.active);
            }
            if (!this.active) {
                return;
            }
            if (!this.level.isVillage(this.center)) {
                this.moveRaidCenterToNearbyVillageSection();
            }
            if (!this.level.isVillage(this.center)) {
                if (this.groupsSpawned > 0) {
                    this.status = Status.LOSS;
                } else {
                    this.stop();
                }
            }
            ++this.ticksActive;
            if (this.ticksActive >= 48000L) {
                this.stop();
                return;
            }
            int var1 = this.getTotalRaidersAlive();
            if (var1 == 0 && this.hasMoreWaves()) {
                if (this.raidCooldownTicks > 0) {
                    var2 = this.waveSpawnPos.isPresent();
                    int n2 = var3 = !var2 && this.raidCooldownTicks % 5 == 0 ? 1 : 0;
                    if (var2 && !this.level.isPositionEntityTicking(this.waveSpawnPos.get())) {
                        var3 = 1;
                    }
                    if (var3 != 0) {
                        this.waveSpawnPos = this.getValidSpawnPos();
                    }
                    if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                        this.updatePlayers();
                    }
                    --this.raidCooldownTicks;
                    this.raidEvent.setProgress(MathHelper.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                    this.raidCooldownTicks = 300;
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                    return;
                }
            }
            if (this.ticksActive % 20L == 0L) {
                this.updatePlayers();
                this.updateRaiders();
                if (var1 > 0) {
                    if (var1 <= 2) {
                        this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(IChatBaseComponent.translatable(RAIDERS_REMAINING, var1)));
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                } else {
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                }
            }
            var2 = false;
            var3 = 0;
            while (this.shouldSpawnGroup()) {
                BlockPosition var4 = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(20));
                if (var4 != null) {
                    this.started = true;
                    this.spawnGroup(var4);
                    if (!var2) {
                        this.playSound(var4);
                        var2 = true;
                    }
                } else {
                    ++var3;
                }
                if (var3 <= 5) continue;
                this.stop();
                break;
            }
            if (this.isStarted() && !this.hasMoreWaves() && var1 == 0) {
                if (this.postRaidTicks < 40) {
                    ++this.postRaidTicks;
                } else {
                    this.status = Status.VICTORY;
                    for (UUID var5 : this.heroesOfTheVillage) {
                        Entity var6 = this.level.getEntity(var5);
                        if (!(var6 instanceof EntityLiving)) continue;
                        EntityLiving var7 = (EntityLiving)var6;
                        if (var6.isSpectator()) continue;
                        var7.addEffect(new MobEffect(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                        if (!(var7 instanceof EntityPlayer)) continue;
                        EntityPlayer var8 = (EntityPlayer)var7;
                        var8.awardStat(StatisticList.RAID_WIN);
                        CriterionTriggers.RAID_WIN.trigger(var8);
                    }
                }
            }
            this.setDirty();
        } else if (this.isOver()) {
            ++this.celebrationTicks;
            if (this.celebrationTicks >= 600) {
                this.stop();
                return;
            }
            if (this.celebrationTicks % 20 == 0) {
                this.updatePlayers();
                this.raidEvent.setVisible(true);
                if (this.isVictory()) {
                    this.raidEvent.setProgress(0.0f);
                    this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                } else {
                    this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream<SectionPosition> var02 = SectionPosition.cube(SectionPosition.of(this.center), 2);
        var02.filter(this.level::isVillage).map(SectionPosition::center).min(Comparator.comparingDouble(var0 -> var0.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPosition> getValidSpawnPos() {
        BlockPosition var0 = this.findRandomSpawnPos(8);
        if (var0 != null) {
            return Optional.of(var0);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        if (this.hasBonusWave()) {
            return !this.hasSpawnedBonusWave();
        }
        return !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<EntityRaider>> var0 = this.groupRaiderMap.values().iterator();
        HashSet var1 = Sets.newHashSet();
        while (var0.hasNext()) {
            Set<EntityRaider> var2 = var0.next();
            for (EntityRaider var4 : var2) {
                BlockPosition var5 = var4.blockPosition();
                if (var4.isRemoved() || var4.level().dimension() != this.level.dimension() || this.center.distSqr(var5) >= 12544.0) {
                    var1.add(var4);
                    continue;
                }
                if (var4.tickCount <= 600) continue;
                if (this.level.getEntity(var4.getUUID()) == null) {
                    var1.add(var4);
                }
                if (!this.level.isVillage(var5) && var4.getNoActionTime() > 2400) {
                    var4.setTicksOutsideRaid(var4.getTicksOutsideRaid() + 1);
                }
                if (var4.getTicksOutsideRaid() < 30) continue;
                var1.add(var4);
            }
        }
        for (EntityRaider var3 : var1) {
            this.removeFromRaid(var3, true);
            if (!var3.isPatrolLeader()) continue;
            this.removeLeader(var3.getWave());
        }
    }

    private void playSound(BlockPosition var0) {
        float var1 = 13.0f;
        int var2 = 64;
        Collection<EntityPlayer> var3 = this.raidEvent.getPlayers();
        long var4 = this.random.nextLong();
        for (EntityPlayer var7 : this.level.players()) {
            Vec3D var8 = var7.position();
            Vec3D var9 = Vec3D.atCenterOf(var0);
            double var10 = Math.sqrt((var9.x - var8.x) * (var9.x - var8.x) + (var9.z - var8.z) * (var9.z - var8.z));
            double var12 = var8.x + 13.0 / var10 * (var9.x - var8.x);
            double var14 = var8.z + 13.0 / var10 * (var9.z - var8.z);
            if (!(var10 <= 64.0) && !var3.contains(var7)) continue;
            var7.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RAID_HORN, SoundCategory.NEUTRAL, var12, var7.getY(), var14, 64.0f, 1.0f, var4));
        }
    }

    private void spawnGroup(BlockPosition var0) {
        boolean var1 = false;
        int var2 = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyDamageScaler var3 = this.level.getCurrentDifficultyAt(var0);
        boolean var4 = this.shouldSpawnBonusGroup();
        for (Wave var8 : Wave.VALUES) {
            EntityRaider var12;
            int var9 = this.getDefaultNumSpawns(var8, var2, var4) + this.getPotentialBonusSpawns(var8, this.random, var2, var3, var4);
            int var10 = 0;
            for (int var11 = 0; var11 < var9 && (var12 = var8.entityType.create(this.level, EntitySpawnReason.EVENT)) != null; ++var11) {
                if (!var1 && var12.canBeLeader()) {
                    var12.setPatrolLeader(true);
                    this.setLeader(var2, var12);
                    var1 = true;
                }
                this.joinRaid(var2, var12, var0, false);
                if (var8.entityType != EntityTypes.RAVAGER) continue;
                EntityRaider var13 = null;
                if (var2 == this.getNumGroups(EnumDifficulty.NORMAL)) {
                    var13 = EntityTypes.PILLAGER.create(this.level, EntitySpawnReason.EVENT);
                } else if (var2 >= this.getNumGroups(EnumDifficulty.HARD)) {
                    var13 = var10 == 0 ? (EntityRaider)EntityTypes.EVOKER.create(this.level, EntitySpawnReason.EVENT) : (EntityRaider)EntityTypes.VINDICATOR.create(this.level, EntitySpawnReason.EVENT);
                }
                ++var10;
                if (var13 == null) continue;
                this.joinRaid(var2, var13, var0, false);
                var13.moveTo(var0, 0.0f, 0.0f);
                var13.startRiding(var12);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
    }

    public void joinRaid(int var0, EntityRaider var1, @Nullable BlockPosition var2, boolean var3) {
        boolean var4 = this.addWaveMob(var0, var1);
        if (var4) {
            var1.setCurrentRaid(this);
            var1.setWave(var0);
            var1.setCanJoinRaid(true);
            var1.setTicksOutsideRaid(0);
            if (!var3 && var2 != null) {
                var1.setPos((double)var2.getX() + 0.5, (double)var2.getY() + 1.0, (double)var2.getZ() + 0.5);
                var1.finalizeSpawn(this.level, this.level.getCurrentDifficultyAt(var2), EntitySpawnReason.EVENT, null);
                var1.applyRaidBuffs(this.level, var0, false);
                var1.setOnGround(true);
                this.level.addFreshEntityWithPassengers(var1);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(MathHelper.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float var0 = 0.0f;
        for (Set<EntityRaider> var2 : this.groupRaiderMap.values()) {
            for (EntityRaider var4 : var2) {
                var0 += var4.getHealth();
            }
        }
        return var0;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(EntityRaider var0, boolean var1) {
        boolean var3;
        Set<EntityRaider> var2 = this.groupRaiderMap.get(var0.getWave());
        if (var2 != null && (var3 = var2.remove(var0))) {
            if (var1) {
                this.totalHealth -= var0.getHealth();
            }
            var0.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        this.level.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<EnumBannerPatternType> var0) {
        ItemStack var1 = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers var2 = new BannerPatternLayers.a().addIfRegistered(var0, BannerPatterns.RHOMBUS_MIDDLE, EnumColor.CYAN).addIfRegistered(var0, BannerPatterns.STRIPE_BOTTOM, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.STRIPE_CENTER, EnumColor.GRAY).addIfRegistered(var0, BannerPatterns.BORDER, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.STRIPE_MIDDLE, EnumColor.BLACK).addIfRegistered(var0, BannerPatterns.HALF_HORIZONTAL, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.CIRCLE_MIDDLE, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.BORDER, EnumColor.BLACK).build();
        var1.set(DataComponents.BANNER_PATTERNS, var2);
        var1.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        var1.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        var1.set(DataComponents.RARITY, EnumItemRarity.UNCOMMON);
        return var1;
    }

    @Nullable
    public EntityRaider getLeader(int var0) {
        return this.groupToLeaderMap.get(var0);
    }

    @Nullable
    private BlockPosition findRandomSpawnPos(int var0) {
        int var1 = this.raidCooldownTicks / 20;
        float var2 = 0.22f * (float)var1 - 0.24f;
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        float var7 = this.level.random.nextFloat() * ((float)Math.PI * 2);
        for (int var8 = 0; var8 < var0; ++var8) {
            int var5;
            float var9 = var7 + (float)Math.PI * (float)var8 / 8.0f;
            int var3 = this.center.getX() + MathHelper.floor(MathHelper.cos(var9) * 32.0f * var2) + this.level.random.nextInt(3) * MathHelper.floor(var2);
            int var4 = this.level.getHeight(HeightMap.Type.WORLD_SURFACE, var3, var5 = this.center.getZ() + MathHelper.floor(MathHelper.sin(var9) * 32.0f * var2) + this.level.random.nextInt(3) * MathHelper.floor(var2));
            if (MathHelper.abs(var4 - this.center.getY()) > 96) continue;
            var6.set(var3, var4, var5);
            if (this.level.isVillage(var6) && var1 > 7) continue;
            int var10 = 10;
            if (!this.level.hasChunksAt(var6.getX() - 10, var6.getZ() - 10, var6.getX() + 10, var6.getZ() + 10) || !this.level.isPositionEntityTicking(var6) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(this.level, var6, EntityTypes.RAVAGER) && (!this.level.getBlockState((BlockPosition)var6.below()).is(Blocks.SNOW) || !this.level.getBlockState(var6).isAir())) continue;
            return var6;
        }
        return null;
    }

    private boolean addWaveMob(int var0, EntityRaider var1) {
        return this.addWaveMob(var0, var1, true);
    }

    public boolean addWaveMob(int var02, EntityRaider var1, boolean var2) {
        this.groupRaiderMap.computeIfAbsent(var02, var0 -> Sets.newHashSet());
        Set<EntityRaider> var3 = this.groupRaiderMap.get(var02);
        EntityRaider var4 = null;
        for (EntityRaider var6 : var3) {
            if (!var6.getUUID().equals(var1.getUUID())) continue;
            var4 = var6;
            break;
        }
        if (var4 != null) {
            var3.remove(var4);
            var3.add(var1);
        }
        var3.add(var1);
        if (var2) {
            this.totalHealth += var1.getHealth();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int var0, EntityRaider var1) {
        this.groupToLeaderMap.put(var0, var1);
        var1.setItemSlot(EnumItemSlot.HEAD, Raid.getOminousBannerInstance(var1.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        var1.setDropChance(EnumItemSlot.HEAD, 2.0f);
    }

    public void removeLeader(int var0) {
        this.groupToLeaderMap.remove(var0);
    }

    public BlockPosition getCenter() {
        return this.center;
    }

    private void setCenter(BlockPosition var0) {
        this.center = var0;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(Wave var0, int var1, boolean var2) {
        return var2 ? var0.spawnsPerWaveBeforeBonus[this.numGroups] : var0.spawnsPerWaveBeforeBonus[var1];
    }

    private int getPotentialBonusSpawns(Wave var0, RandomSource var1, int var2, DifficultyDamageScaler var3, boolean var4) {
        int var8;
        EnumDifficulty var5 = var3.getDifficulty();
        boolean var6 = var5 == EnumDifficulty.EASY;
        boolean var7 = var5 == EnumDifficulty.NORMAL;
        switch (var0.ordinal()) {
            case 3: {
                if (!var6 && var2 > 2 && var2 != 4) {
                    var8 = 1;
                    break;
                }
                return 0;
            }
            case 0: 
            case 2: {
                if (var6) {
                    var8 = var1.nextInt(2);
                    break;
                }
                if (var7) {
                    var8 = 1;
                    break;
                }
                var8 = 2;
                break;
            }
            case 4: {
                var8 = !var6 && var4 ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return var8 > 0 ? var1.nextInt(var8 + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putInt("Id", this.id);
        var0.putBoolean("Started", this.started);
        var0.putBoolean("Active", this.active);
        var0.putLong("TicksActive", this.ticksActive);
        var0.putInt("BadOmenLevel", this.raidOmenLevel);
        var0.putInt("GroupsSpawned", this.groupsSpawned);
        var0.putInt("PreRaidTicks", this.raidCooldownTicks);
        var0.putInt("PostRaidTicks", this.postRaidTicks);
        var0.putFloat("TotalHealth", this.totalHealth);
        var0.putInt("NumGroups", this.numGroups);
        var0.putString("Status", this.status.getName());
        var0.putInt("CX", this.center.getX());
        var0.putInt("CY", this.center.getY());
        var0.putInt("CZ", this.center.getZ());
        NBTTagList var1 = new NBTTagList();
        for (UUID var3 : this.heroesOfTheVillage) {
            var1.add(GameProfileSerializer.createUUID(var3));
        }
        var0.put("HeroesOfTheVillage", var1);
        return var0;
    }

    public int getNumGroups(EnumDifficulty var0) {
        switch (var0) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int var0 = this.getRaidOmenLevel();
        if (var0 == 2) {
            return 0.1f;
        }
        if (var0 == 3) {
            return 0.25f;
        }
        if (var0 == 4) {
            return 0.5f;
        }
        if (var0 == 5) {
            return 0.75f;
        }
        return 0.0f;
    }

    public void addHeroOfTheVillage(Entity var0) {
        this.heroesOfTheVillage.add(var0.getUUID());
    }

    static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status ONGOING = new Status();
        public static final /* enum */ Status VICTORY = new Status();
        public static final /* enum */ Status LOSS = new Status();
        public static final /* enum */ Status STOPPED = new Status();
        private static final Status[] VALUES;
        private static final /* synthetic */ Status[] f;

        public static Status[] values() {
            return (Status[])f.clone();
        }

        public static Status valueOf(String var0) {
            return Enum.valueOf(Status.class, var0);
        }

        static Status getByName(String var0) {
            for (Status var4 : VALUES) {
                if (!var0.equalsIgnoreCase(var4.name())) continue;
                return var4;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ Status[] b() {
            return new Status[]{ONGOING, VICTORY, LOSS, STOPPED};
        }

        static {
            f = Status.b();
            VALUES = Status.values();
        }
    }

    static final class Wave
    extends Enum<Wave> {
        public static final /* enum */ Wave VINDICATOR = new Wave(EntityTypes.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5});
        public static final /* enum */ Wave EVOKER = new Wave(EntityTypes.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        public static final /* enum */ Wave PILLAGER = new Wave(EntityTypes.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2});
        public static final /* enum */ Wave WITCH = new Wave(EntityTypes.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1});
        public static final /* enum */ Wave RAVAGER = new Wave(EntityTypes.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});
        static final Wave[] VALUES;
        final EntityTypes<? extends EntityRaider> entityType;
        final int[] spawnsPerWaveBeforeBonus;
        private static final /* synthetic */ Wave[] i;

        public static Wave[] values() {
            return (Wave[])i.clone();
        }

        public static Wave valueOf(String var0) {
            return Enum.valueOf(Wave.class, var0);
        }

        private Wave(EntityTypes var2, int[] var3) {
            this.entityType = var2;
            this.spawnsPerWaveBeforeBonus = var3;
        }

        private static /* synthetic */ Wave[] a() {
            return new Wave[]{VINDICATOR, EVOKER, PILLAGER, WITCH, RAVAGER};
        }

        static {
            i = Wave.a();
            VALUES = Wave.values();
        }
    }
}

