/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.phys.Vec3D;

public class PersistentRaid
extends PersistentBase {
    private static final String RAID_FILE_ID = "raids";
    public final Map<Integer, Raid> raidMap = Maps.newHashMap();
    private final WorldServer level;
    private int nextAvailableID;
    private int tick;

    public static PersistentBase.a<PersistentRaid> factory(WorldServer var0) {
        return new PersistentBase.a<PersistentRaid>(() -> new PersistentRaid(var0), (var1, var2) -> PersistentRaid.load(var0, var1), DataFixTypes.SAVED_DATA_RAIDS);
    }

    public PersistentRaid(WorldServer var0) {
        this.level = var0;
        this.nextAvailableID = 1;
        this.setDirty();
    }

    public Raid get(int var0) {
        return this.raidMap.get(var0);
    }

    public void tick() {
        ++this.tick;
        Iterator<Raid> var0 = this.raidMap.values().iterator();
        while (var0.hasNext()) {
            Raid var1 = var0.next();
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                var1.stop();
            }
            if (var1.isStopped()) {
                var0.remove();
                this.setDirty();
                continue;
            }
            var1.tick();
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
        PacketDebug.sendRaids(this.level, this.raidMap.values());
    }

    public static boolean canJoinRaid(EntityRaider var0, Raid var1) {
        if (var0 != null && var1 != null && var1.getLevel() != null) {
            return var0.isAlive() && var0.canJoinRaid() && var0.getNoActionTime() <= 2400 && var0.level().dimensionType() == var1.getLevel().dimensionType();
        }
        return false;
    }

    @Nullable
    public Raid createOrExtendRaid(EntityPlayer var02, BlockPosition var1) {
        BlockPosition var6;
        if (var02.isSpectator()) {
            return null;
        }
        if (this.level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionManager var2 = var02.level().dimensionType();
        if (!var2.hasRaids()) {
            return null;
        }
        List<VillagePlaceRecord> var3 = this.level.getPoiManager().getInRange(var0 -> var0.is(PoiTypeTags.VILLAGE), var1, 64, VillagePlace.Occupancy.IS_OCCUPIED).toList();
        int var4 = 0;
        Vec3D var5 = Vec3D.ZERO;
        for (VillagePlaceRecord villagePlaceRecord : var3) {
            BlockPosition var8 = villagePlaceRecord.getPos();
            var5 = var5.add(var8.getX(), var8.getY(), var8.getZ());
            ++var4;
        }
        if (var4 > 0) {
            var5 = var5.scale(1.0 / (double)var4);
            var6 = BlockPosition.containing(var5);
        } else {
            var6 = var1;
        }
        Raid raid = this.getOrCreateRaid(var02.serverLevel(), var6);
        if (!raid.isStarted() && !this.raidMap.containsKey(raid.getId())) {
            this.raidMap.put(raid.getId(), raid);
        }
        if (!raid.isStarted() || raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            raid.absorbRaidOmen(var02);
        }
        this.setDirty();
        return raid;
    }

    private Raid getOrCreateRaid(WorldServer var0, BlockPosition var1) {
        Raid var2 = var0.getRaidAt(var1);
        return var2 != null ? var2 : new Raid(this.getUniqueId(), var0, var1);
    }

    public static PersistentRaid load(WorldServer var0, NBTTagCompound var1) {
        PersistentRaid var2 = new PersistentRaid(var0);
        var2.nextAvailableID = var1.getInt("NextAvailableID");
        var2.tick = var1.getInt("Tick");
        NBTTagList var3 = var1.getList("Raids", 10);
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            NBTTagCompound var5 = var3.getCompound(var4);
            Raid var6 = new Raid(var0, var5);
            var2.raidMap.put(var6.getId(), var6);
        }
        return var2;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0, HolderLookup.a var1) {
        var0.putInt("NextAvailableID", this.nextAvailableID);
        var0.putInt("Tick", this.tick);
        NBTTagList var2 = new NBTTagList();
        for (Raid var4 : this.raidMap.values()) {
            NBTTagCompound var5 = new NBTTagCompound();
            var4.save(var5);
            var2.add(var5);
        }
        var0.put("Raids", var2);
        return var0;
    }

    public static String getFileId(Holder<DimensionManager> var0) {
        if (var0.is(BuiltinDimensionTypes.END)) {
            return "raids_end";
        }
        return RAID_FILE_ID;
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPosition var0, int var1) {
        Raid var2 = null;
        double var3 = var1;
        for (Raid var6 : this.raidMap.values()) {
            double var7 = var6.getCenter().distSqr(var0);
            if (!var6.isActive() || !(var7 < var3)) continue;
            var2 = var6;
            var3 = var7;
        }
        return var2;
    }
}

