/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityPotion
extends EntityProjectileThrowable {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<EntityLiving> WATER_SENSITIVE_OR_ON_FIRE = var0 -> var0.isSensitiveToWater() || var0.isOnFire();

    public EntityPotion(EntityTypes<? extends EntityPotion> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityPotion(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.POTION, var1, var0, var2);
    }

    public EntityPotion(World var0, double var1, double var3, double var5, ItemStack var7) {
        super(EntityTypes.POTION, var1, var3, var5, var0, var7);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        EnumDirection var2 = var0.getDirection();
        BlockPosition var3 = var0.getBlockPos();
        BlockPosition var4 = var3.relative(var2);
        PotionContents var5 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if (var5.is(Potions.WATER)) {
            this.dowseFire(var4);
            this.dowseFire(var4.relative(var2.getOpposite()));
            for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                this.dowseFire(var4.relative(var7));
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        ItemStack var2 = this.getItem();
        PotionContents var3 = var2.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if (var3.is(Potions.WATER)) {
            this.applyWater(var1);
        } else if (var3.hasEffects()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud(var3);
            } else {
                this.applySplash(var1, var3.getAllEffects(), var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY ? ((MovingObjectPositionEntity)var0).getEntity() : null);
            }
        }
        int var4 = var3.potion().isPresent() && var3.potion().get().value().hasInstantEffects() ? 2007 : 2002;
        var1.levelEvent(var4, this.blockPosition(), var3.getColor());
        this.discard();
    }

    private void applyWater(WorldServer var0) {
        AxisAlignedBB var1 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var2 = this.level().getEntitiesOfClass(EntityLiving.class, var1, WATER_SENSITIVE_OR_ON_FIRE);
        for (EntityLiving var4 : var2) {
            double var5 = this.distanceToSqr(var4);
            if (!(var5 < 16.0)) continue;
            if (var4.isSensitiveToWater()) {
                var4.hurtServer(var0, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!var4.isOnFire() || !var4.isAlive()) continue;
            var4.extinguishFire();
        }
        List<Axolotl> var3 = this.level().getEntitiesOfClass(Axolotl.class, var1);
        for (Axolotl var5 : var3) {
            var5.rehydrate();
        }
    }

    private void applySplash(WorldServer var0, Iterable<MobEffect> var1, @Nullable Entity var22) {
        AxisAlignedBB var3 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var4 = var0.getEntitiesOfClass(EntityLiving.class, var3);
        if (!var4.isEmpty()) {
            Entity var5 = this.getEffectSource();
            for (EntityLiving var7 : var4) {
                double var8;
                if (!var7.isAffectedByPotions() || !((var8 = this.distanceToSqr(var7)) < 16.0)) continue;
                double var10 = var7 == var22 ? 1.0 : 1.0 - Math.sqrt(var8) / 4.0;
                for (MobEffect var13 : var1) {
                    Holder<MobEffectList> var14 = var13.getEffect();
                    if (var14.value().isInstantenous()) {
                        var14.value().applyInstantenousEffect(var0, this, this.getOwner(), var7, var13.getAmplifier(), var10);
                        continue;
                    }
                    int var15 = var13.mapDuration(var2 -> (int)(var10 * (double)var2 + 0.5));
                    MobEffect var16 = new MobEffect(var14, var15, var13.getAmplifier(), var13.isAmbient(), var13.isVisible());
                    if (var16.endsWithin(20)) continue;
                    var7.addEffect(var16, var5);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents var0) {
        EntityAreaEffectCloud var1 = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            EntityLiving var2 = (EntityLiving)entity;
            var1.setOwner(var2);
        }
        var1.setRadius(3.0f);
        var1.setRadiusOnUse(-0.5f);
        var1.setWaitTime(10);
        var1.setRadiusPerTick(-var1.getRadius() / (float)var1.getDuration());
        var1.setPotionContents(var0);
        this.level().addFreshEntity(var1);
    }

    public boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPosition var0) {
        IBlockData var1 = this.level().getBlockState(var0);
        if (var1.is(TagsBlock.FIRE)) {
            this.level().destroyBlock(var0, false, this);
        } else if (AbstractCandleBlock.isLit(var1)) {
            AbstractCandleBlock.extinguish(null, var1, this.level(), var0);
        } else if (BlockCampfire.isLitCampfire(var1)) {
            this.level().levelEvent(null, 1009, var0, 0);
            BlockCampfire.dowse(this.getOwner(), this.level(), var0, var1);
            this.level().setBlockAndUpdate(var0, (IBlockData)var1.setValue(BlockCampfire.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving var0, DamageSource var1) {
        double var2 = var0.position().x - this.position().x;
        double var4 = var0.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)var2, (double)var4);
    }
}

