/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityLargeFireball
extends EntityFireballFireball {
    public int explosionPower = 1;

    public EntityLargeFireball(EntityTypes<? extends EntityLargeFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireballFireball>)var0, var1);
    }

    public EntityLargeFireball(World var0, EntityLiving var1, Vec3D var2, int var3) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.FIREBALL, var1, var2, var0);
        this.explosionPower = var3;
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            boolean var2 = var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.explosionPower, var2, World.a.MOB);
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Entity var2 = var0.getEntity();
        Entity var3 = this.getOwner();
        DamageSource var4 = this.damageSources().fireball(this, var3);
        var2.hurtServer(var1, var4, 6.0f);
        EnchantmentManager.doPostAttackEffects(var1, var2, var4);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("ExplosionPower", 99)) {
            this.explosionPower = var0.getByte("ExplosionPower");
        }
    }
}

