/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityFireball
extends IProjectile {
    public static final double INITAL_ACCELERATION_POWER = 0.1;
    public static final double DEFLECTION_SCALE = 0.5;
    public double accelerationPower = 0.1;

    protected EntityFireball(EntityTypes<? extends EntityFireball> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> var0, double var1, double var3, double var5, Vec3D var7, World var8) {
        this(var0, var8);
        this.moveTo(var1, var3, var5, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignDirectionalMovement(var7, this.accelerationPower);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> var0, EntityLiving var1, Vec3D var2, World var3) {
        this(var0, var1.getX(), var1.getY(), var1.getZ(), var2, var3);
        this.setOwner(var1);
        this.setRot(var1.getYRot(), var1.getXRot());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    protected RayTrace.BlockCollisionOption getClipType() {
        return RayTrace.BlockCollisionOption.COLLIDER;
    }

    @Override
    public void tick() {
        Entity var0 = this.getOwner();
        this.applyInertia();
        if (!this.level().isClientSide && (var0 != null && var0.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard();
            return;
        }
        MovingObjectPosition var1 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType());
        Vec3D var2 = var1.getType() != MovingObjectPosition.EnumMovingObjectType.MISS ? var1.getLocation() : this.position().add(this.getDeltaMovement());
        ProjectileHelper.rotateTowardsMovement(this, 0.2f);
        this.setPos(var2);
        this.applyEffectsFromBlocks();
        super.tick();
        if (this.shouldBurn()) {
            this.igniteForSeconds(1.0f);
        }
        if (var1.getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.isAlive()) {
            this.hitTargetOrDeflectSelf(var1);
        }
        this.createParticleTrail();
    }

    private void applyInertia() {
        float var2;
        Vec3D var0 = this.getDeltaMovement();
        Vec3D var1 = this.position();
        if (this.isInWater()) {
            for (int var3 = 0; var3 < 4; ++var3) {
                float var4 = 0.25f;
                this.level().addParticle(Particles.BUBBLE, var1.x - var0.x * 0.25, var1.y - var0.y * 0.25, var1.z - var0.z * 0.25, var0.x, var0.y, var0.z);
            }
            var2 = this.getLiquidInertia();
        } else {
            var2 = this.getInertia();
        }
        this.setDeltaMovement(var0.add(var0.normalize().scale(this.accelerationPower)).scale(var2));
    }

    private void createParticleTrail() {
        ParticleParam var0 = this.getTrailParticle();
        Vec3D var1 = this.position();
        if (var0 != null) {
            this.level().addParticle(var0, var1.x, var1.y + 0.5, var1.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && !var0.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleParam getTrailParticle() {
        return Particles.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putDouble("acceleration_power", this.accelerationPower);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("acceleration_power", 6)) {
            this.accelerationPower = var0.getDouble("acceleration_power");
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public void assignDirectionalMovement(Vec3D var0, double var1) {
        this.setDeltaMovement(var0.normalize().scale(var1));
        this.hasImpulse = true;
    }

    @Override
    protected void onDeflection(@Nullable Entity var0, boolean var1) {
        super.onDeflection(var0, var1);
        this.accelerationPower = var1 ? 0.1 : (this.accelerationPower *= 0.5);
    }
}

