/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.schedule.Activity;

public class CreakingAi {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Creaking>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN);

    static void initCoreActivity(BehaviorController<Creaking> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Creaking>>)ImmutableList.of((Object)new BehaviorSwim<Creaking>(0.8f){

            @Override
            protected boolean checkExtraStartConditions(WorldServer var0, Creaking var1) {
                return var1.canMove() && super.checkExtraStartConditions(var0, (EntityLiving)var1);
            }
        }, (Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    static void initIdleActivity(BehaviorController<Creaking> var02) {
        var02.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Creaking>>)ImmutableList.of(BehaviorAttackTargetSet.create((var0, var1) -> var1.isActive(), (var0, var1) -> var1.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.3f), (Object)2), (Object)Pair.of(BehaviorLookWalk.create(0.3f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))));
    }

    static void initFightActivity(BehaviorController<Creaking> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Creaking>>)ImmutableList.of(BehaviorWalkAwayOutOfRange.create(1.0f), BehaviorAttack.create(Creaking::canMove, 40), BehaviorAttackTargetForget.create()), MemoryModuleType.ATTACK_TARGET);
    }

    public static BehaviorController.b<Creaking> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static BehaviorController<Creaking> makeBrain(BehaviorController<Creaking> var0) {
        CreakingAi.initCoreActivity(var0);
        CreakingAi.initIdleActivity(var0);
        CreakingAi.initFightActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    public static void updateActivity(Creaking var0) {
        if (!var0.canMove()) {
            var0.getBrain().useDefaultActivity();
        } else {
            var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        }
    }
}

