/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class EntityPhantom
extends EntityFlying
implements IMonster {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = MathHelper.ceil(24.166098f);
    private static final DataWatcherObject<Integer> ID_SIZE = DataWatcher.defineId(EntityPhantom.class, DataWatcherRegistry.INT);
    Vec3D moveTargetPoint = Vec3D.ZERO;
    BlockPosition anchorPoint = BlockPosition.ZERO;
    AttackPhase attackPhase = AttackPhase.CIRCLE;

    public EntityPhantom(EntityTypes<? extends EntityPhantom> var0, World var1) {
        super((EntityTypes<? extends EntityFlying>)var0, var1);
        this.xpReward = 5;
        this.moveControl = new g(this);
        this.lookControl = new f(this);
    }

    @Override
    public boolean isFlapping() {
        return (this.getUniqueFlapTickOffset() + this.tickCount) % TICKS_PER_FLAP == 0;
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new d(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new c());
        this.goalSelector.addGoal(2, new i());
        this.goalSelector.addGoal(3, new e());
        this.targetSelector.addGoal(1, new b());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(ID_SIZE, 0);
    }

    public void setPhantomSize(int var0) {
        this.entityData.set(ID_SIZE, MathHelper.clamp(var0, 0, 64));
    }

    private void updatePhantomSizeInfo() {
        this.refreshDimensions();
        this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(6 + this.getPhantomSize());
    }

    public int getPhantomSize() {
        return this.entityData.get(ID_SIZE);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (ID_SIZE.equals(var0)) {
            this.updatePhantomSizeInfo();
        }
        super.onSyncedDataUpdated(var0);
    }

    public int getUniqueFlapTickOffset() {
        return this.getId() * 3;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float var0 = MathHelper.cos((float)(this.getUniqueFlapTickOffset() + this.tickCount) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            float var1 = MathHelper.cos((float)(this.getUniqueFlapTickOffset() + this.tickCount + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            if (var0 > 0.0f && var1 <= 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.PHANTOM_FLAP, this.getSoundSource(), 0.95f + this.random.nextFloat() * 0.05f, 0.95f + this.random.nextFloat() * 0.05f, false);
            }
            float var2 = this.getBbWidth() * 1.48f;
            float var3 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * var2;
            float var4 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)) * var2;
            float var5 = (0.3f + var0 * 0.45f) * this.getBbHeight() * 2.5f;
            this.level().addParticle(Particles.MYCELIUM, this.getX() + (double)var3, this.getY() + (double)var5, this.getZ() + (double)var4, 0.0, 0.0, 0.0);
            this.level().addParticle(Particles.MYCELIUM, this.getX() - (double)var3, this.getY() + (double)var5, this.getZ() - (double)var4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void aiStep() {
        if (this.isAlive() && this.isSunBurnTick()) {
            this.igniteForSeconds(8.0f);
        }
        super.aiStep();
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        this.anchorPoint = this.blockPosition().above(5);
        this.setPhantomSize(0);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("AX")) {
            this.anchorPoint = new BlockPosition(var0.getInt("AX"), var0.getInt("AY"), var0.getInt("AZ"));
        }
        this.setPhantomSize(var0.getInt("Size"));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("AX", this.anchorPoint.getX());
        var0.putInt("AY", this.anchorPoint.getY());
        var0.putInt("AZ", this.anchorPoint.getZ());
        var0.putInt("Size", this.getPhantomSize());
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return true;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.PHANTOM_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PHANTOM_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PHANTOM_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 1.0f;
    }

    @Override
    public boolean canAttackType(EntityTypes<?> var0) {
        return true;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        int var1 = this.getPhantomSize();
        EntitySize var2 = super.getDefaultDimensions(var0);
        return var2.scale(1.0f + 0.15f * (float)var1);
    }

    boolean canAttack(WorldServer var0, EntityLiving var1, PathfinderTargetCondition var2) {
        return var2.test(var0, this, var1);
    }

    static final class AttackPhase
    extends Enum<AttackPhase> {
        public static final /* enum */ AttackPhase CIRCLE = new AttackPhase();
        public static final /* enum */ AttackPhase SWOOP = new AttackPhase();
        private static final /* synthetic */ AttackPhase[] c;

        public static AttackPhase[] values() {
            return (AttackPhase[])c.clone();
        }

        public static AttackPhase valueOf(String var0) {
            return Enum.valueOf(AttackPhase.class, var0);
        }

        private static /* synthetic */ AttackPhase[] a() {
            return new AttackPhase[]{CIRCLE, SWOOP};
        }

        static {
            c = AttackPhase.a();
        }
    }

    class g
    extends ControllerMove {
        private float speed;

        public g(EntityInsentient var1) {
            super(var1);
            this.speed = 0.1f;
        }

        @Override
        public void tick() {
            if (EntityPhantom.this.horizontalCollision) {
                EntityPhantom.this.setYRot(EntityPhantom.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            double var0 = EntityPhantom.this.moveTargetPoint.x - EntityPhantom.this.getX();
            double var2 = EntityPhantom.this.moveTargetPoint.y - EntityPhantom.this.getY();
            double var4 = EntityPhantom.this.moveTargetPoint.z - EntityPhantom.this.getZ();
            double var6 = Math.sqrt(var0 * var0 + var4 * var4);
            if (Math.abs(var6) > (double)1.0E-5f) {
                double var8 = 1.0 - Math.abs(var2 * (double)0.7f) / var6;
                var6 = Math.sqrt((var0 *= var8) * var0 + (var4 *= var8) * var4);
                double var10 = Math.sqrt(var0 * var0 + var4 * var4 + var2 * var2);
                float var12 = EntityPhantom.this.getYRot();
                float var13 = (float)MathHelper.atan2(var4, var0);
                float var14 = MathHelper.wrapDegrees(EntityPhantom.this.getYRot() + 90.0f);
                float var15 = MathHelper.wrapDegrees(var13 * 57.295776f);
                EntityPhantom.this.setYRot(MathHelper.approachDegrees(var14, var15, 4.0f) - 90.0f);
                EntityPhantom.this.yBodyRot = EntityPhantom.this.getYRot();
                this.speed = MathHelper.degreesDifferenceAbs(var12, EntityPhantom.this.getYRot()) < 3.0f ? MathHelper.approach(this.speed, 1.8f, 0.005f * (1.8f / this.speed)) : MathHelper.approach(this.speed, 0.2f, 0.025f);
                float var16 = (float)(-(MathHelper.atan2(-var2, var6) * 57.2957763671875));
                EntityPhantom.this.setXRot(var16);
                float var17 = EntityPhantom.this.getYRot() + 90.0f;
                double var18 = (double)(this.speed * MathHelper.cos(var17 * ((float)Math.PI / 180))) * Math.abs(var0 / var10);
                double var20 = (double)(this.speed * MathHelper.sin(var17 * ((float)Math.PI / 180))) * Math.abs(var4 / var10);
                double var22 = (double)(this.speed * MathHelper.sin(var16 * ((float)Math.PI / 180))) * Math.abs(var2 / var10);
                Vec3D var24 = EntityPhantom.this.getDeltaMovement();
                EntityPhantom.this.setDeltaMovement(var24.add(new Vec3D(var18, var22, var20).subtract(var24).scale(0.2)));
            }
        }
    }

    static class f
    extends ControllerLook {
        public f(EntityInsentient var0) {
            super(var0);
        }

        @Override
        public void tick() {
        }
    }

    class d
    extends EntityAIBodyControl {
        public d(EntityInsentient var1) {
            super(var1);
        }

        @Override
        public void clientTick() {
            EntityPhantom.this.yHeadRot = EntityPhantom.this.yBodyRot;
            EntityPhantom.this.yBodyRot = EntityPhantom.this.getYRot();
        }
    }

    class c
    extends PathfinderGoal {
        private int nextSweepTick;

        c() {
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = EntityPhantom.this.getTarget();
            if (var0 != null) {
                return EntityPhantom.this.canAttack(c.getServerLevel(EntityPhantom.this.level()), var0, PathfinderTargetCondition.DEFAULT);
            }
            return false;
        }

        @Override
        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            EntityPhantom.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        @Override
        public void stop() {
            EntityPhantom.this.anchorPoint = EntityPhantom.this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, EntityPhantom.this.anchorPoint).above(10 + EntityPhantom.this.random.nextInt(20));
        }

        @Override
        public void tick() {
            if (EntityPhantom.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    EntityPhantom.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + EntityPhantom.this.random.nextInt(4)) * 20);
                    EntityPhantom.this.playSound(SoundEffects.PHANTOM_SWOOP, 10.0f, 0.95f + EntityPhantom.this.random.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            EntityPhantom.this.anchorPoint = EntityPhantom.this.getTarget().blockPosition().above(20 + EntityPhantom.this.random.nextInt(20));
            if (EntityPhantom.this.anchorPoint.getY() < EntityPhantom.this.level().getSeaLevel()) {
                EntityPhantom.this.anchorPoint = new BlockPosition(EntityPhantom.this.anchorPoint.getX(), EntityPhantom.this.level().getSeaLevel() + 1, EntityPhantom.this.anchorPoint.getZ());
            }
        }
    }

    class i
    extends h {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        i() {
        }

        @Override
        public boolean canUse() {
            return EntityPhantom.this.getTarget() != null && EntityPhantom.this.attackPhase == AttackPhase.SWOOP;
        }

        @Override
        public boolean canContinueToUse() {
            Object var1;
            EntityLiving var0 = EntityPhantom.this.getTarget();
            if (var0 == null) {
                return false;
            }
            if (!var0.isAlive()) {
                return false;
            }
            if (var0 instanceof EntityHuman) {
                var1 = (EntityHuman)var0;
                if (var0.isSpectator() || ((EntityHuman)var1).isCreative()) {
                    return false;
                }
            }
            if (!this.canUse()) {
                return false;
            }
            if (EntityPhantom.this.tickCount > this.catSearchTick) {
                this.catSearchTick = EntityPhantom.this.tickCount + 20;
                var1 = EntityPhantom.this.level().getEntitiesOfClass(EntityCat.class, EntityPhantom.this.getBoundingBox().inflate(16.0), IEntitySelector.ENTITY_STILL_ALIVE);
                Iterator iterator = var1.iterator();
                while (iterator.hasNext()) {
                    EntityCat var3 = (EntityCat)iterator.next();
                    var3.hiss();
                }
                this.isScaredOfCat = !var1.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            EntityPhantom.this.setTarget(null);
            EntityPhantom.this.attackPhase = AttackPhase.CIRCLE;
        }

        @Override
        public void tick() {
            EntityLiving var0 = EntityPhantom.this.getTarget();
            if (var0 == null) {
                return;
            }
            EntityPhantom.this.moveTargetPoint = new Vec3D(var0.getX(), var0.getY(0.5), var0.getZ());
            if (EntityPhantom.this.getBoundingBox().inflate(0.2f).intersects(var0.getBoundingBox())) {
                EntityPhantom.this.doHurtTarget(i.getServerLevel(EntityPhantom.this.level()), var0);
                EntityPhantom.this.attackPhase = AttackPhase.CIRCLE;
                if (!EntityPhantom.this.isSilent()) {
                    EntityPhantom.this.level().levelEvent(1039, EntityPhantom.this.blockPosition(), 0);
                }
            } else if (EntityPhantom.this.horizontalCollision || EntityPhantom.this.hurtTime > 0) {
                EntityPhantom.this.attackPhase = AttackPhase.CIRCLE;
            }
        }
    }

    class e
    extends h {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        e() {
        }

        @Override
        public boolean canUse() {
            return EntityPhantom.this.getTarget() == null || EntityPhantom.this.attackPhase == AttackPhase.CIRCLE;
        }

        @Override
        public void start() {
            this.distance = 5.0f + EntityPhantom.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + EntityPhantom.this.random.nextFloat() * 9.0f;
            this.clockwise = EntityPhantom.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        @Override
        public void tick() {
            if (EntityPhantom.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + EntityPhantom.this.random.nextFloat() * 9.0f;
            }
            if (EntityPhantom.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (EntityPhantom.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = EntityPhantom.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (EntityPhantom.this.moveTargetPoint.y < EntityPhantom.this.getY() && !EntityPhantom.this.level().isEmptyBlock(EntityPhantom.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (EntityPhantom.this.moveTargetPoint.y > EntityPhantom.this.getY() && !EntityPhantom.this.level().isEmptyBlock(EntityPhantom.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPosition.ZERO.equals(EntityPhantom.this.anchorPoint)) {
                EntityPhantom.this.anchorPoint = EntityPhantom.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            EntityPhantom.this.moveTargetPoint = Vec3D.atLowerCornerOf(EntityPhantom.this.anchorPoint).add(this.distance * MathHelper.cos(this.angle), -4.0f + this.height, this.distance * MathHelper.sin(this.angle));
        }
    }

    class b
    extends PathfinderGoal {
        private final PathfinderTargetCondition attackTargeting = PathfinderTargetCondition.forCombat().range(64.0);
        private int nextScanTick = b.reducedTickDelay(20);

        b() {
        }

        @Override
        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = b.reducedTickDelay(60);
            WorldServer var0 = b.getServerLevel(EntityPhantom.this.level());
            List<EntityHuman> var1 = var0.getNearbyPlayers(this.attackTargeting, EntityPhantom.this, EntityPhantom.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!var1.isEmpty()) {
                var1.sort(Comparator.comparing(Entity::getY).reversed());
                for (EntityHuman var3 : var1) {
                    if (!EntityPhantom.this.canAttack(var0, var3, PathfinderTargetCondition.DEFAULT)) continue;
                    EntityPhantom.this.setTarget(var3);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving var0 = EntityPhantom.this.getTarget();
            if (var0 != null) {
                return EntityPhantom.this.canAttack(b.getServerLevel(EntityPhantom.this.level()), var0, PathfinderTargetCondition.DEFAULT);
            }
            return false;
        }
    }

    abstract class h
    extends PathfinderGoal {
        public h() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        protected boolean touchingTarget() {
            return EntityPhantom.this.moveTargetPoint.distanceToSqr(EntityPhantom.this.getX(), EntityPhantom.this.getY(), EntityPhantom.this.getZ()) < 4.0;
        }
    }
}

