/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.level.World;

public abstract class EntityIllagerWizard
extends EntityIllagerAbstract {
    private static final DataWatcherObject<Byte> DATA_SPELL_CASTING_ID = DataWatcher.defineId(EntityIllagerWizard.class, DataWatcherRegistry.BYTE);
    protected int spellCastingTickCount;
    private Spell currentSpell = Spell.NONE;

    protected EntityIllagerWizard(EntityTypes<? extends EntityIllagerWizard> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerAbstract>)var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_SPELL_CASTING_ID, (byte)0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.spellCastingTickCount = var0.getInt("SpellTicks");
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("SpellTicks", this.spellCastingTickCount);
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        if (this.isCastingSpell()) {
            return EntityIllagerAbstract.a.SPELLCASTING;
        }
        if (this.isCelebrating()) {
            return EntityIllagerAbstract.a.CELEBRATING;
        }
        return EntityIllagerAbstract.a.CROSSED;
    }

    public boolean isCastingSpell() {
        if (this.level().isClientSide) {
            return this.entityData.get(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(Spell var0) {
        this.currentSpell = var0;
        this.entityData.set(DATA_SPELL_CASTING_ID, (byte)var0.id);
    }

    public Spell getCurrentSpell() {
        if (!this.level().isClientSide) {
            return this.currentSpell;
        }
        return Spell.byId(this.entityData.get(DATA_SPELL_CASTING_ID).byteValue());
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        super.customServerAiStep(var0);
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isCastingSpell()) {
            Spell var0 = this.getCurrentSpell();
            float var1 = (float)var0.spellColor[0];
            float var2 = (float)var0.spellColor[1];
            float var3 = (float)var0.spellColor[2];
            float var4 = this.yBodyRot * ((float)Math.PI / 180) + MathHelper.cos((float)this.tickCount * 0.6662f) * 0.25f;
            float var5 = MathHelper.cos(var4);
            float var6 = MathHelper.sin(var4);
            double var7 = 0.6 * (double)this.getScale();
            double var9 = 1.8 * (double)this.getScale();
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, var1, var2, var3), this.getX() + (double)var5 * var7, this.getY() + var9, this.getZ() + (double)var6 * var7, 0.0, 0.0, 0.0);
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, var1, var2, var3), this.getX() - (double)var5 * var7, this.getY() + var9, this.getZ() - (double)var6 * var7, 0.0, 0.0, 0.0);
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract SoundEffect getCastingSoundEvent();

    public static final class Spell
    extends Enum<Spell> {
        public static final /* enum */ Spell NONE = new Spell(0, 0.0, 0.0, 0.0);
        public static final /* enum */ Spell SUMMON_VEX = new Spell(1, 0.7, 0.7, 0.8);
        public static final /* enum */ Spell FANGS = new Spell(2, 0.4, 0.3, 0.35);
        public static final /* enum */ Spell WOLOLO = new Spell(3, 0.7, 0.5, 0.2);
        public static final /* enum */ Spell DISAPPEAR = new Spell(4, 0.3, 0.3, 0.8);
        public static final /* enum */ Spell BLINDNESS = new Spell(5, 0.1, 0.1, 0.2);
        private static final IntFunction<Spell> BY_ID;
        final int id;
        final double[] spellColor;
        private static final /* synthetic */ Spell[] j;

        public static Spell[] values() {
            return (Spell[])j.clone();
        }

        public static Spell valueOf(String var0) {
            return Enum.valueOf(Spell.class, var0);
        }

        private Spell(int var2, double var3, double var5, double var7) {
            this.id = var2;
            this.spellColor = new double[]{var3, var5, var7};
        }

        public static Spell byId(int var0) {
            return BY_ID.apply(var0);
        }

        private static /* synthetic */ Spell[] a() {
            return new Spell[]{NONE, SUMMON_VEX, FANGS, WOLOLO, DISAPPEAR, BLINDNESS};
        }

        static {
            j = Spell.a();
            BY_ID = ByIdMap.continuous(var0 -> var0.id, Spell.values(), ByIdMap.a.ZERO);
        }
    }

    protected abstract class PathfinderGoalCastSpell
    extends PathfinderGoal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected PathfinderGoalCastSpell() {
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = EntityIllagerWizard.this.getTarget();
            if (var0 == null || !var0.isAlive()) {
                return false;
            }
            if (EntityIllagerWizard.this.isCastingSpell()) {
                return false;
            }
            return EntityIllagerWizard.this.tickCount >= this.nextAttackTickCount;
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving var0 = EntityIllagerWizard.this.getTarget();
            return var0 != null && var0.isAlive() && this.attackWarmupDelay > 0;
        }

        @Override
        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            EntityIllagerWizard.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = EntityIllagerWizard.this.tickCount + this.getCastingInterval();
            SoundEffect var0 = this.getSpellPrepareSound();
            if (var0 != null) {
                EntityIllagerWizard.this.playSound(var0, 1.0f, 1.0f);
            }
            EntityIllagerWizard.this.setIsCastingSpell(this.getSpell());
        }

        @Override
        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                EntityIllagerWizard.this.playSound(EntityIllagerWizard.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEffect getSpellPrepareSound();

        protected abstract Spell getSpell();
    }

    protected class b
    extends PathfinderGoal {
        public b() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityIllagerWizard.this.getSpellCastingTime() > 0;
        }

        @Override
        public void start() {
            super.start();
            EntityIllagerWizard.this.navigation.stop();
        }

        @Override
        public void stop() {
            super.stop();
            EntityIllagerWizard.this.setIsCastingSpell(Spell.NONE);
        }

        @Override
        public void tick() {
            if (EntityIllagerWizard.this.getTarget() != null) {
                EntityIllagerWizard.this.getLookControl().setLookAt(EntityIllagerWizard.this.getTarget(), EntityIllagerWizard.this.getMaxHeadYRot(), EntityIllagerWizard.this.getMaxHeadXRot());
            }
        }
    }
}

