/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.TeleportTransition;

public class EntityTNTPrimed
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<Integer> DATA_FUSE_ID = DataWatcher.defineId(EntityTNTPrimed.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<IBlockData> DATA_BLOCK_STATE_ID = DataWatcher.defineId(EntityTNTPrimed.class, DataWatcherRegistry.BLOCK_STATE);
    private static final int DEFAULT_FUSE_TIME = 80;
    private static final float DEFAULT_EXPLOSION_POWER = 4.0f;
    private static final String TAG_BLOCK_STATE = "block_state";
    public static final String TAG_FUSE = "fuse";
    private static final String TAG_EXPLOSION_POWER = "explosion_power";
    private static final ExplosionDamageCalculator USED_PORTAL_DAMAGE_CALCULATOR = new ExplosionDamageCalculator(){

        @Override
        public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
            if (var3.is(Blocks.NETHER_PORTAL)) {
                return false;
            }
            return super.shouldBlockExplode(var0, var1, var2, var3, var4);
        }

        @Override
        public Optional<Float> getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4) {
            if (var3.is(Blocks.NETHER_PORTAL)) {
                return Optional.empty();
            }
            return super.getBlockExplosionResistance(var0, var1, var2, var3, var4);
        }
    };
    @Nullable
    public EntityLiving owner;
    private boolean usedPortal;
    public float explosionPower = 4.0f;

    public EntityTNTPrimed(EntityTypes<? extends EntityTNTPrimed> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
    }

    public EntityTNTPrimed(World var0, double var1, double var3, double var5, @Nullable EntityLiving var7) {
        this((EntityTypes<? extends EntityTNTPrimed>)EntityTypes.TNT, var0);
        this.setPos(var1, var3, var5);
        double var8 = var0.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(var8) * 0.02, 0.2f, -Math.cos(var8) * 0.02);
        this.setFuse(80);
        this.xo = var1;
        this.yo = var3;
        this.zo = var5;
        this.owner = var7;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_FUSE_ID, 80);
        var0.define(DATA_BLOCK_STATE_ID, Blocks.TNT.defaultBlockState());
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        this.handlePortal();
        this.applyGravity();
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int var0 = this.getFuse() - 1;
        this.setFuse(var0);
        if (var0 <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.level().addParticle(Particles.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        this.level().explode(this, Explosion.getDefaultDamageSource(this.level(), this), this.usedPortal ? USED_PORTAL_DAMAGE_CALCULATOR : null, this.getX(), this.getY(0.0625), this.getZ(), this.explosionPower, false, World.a.TNT);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort(TAG_FUSE, (short)this.getFuse());
        var0.put(TAG_BLOCK_STATE, GameProfileSerializer.writeBlockState(this.getBlockState()));
        if (this.explosionPower != 4.0f) {
            var0.putFloat(TAG_EXPLOSION_POWER, this.explosionPower);
        }
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.setFuse(var0.getShort(TAG_FUSE));
        if (var0.contains(TAG_BLOCK_STATE, 10)) {
            this.setBlockState(GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), var0.getCompound(TAG_BLOCK_STATE)));
        }
        if (var0.contains(TAG_EXPLOSION_POWER, 99)) {
            this.explosionPower = MathHelper.clamp(var0.getFloat(TAG_EXPLOSION_POWER), 0.0f, 128.0f);
        }
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        return this.owner;
    }

    @Override
    public void restoreFrom(Entity var0) {
        super.restoreFrom(var0);
        if (var0 instanceof EntityTNTPrimed) {
            EntityTNTPrimed var1 = (EntityTNTPrimed)var0;
            this.owner = var1.owner;
        }
    }

    public void setFuse(int var0) {
        this.entityData.set(DATA_FUSE_ID, var0);
    }

    public int getFuse() {
        return this.entityData.get(DATA_FUSE_ID);
    }

    public void setBlockState(IBlockData var0) {
        this.entityData.set(DATA_BLOCK_STATE_ID, var0);
    }

    public IBlockData getBlockState() {
        return this.entityData.get(DATA_BLOCK_STATE_ID);
    }

    private void setUsedPortal(boolean var0) {
        this.usedPortal = var0;
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition var0) {
        Entity var1 = super.teleport(var0);
        if (var1 instanceof EntityTNTPrimed) {
            EntityTNTPrimed var2 = (EntityTNTPrimed)var1;
            var2.setUsedPortal(true);
        }
        return var1;
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

