/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;

public abstract class EntityHanging
extends BlockAttachedEntity {
    protected static final Predicate<Entity> HANGING_ENTITY = var0 -> var0 instanceof EntityHanging;
    protected EnumDirection direction = EnumDirection.SOUTH;

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1) {
        super((EntityTypes<? extends BlockAttachedEntity>)var0, var1);
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1, BlockPosition var2) {
        this(var0, var1);
        this.pos = var2;
    }

    public void setDirection(EnumDirection var0) {
        Objects.requireNonNull(var0);
        Validate.isTrue((boolean)var0.getAxis().isHorizontal());
        this.direction = var0;
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected final void recalculateBoundingBox() {
        if (this.direction == null) {
            return;
        }
        AxisAlignedBB var0 = this.calculateBoundingBox(this.pos, this.direction);
        Vec3D var1 = var0.getCenter();
        this.setPosRaw(var1.x, var1.y, var1.z);
        this.setBoundingBox(var0);
    }

    protected abstract AxisAlignedBB calculateBoundingBox(BlockPosition var1, EnumDirection var2);

    @Override
    public boolean survives() {
        if (!this.level().noCollision(this)) {
            return false;
        }
        boolean var02 = BlockPosition.betweenClosedStream(this.calculateSupportBox()).allMatch(var0 -> {
            IBlockData var1 = this.level().getBlockState((BlockPosition)var0);
            return var1.isSolid() || BlockDiodeAbstract.isDiode(var1);
        });
        if (!var02) {
            return false;
        }
        return this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    protected AxisAlignedBB calculateSupportBox() {
        return this.getBoundingBox().move(this.direction.step().mul(-0.5f)).deflate(1.0E-7);
    }

    @Override
    public EnumDirection getDirection() {
        return this.direction;
    }

    public abstract void playPlacementSound();

    @Override
    public EntityItem spawnAtLocation(WorldServer var0, ItemStack var1, float var2) {
        EntityItem var3 = new EntityItem(this.level(), this.getX() + (double)((float)this.direction.getStepX() * 0.15f), this.getY() + (double)var2, this.getZ() + (double)((float)this.direction.getStepZ() * 0.15f), var1);
        var3.setDefaultPickUpDelay();
        this.level().addFreshEntity(var3);
        return var3;
    }

    @Override
    public float rotate(EnumBlockRotation var0) {
        if (this.direction.getAxis() != EnumDirection.EnumAxis.Y) {
            switch (var0) {
                case CLOCKWISE_180: {
                    this.direction = this.direction.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.direction = this.direction.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    this.direction = this.direction.getClockWise();
                    break;
                }
            }
        }
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        return switch (var0) {
            case EnumBlockRotation.CLOCKWISE_180 -> var1 + 180.0f;
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> var1 + 90.0f;
            case EnumBlockRotation.CLOCKWISE_90 -> var1 + 270.0f;
            default -> var1;
        };
    }

    @Override
    public float mirror(EnumBlockMirror var0) {
        return this.rotate(var0.getRotation(this.direction));
    }
}

