/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int checkInterval;
    protected BlockPosition pos;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> var0, World var1) {
        super(var0, var1);
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> var0, World var1, BlockPosition var2) {
        this(var0, var1);
        this.pos = var2;
    }

    protected abstract void recalculateBoundingBox();

    @Override
    public void tick() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.checkBelowWorld();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    this.discard();
                    this.dropItem(var0, null);
                }
            }
        }
    }

    public abstract boolean survives();

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity var0) {
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (!this.level().mayInteract(var1, this.pos)) {
                return true;
            }
            return this.hurtOrSimulate(this.damageSources().playerAttack(var1), 0.0f);
        }
        return false;
    }

    @Override
    public boolean hurtClient(DamageSource var0) {
        return !this.isInvulnerableToBase(var0);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && var1.getEntity() instanceof EntityInsentient) {
            return false;
        }
        if (!this.isRemoved()) {
            this.kill(var0);
            this.markHurt();
            this.dropItem(var0, var1.getEntity());
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion var0) {
        if (var0.shouldAffectBlocklikeEntities()) {
            return super.ignoreExplosion(var0);
        }
        return true;
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            if (!this.isRemoved() && var1.lengthSqr() > 0.0) {
                this.kill(var2);
                this.dropItem(var2, null);
            }
        }
    }

    @Override
    public void push(double var0, double var2, double var4) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var6 = (WorldServer)world;
            if (!this.isRemoved() && var0 * var0 + var2 * var2 + var4 * var4 > 0.0) {
                this.kill(var6);
                this.dropItem(var6, null);
            }
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        BlockPosition var1 = this.getPos();
        var0.putInt("TileX", var1.getX());
        var0.putInt("TileY", var1.getY());
        var0.putInt("TileZ", var1.getZ());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        BlockPosition var1 = new BlockPosition(var0.getInt("TileX"), var0.getInt("TileY"), var0.getInt("TileZ"));
        if (!var1.closerThan(this.blockPosition(), 16.0)) {
            LOGGER.error("Block-attached entity at invalid position: {}", (Object)var1);
            return;
        }
        this.pos = var1;
    }

    public abstract void dropItem(WorldServer var1, @Nullable Entity var2);

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double var0, double var2, double var4) {
        this.pos = BlockPosition.containing(var0, var2, var4);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
    }

    @Override
    public void refreshDimensions() {
    }
}

